/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3EncryptionClientV2;
import com.amazonaws.services.s3.AmazonS3EncryptionClientV2ParamsWrapper;
import com.amazonaws.services.s3.AmazonS3EncryptionV2;
import com.amazonaws.services.s3.model.CryptoConfigurationV2;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;

public final class AmazonS3EncryptionClientV2Builder
extends AmazonS3Builder<AmazonS3EncryptionClientV2Builder, AmazonS3EncryptionV2> {
    private EncryptionMaterialsProvider encryptionMaterialsProvider;
    private CryptoConfigurationV2 cryptoConfig;
    private AWSKMS kmsClient;

    public static AmazonS3EncryptionClientV2Builder standard() {
        return new AmazonS3EncryptionClientV2Builder();
    }

    public void setEncryptionMaterialsProvider(EncryptionMaterialsProvider encryptionMaterialsProvider) {
        this.encryptionMaterialsProvider = encryptionMaterialsProvider;
    }

    public AmazonS3EncryptionClientV2Builder withEncryptionMaterialsProvider(EncryptionMaterialsProvider encryptionMaterialsProvider) {
        this.setEncryptionMaterialsProvider(encryptionMaterialsProvider);
        return this;
    }

    public void setCryptoConfiguration(CryptoConfigurationV2 cryptoConfigurationV2) {
        this.cryptoConfig = cryptoConfigurationV2;
    }

    public AmazonS3EncryptionClientV2Builder withCryptoConfiguration(CryptoConfigurationV2 cryptoConfigurationV2) {
        this.setCryptoConfiguration(cryptoConfigurationV2);
        return this;
    }

    public void setKmsClient(AWSKMS aWSKMS) {
        this.kmsClient = aWSKMS;
    }

    public AmazonS3EncryptionClientV2Builder withKmsClient(AWSKMS aWSKMS) {
        this.setKmsClient(aWSKMS);
        return this;
    }

    @Override
    protected AmazonS3EncryptionV2 build(AwsSyncClientParams awsSyncClientParams) {
        return new AmazonS3EncryptionClientV2(new AmazonS3EncryptionClientV2ParamsWrapper(awsSyncClientParams, this.resolveS3ClientOptions(), this.encryptionMaterialsProvider, this.cryptoConfig != null ? this.cryptoConfig : new CryptoConfigurationV2(), this.kmsClient));
    }
}

