/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.client.builder.AwsSyncClientBuilder;
import com.amazonaws.internal.SdkFunction;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientConfigurationFactory;
import com.amazonaws.services.s3.AmazonS3ClientParamsWrapper;
import com.amazonaws.services.s3.S3ClientOptions;

@NotThreadSafe
public abstract class AmazonS3Builder<Subclass extends AmazonS3Builder, TypeToBuild extends AmazonS3>
extends AwsSyncClientBuilder<Subclass, TypeToBuild> {
    private static final AmazonS3ClientConfigurationFactory CLIENT_CONFIG_FACTORY = new AmazonS3ClientConfigurationFactory();
    private static final SdkFunction<AmazonS3ClientParamsWrapper, AmazonS3> DEFAULT_CLIENT_FACTORY = new SdkFunction<AmazonS3ClientParamsWrapper, AmazonS3>(){

        @Override
        public AmazonS3 apply(AmazonS3ClientParamsWrapper amazonS3ClientParamsWrapper) {
            return new AmazonS3Client(amazonS3ClientParamsWrapper);
        }
    };
    protected final SdkFunction<AmazonS3ClientParamsWrapper, AmazonS3> clientFactory;
    private Boolean pathStyleAccessEnabled;
    private Boolean chunkedEncodingDisabled;
    private Boolean accelerateModeEnabled;
    private Boolean payloadSigningEnabled;
    private Boolean dualstackEnabled;
    private Boolean forceGlobalBucketAccessEnabled;
    private Boolean useArnRegionEnabled;
    private Boolean regionalUsEast1EndpointEnabled;

    protected AmazonS3Builder() {
        super(CLIENT_CONFIG_FACTORY);
        this.clientFactory = DEFAULT_CLIENT_FACTORY;
    }

    @SdkTestInternalApi
    AmazonS3Builder(SdkFunction<AmazonS3ClientParamsWrapper, AmazonS3> sdkFunction, ClientConfigurationFactory clientConfigurationFactory, AwsRegionProvider awsRegionProvider) {
        super(clientConfigurationFactory, awsRegionProvider);
        this.clientFactory = sdkFunction;
    }

    public Boolean isPathStyleAccessEnabled() {
        return this.pathStyleAccessEnabled;
    }

    public void setPathStyleAccessEnabled(Boolean bl) {
        this.pathStyleAccessEnabled = bl;
    }

    public Subclass withPathStyleAccessEnabled(Boolean bl) {
        this.setPathStyleAccessEnabled(bl);
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    public Subclass enablePathStyleAccess() {
        this.setPathStyleAccessEnabled(Boolean.TRUE);
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    public Boolean isChunkedEncodingDisabled() {
        return this.chunkedEncodingDisabled;
    }

    public void setChunkedEncodingDisabled(Boolean bl) {
        this.chunkedEncodingDisabled = bl;
    }

    public Subclass withChunkedEncodingDisabled(Boolean bl) {
        this.setChunkedEncodingDisabled(bl);
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    public Subclass disableChunkedEncoding() {
        this.setChunkedEncodingDisabled(Boolean.TRUE);
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    public Boolean isAccelerateModeEnabled() {
        return this.accelerateModeEnabled;
    }

    public void setAccelerateModeEnabled(Boolean bl) {
        this.accelerateModeEnabled = bl;
    }

    public Subclass withAccelerateModeEnabled(Boolean bl) {
        this.setAccelerateModeEnabled(bl);
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    public Subclass enableAccelerateMode() {
        this.setAccelerateModeEnabled(Boolean.TRUE);
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    public Boolean isPayloadSigningEnabled() {
        return this.payloadSigningEnabled;
    }

    public void setPayloadSigningEnabled(Boolean bl) {
        this.payloadSigningEnabled = bl;
    }

    public Subclass withPayloadSigningEnabled(Boolean bl) {
        this.setPayloadSigningEnabled(bl);
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    public Subclass enablePayloadSigning() {
        this.setPayloadSigningEnabled(Boolean.TRUE);
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    public Boolean isDualstackEnabled() {
        return this.dualstackEnabled;
    }

    public void setDualstackEnabled(Boolean bl) {
        this.dualstackEnabled = bl;
    }

    public Subclass withDualstackEnabled(Boolean bl) {
        this.setDualstackEnabled(bl);
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    public Subclass enableDualstack() {
        this.setDualstackEnabled(Boolean.TRUE);
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    public Boolean isForceGlobalBucketAccessEnabled() {
        return this.forceGlobalBucketAccessEnabled;
    }

    public void setForceGlobalBucketAccessEnabled(Boolean bl) {
        this.forceGlobalBucketAccessEnabled = bl;
    }

    public Subclass withForceGlobalBucketAccessEnabled(Boolean bl) {
        this.setForceGlobalBucketAccessEnabled(bl);
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    public Subclass enableForceGlobalBucketAccess() {
        this.setForceGlobalBucketAccessEnabled(Boolean.TRUE);
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    public Boolean isUseArnRegionEnabled() {
        return this.useArnRegionEnabled;
    }

    public Subclass enableUseArnRegion() {
        this.useArnRegionEnabled = true;
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    public Boolean isRegionalUsEast1EndpointEnabled() {
        return this.regionalUsEast1EndpointEnabled;
    }

    public void setRegionalUsEast1EndpointEnabled(Boolean bl) {
        this.regionalUsEast1EndpointEnabled = bl;
    }

    public Subclass withRegionalUsEast1EndpointEnabled(Boolean bl) {
        this.setRegionalUsEast1EndpointEnabled(bl);
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    public Subclass enableRegionalUsEast1Endpoint() {
        this.setRegionalUsEast1EndpointEnabled(Boolean.TRUE);
        return (Subclass)((AmazonS3Builder)this.getSubclass());
    }

    protected S3ClientOptions resolveS3ClientOptions() {
        S3ClientOptions.Builder builder = S3ClientOptions.builder();
        if (Boolean.TRUE.equals(this.chunkedEncodingDisabled)) {
            builder.disableChunkedEncoding();
        }
        if (this.payloadSigningEnabled != null) {
            builder.setPayloadSigningEnabled(this.payloadSigningEnabled);
        }
        if (this.accelerateModeEnabled != null) {
            builder.setAccelerateModeEnabled(this.accelerateModeEnabled);
        }
        if (this.pathStyleAccessEnabled != null) {
            builder.setPathStyleAccess(this.pathStyleAccessEnabled);
        }
        if (Boolean.TRUE.equals(this.dualstackEnabled)) {
            builder.enableDualstack();
        }
        if (Boolean.TRUE.equals(this.forceGlobalBucketAccessEnabled)) {
            builder.enableForceGlobalBucketAccess();
        }
        if (Boolean.TRUE.equals(this.useArnRegionEnabled)) {
            builder.enableUseArnRegion();
        }
        if (Boolean.TRUE.equals(this.regionalUsEast1EndpointEnabled)) {
            builder.enableRegionalUsEast1Endpoint();
        }
        return builder.build();
    }
}

