/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.kms.model.SigningAlgorithmSpec;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class SignResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String keyId;
    private ByteBuffer signature;
    private String signingAlgorithm;

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public SignResult withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public void setSignature(ByteBuffer byteBuffer) {
        this.signature = byteBuffer;
    }

    public ByteBuffer getSignature() {
        return this.signature;
    }

    public SignResult withSignature(ByteBuffer byteBuffer) {
        this.setSignature(byteBuffer);
        return this;
    }

    public void setSigningAlgorithm(String string) {
        this.signingAlgorithm = string;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public SignResult withSigningAlgorithm(String string) {
        this.setSigningAlgorithm(string);
        return this;
    }

    public SignResult withSigningAlgorithm(SigningAlgorithmSpec signingAlgorithmSpec) {
        this.signingAlgorithm = signingAlgorithmSpec.toString();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getSignature() != null) {
            stringBuilder.append("Signature: ").append(this.getSignature()).append(",");
        }
        if (this.getSigningAlgorithm() != null) {
            stringBuilder.append("SigningAlgorithm: ").append(this.getSigningAlgorithm());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof SignResult)) {
            return false;
        }
        SignResult signResult = (SignResult)object;
        if (signResult.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (signResult.getKeyId() != null && !signResult.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (signResult.getSignature() == null ^ this.getSignature() == null) {
            return false;
        }
        if (signResult.getSignature() != null && !signResult.getSignature().equals(this.getSignature())) {
            return false;
        }
        if (signResult.getSigningAlgorithm() == null ^ this.getSigningAlgorithm() == null) {
            return false;
        }
        return signResult.getSigningAlgorithm() == null || signResult.getSigningAlgorithm().equals(this.getSigningAlgorithm());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getSignature() == null ? 0 : this.getSignature().hashCode());
        n2 = 31 * n2 + (this.getSigningAlgorithm() == null ? 0 : this.getSigningAlgorithm().hashCode());
        return n2;
    }

    public SignResult clone() {
        try {
            return (SignResult)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

