/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.kms.model.EncryptionAlgorithmSpec;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class ReEncryptResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private ByteBuffer ciphertextBlob;
    private String sourceKeyId;
    private String keyId;
    private String sourceEncryptionAlgorithm;
    private String destinationEncryptionAlgorithm;

    public void setCiphertextBlob(ByteBuffer byteBuffer) {
        this.ciphertextBlob = byteBuffer;
    }

    public ByteBuffer getCiphertextBlob() {
        return this.ciphertextBlob;
    }

    public ReEncryptResult withCiphertextBlob(ByteBuffer byteBuffer) {
        this.setCiphertextBlob(byteBuffer);
        return this;
    }

    public void setSourceKeyId(String string) {
        this.sourceKeyId = string;
    }

    public String getSourceKeyId() {
        return this.sourceKeyId;
    }

    public ReEncryptResult withSourceKeyId(String string) {
        this.setSourceKeyId(string);
        return this;
    }

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public ReEncryptResult withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public void setSourceEncryptionAlgorithm(String string) {
        this.sourceEncryptionAlgorithm = string;
    }

    public String getSourceEncryptionAlgorithm() {
        return this.sourceEncryptionAlgorithm;
    }

    public ReEncryptResult withSourceEncryptionAlgorithm(String string) {
        this.setSourceEncryptionAlgorithm(string);
        return this;
    }

    public ReEncryptResult withSourceEncryptionAlgorithm(EncryptionAlgorithmSpec encryptionAlgorithmSpec) {
        this.sourceEncryptionAlgorithm = encryptionAlgorithmSpec.toString();
        return this;
    }

    public void setDestinationEncryptionAlgorithm(String string) {
        this.destinationEncryptionAlgorithm = string;
    }

    public String getDestinationEncryptionAlgorithm() {
        return this.destinationEncryptionAlgorithm;
    }

    public ReEncryptResult withDestinationEncryptionAlgorithm(String string) {
        this.setDestinationEncryptionAlgorithm(string);
        return this;
    }

    public ReEncryptResult withDestinationEncryptionAlgorithm(EncryptionAlgorithmSpec encryptionAlgorithmSpec) {
        this.destinationEncryptionAlgorithm = encryptionAlgorithmSpec.toString();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getCiphertextBlob() != null) {
            stringBuilder.append("CiphertextBlob: ").append(this.getCiphertextBlob()).append(",");
        }
        if (this.getSourceKeyId() != null) {
            stringBuilder.append("SourceKeyId: ").append(this.getSourceKeyId()).append(",");
        }
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getSourceEncryptionAlgorithm() != null) {
            stringBuilder.append("SourceEncryptionAlgorithm: ").append(this.getSourceEncryptionAlgorithm()).append(",");
        }
        if (this.getDestinationEncryptionAlgorithm() != null) {
            stringBuilder.append("DestinationEncryptionAlgorithm: ").append(this.getDestinationEncryptionAlgorithm());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ReEncryptResult)) {
            return false;
        }
        ReEncryptResult reEncryptResult = (ReEncryptResult)object;
        if (reEncryptResult.getCiphertextBlob() == null ^ this.getCiphertextBlob() == null) {
            return false;
        }
        if (reEncryptResult.getCiphertextBlob() != null && !reEncryptResult.getCiphertextBlob().equals(this.getCiphertextBlob())) {
            return false;
        }
        if (reEncryptResult.getSourceKeyId() == null ^ this.getSourceKeyId() == null) {
            return false;
        }
        if (reEncryptResult.getSourceKeyId() != null && !reEncryptResult.getSourceKeyId().equals(this.getSourceKeyId())) {
            return false;
        }
        if (reEncryptResult.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (reEncryptResult.getKeyId() != null && !reEncryptResult.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (reEncryptResult.getSourceEncryptionAlgorithm() == null ^ this.getSourceEncryptionAlgorithm() == null) {
            return false;
        }
        if (reEncryptResult.getSourceEncryptionAlgorithm() != null && !reEncryptResult.getSourceEncryptionAlgorithm().equals(this.getSourceEncryptionAlgorithm())) {
            return false;
        }
        if (reEncryptResult.getDestinationEncryptionAlgorithm() == null ^ this.getDestinationEncryptionAlgorithm() == null) {
            return false;
        }
        return reEncryptResult.getDestinationEncryptionAlgorithm() == null || reEncryptResult.getDestinationEncryptionAlgorithm().equals(this.getDestinationEncryptionAlgorithm());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getCiphertextBlob() == null ? 0 : this.getCiphertextBlob().hashCode());
        n2 = 31 * n2 + (this.getSourceKeyId() == null ? 0 : this.getSourceKeyId().hashCode());
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getSourceEncryptionAlgorithm() == null ? 0 : this.getSourceEncryptionAlgorithm().hashCode());
        n2 = 31 * n2 + (this.getDestinationEncryptionAlgorithm() == null ? 0 : this.getDestinationEncryptionAlgorithm().hashCode());
        return n2;
    }

    public ReEncryptResult clone() {
        try {
            return (ReEncryptResult)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

