/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.kms.model.EncryptionAlgorithmSpec;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ReEncryptRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ByteBuffer ciphertextBlob;
    private SdkInternalMap<String, String> sourceEncryptionContext;
    private String sourceKeyId;
    private String destinationKeyId;
    private SdkInternalMap<String, String> destinationEncryptionContext;
    private String sourceEncryptionAlgorithm;
    private String destinationEncryptionAlgorithm;
    private SdkInternalList<String> grantTokens;

    public void setCiphertextBlob(ByteBuffer byteBuffer) {
        this.ciphertextBlob = byteBuffer;
    }

    public ByteBuffer getCiphertextBlob() {
        return this.ciphertextBlob;
    }

    public ReEncryptRequest withCiphertextBlob(ByteBuffer byteBuffer) {
        this.setCiphertextBlob(byteBuffer);
        return this;
    }

    public Map<String, String> getSourceEncryptionContext() {
        if (this.sourceEncryptionContext == null) {
            this.sourceEncryptionContext = new SdkInternalMap();
        }
        return this.sourceEncryptionContext;
    }

    public void setSourceEncryptionContext(Map<String, String> map) {
        this.sourceEncryptionContext = map == null ? null : new SdkInternalMap<String, String>(map);
    }

    public ReEncryptRequest withSourceEncryptionContext(Map<String, String> map) {
        this.setSourceEncryptionContext(map);
        return this;
    }

    public ReEncryptRequest addSourceEncryptionContextEntry(String string, String string2) {
        if (null == this.sourceEncryptionContext) {
            this.sourceEncryptionContext = new SdkInternalMap();
        }
        if (this.sourceEncryptionContext.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.sourceEncryptionContext.put(string, string2);
        return this;
    }

    public ReEncryptRequest clearSourceEncryptionContextEntries() {
        this.sourceEncryptionContext = null;
        return this;
    }

    public void setSourceKeyId(String string) {
        this.sourceKeyId = string;
    }

    public String getSourceKeyId() {
        return this.sourceKeyId;
    }

    public ReEncryptRequest withSourceKeyId(String string) {
        this.setSourceKeyId(string);
        return this;
    }

    public void setDestinationKeyId(String string) {
        this.destinationKeyId = string;
    }

    public String getDestinationKeyId() {
        return this.destinationKeyId;
    }

    public ReEncryptRequest withDestinationKeyId(String string) {
        this.setDestinationKeyId(string);
        return this;
    }

    public Map<String, String> getDestinationEncryptionContext() {
        if (this.destinationEncryptionContext == null) {
            this.destinationEncryptionContext = new SdkInternalMap();
        }
        return this.destinationEncryptionContext;
    }

    public void setDestinationEncryptionContext(Map<String, String> map) {
        this.destinationEncryptionContext = map == null ? null : new SdkInternalMap<String, String>(map);
    }

    public ReEncryptRequest withDestinationEncryptionContext(Map<String, String> map) {
        this.setDestinationEncryptionContext(map);
        return this;
    }

    public ReEncryptRequest addDestinationEncryptionContextEntry(String string, String string2) {
        if (null == this.destinationEncryptionContext) {
            this.destinationEncryptionContext = new SdkInternalMap();
        }
        if (this.destinationEncryptionContext.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.destinationEncryptionContext.put(string, string2);
        return this;
    }

    public ReEncryptRequest clearDestinationEncryptionContextEntries() {
        this.destinationEncryptionContext = null;
        return this;
    }

    public void setSourceEncryptionAlgorithm(String string) {
        this.sourceEncryptionAlgorithm = string;
    }

    public String getSourceEncryptionAlgorithm() {
        return this.sourceEncryptionAlgorithm;
    }

    public ReEncryptRequest withSourceEncryptionAlgorithm(String string) {
        this.setSourceEncryptionAlgorithm(string);
        return this;
    }

    public ReEncryptRequest withSourceEncryptionAlgorithm(EncryptionAlgorithmSpec encryptionAlgorithmSpec) {
        this.sourceEncryptionAlgorithm = encryptionAlgorithmSpec.toString();
        return this;
    }

    public void setDestinationEncryptionAlgorithm(String string) {
        this.destinationEncryptionAlgorithm = string;
    }

    public String getDestinationEncryptionAlgorithm() {
        return this.destinationEncryptionAlgorithm;
    }

    public ReEncryptRequest withDestinationEncryptionAlgorithm(String string) {
        this.setDestinationEncryptionAlgorithm(string);
        return this;
    }

    public ReEncryptRequest withDestinationEncryptionAlgorithm(EncryptionAlgorithmSpec encryptionAlgorithmSpec) {
        this.destinationEncryptionAlgorithm = encryptionAlgorithmSpec.toString();
        return this;
    }

    public List<String> getGrantTokens() {
        if (this.grantTokens == null) {
            this.grantTokens = new SdkInternalList();
        }
        return this.grantTokens;
    }

    public void setGrantTokens(Collection<String> collection) {
        if (collection == null) {
            this.grantTokens = null;
            return;
        }
        this.grantTokens = new SdkInternalList<String>(collection);
    }

    public ReEncryptRequest withGrantTokens(String ... stringArray) {
        if (this.grantTokens == null) {
            this.setGrantTokens(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.grantTokens.add(string);
        }
        return this;
    }

    public ReEncryptRequest withGrantTokens(Collection<String> collection) {
        this.setGrantTokens(collection);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getCiphertextBlob() != null) {
            stringBuilder.append("CiphertextBlob: ").append(this.getCiphertextBlob()).append(",");
        }
        if (this.getSourceEncryptionContext() != null) {
            stringBuilder.append("SourceEncryptionContext: ").append(this.getSourceEncryptionContext()).append(",");
        }
        if (this.getSourceKeyId() != null) {
            stringBuilder.append("SourceKeyId: ").append(this.getSourceKeyId()).append(",");
        }
        if (this.getDestinationKeyId() != null) {
            stringBuilder.append("DestinationKeyId: ").append(this.getDestinationKeyId()).append(",");
        }
        if (this.getDestinationEncryptionContext() != null) {
            stringBuilder.append("DestinationEncryptionContext: ").append(this.getDestinationEncryptionContext()).append(",");
        }
        if (this.getSourceEncryptionAlgorithm() != null) {
            stringBuilder.append("SourceEncryptionAlgorithm: ").append(this.getSourceEncryptionAlgorithm()).append(",");
        }
        if (this.getDestinationEncryptionAlgorithm() != null) {
            stringBuilder.append("DestinationEncryptionAlgorithm: ").append(this.getDestinationEncryptionAlgorithm()).append(",");
        }
        if (this.getGrantTokens() != null) {
            stringBuilder.append("GrantTokens: ").append(this.getGrantTokens());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ReEncryptRequest)) {
            return false;
        }
        ReEncryptRequest reEncryptRequest = (ReEncryptRequest)object;
        if (reEncryptRequest.getCiphertextBlob() == null ^ this.getCiphertextBlob() == null) {
            return false;
        }
        if (reEncryptRequest.getCiphertextBlob() != null && !reEncryptRequest.getCiphertextBlob().equals(this.getCiphertextBlob())) {
            return false;
        }
        if (reEncryptRequest.getSourceEncryptionContext() == null ^ this.getSourceEncryptionContext() == null) {
            return false;
        }
        if (reEncryptRequest.getSourceEncryptionContext() != null && !reEncryptRequest.getSourceEncryptionContext().equals(this.getSourceEncryptionContext())) {
            return false;
        }
        if (reEncryptRequest.getSourceKeyId() == null ^ this.getSourceKeyId() == null) {
            return false;
        }
        if (reEncryptRequest.getSourceKeyId() != null && !reEncryptRequest.getSourceKeyId().equals(this.getSourceKeyId())) {
            return false;
        }
        if (reEncryptRequest.getDestinationKeyId() == null ^ this.getDestinationKeyId() == null) {
            return false;
        }
        if (reEncryptRequest.getDestinationKeyId() != null && !reEncryptRequest.getDestinationKeyId().equals(this.getDestinationKeyId())) {
            return false;
        }
        if (reEncryptRequest.getDestinationEncryptionContext() == null ^ this.getDestinationEncryptionContext() == null) {
            return false;
        }
        if (reEncryptRequest.getDestinationEncryptionContext() != null && !reEncryptRequest.getDestinationEncryptionContext().equals(this.getDestinationEncryptionContext())) {
            return false;
        }
        if (reEncryptRequest.getSourceEncryptionAlgorithm() == null ^ this.getSourceEncryptionAlgorithm() == null) {
            return false;
        }
        if (reEncryptRequest.getSourceEncryptionAlgorithm() != null && !reEncryptRequest.getSourceEncryptionAlgorithm().equals(this.getSourceEncryptionAlgorithm())) {
            return false;
        }
        if (reEncryptRequest.getDestinationEncryptionAlgorithm() == null ^ this.getDestinationEncryptionAlgorithm() == null) {
            return false;
        }
        if (reEncryptRequest.getDestinationEncryptionAlgorithm() != null && !reEncryptRequest.getDestinationEncryptionAlgorithm().equals(this.getDestinationEncryptionAlgorithm())) {
            return false;
        }
        if (reEncryptRequest.getGrantTokens() == null ^ this.getGrantTokens() == null) {
            return false;
        }
        return reEncryptRequest.getGrantTokens() == null || reEncryptRequest.getGrantTokens().equals(this.getGrantTokens());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getCiphertextBlob() == null ? 0 : this.getCiphertextBlob().hashCode());
        n2 = 31 * n2 + (this.getSourceEncryptionContext() == null ? 0 : this.getSourceEncryptionContext().hashCode());
        n2 = 31 * n2 + (this.getSourceKeyId() == null ? 0 : this.getSourceKeyId().hashCode());
        n2 = 31 * n2 + (this.getDestinationKeyId() == null ? 0 : this.getDestinationKeyId().hashCode());
        n2 = 31 * n2 + (this.getDestinationEncryptionContext() == null ? 0 : this.getDestinationEncryptionContext().hashCode());
        n2 = 31 * n2 + (this.getSourceEncryptionAlgorithm() == null ? 0 : this.getSourceEncryptionAlgorithm().hashCode());
        n2 = 31 * n2 + (this.getDestinationEncryptionAlgorithm() == null ? 0 : this.getDestinationEncryptionAlgorithm().hashCode());
        n2 = 31 * n2 + (this.getGrantTokens() == null ? 0 : this.getGrantTokens().hashCode());
        return n2;
    }

    @Override
    public ReEncryptRequest clone() {
        return (ReEncryptRequest)super.clone();
    }
}

