/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kms.model.MultiRegionKey;
import com.amazonaws.services.kms.model.MultiRegionKeyType;
import com.amazonaws.services.kms.model.transform.MultiRegionConfigurationMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class MultiRegionConfiguration
implements StructuredPojo,
Serializable,
Cloneable {
    private String multiRegionKeyType;
    private MultiRegionKey primaryKey;
    private SdkInternalList<MultiRegionKey> replicaKeys;

    public void setMultiRegionKeyType(String string) {
        this.multiRegionKeyType = string;
    }

    public String getMultiRegionKeyType() {
        return this.multiRegionKeyType;
    }

    public MultiRegionConfiguration withMultiRegionKeyType(String string) {
        this.setMultiRegionKeyType(string);
        return this;
    }

    public MultiRegionConfiguration withMultiRegionKeyType(MultiRegionKeyType multiRegionKeyType) {
        this.multiRegionKeyType = multiRegionKeyType.toString();
        return this;
    }

    public void setPrimaryKey(MultiRegionKey multiRegionKey) {
        this.primaryKey = multiRegionKey;
    }

    public MultiRegionKey getPrimaryKey() {
        return this.primaryKey;
    }

    public MultiRegionConfiguration withPrimaryKey(MultiRegionKey multiRegionKey) {
        this.setPrimaryKey(multiRegionKey);
        return this;
    }

    public List<MultiRegionKey> getReplicaKeys() {
        if (this.replicaKeys == null) {
            this.replicaKeys = new SdkInternalList();
        }
        return this.replicaKeys;
    }

    public void setReplicaKeys(Collection<MultiRegionKey> collection) {
        if (collection == null) {
            this.replicaKeys = null;
            return;
        }
        this.replicaKeys = new SdkInternalList<MultiRegionKey>(collection);
    }

    public MultiRegionConfiguration withReplicaKeys(MultiRegionKey ... multiRegionKeyArray) {
        if (this.replicaKeys == null) {
            this.setReplicaKeys(new SdkInternalList<MultiRegionKey>(multiRegionKeyArray.length));
        }
        for (MultiRegionKey multiRegionKey : multiRegionKeyArray) {
            this.replicaKeys.add(multiRegionKey);
        }
        return this;
    }

    public MultiRegionConfiguration withReplicaKeys(Collection<MultiRegionKey> collection) {
        this.setReplicaKeys(collection);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getMultiRegionKeyType() != null) {
            stringBuilder.append("MultiRegionKeyType: ").append(this.getMultiRegionKeyType()).append(",");
        }
        if (this.getPrimaryKey() != null) {
            stringBuilder.append("PrimaryKey: ").append(this.getPrimaryKey()).append(",");
        }
        if (this.getReplicaKeys() != null) {
            stringBuilder.append("ReplicaKeys: ").append(this.getReplicaKeys());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof MultiRegionConfiguration)) {
            return false;
        }
        MultiRegionConfiguration multiRegionConfiguration = (MultiRegionConfiguration)object;
        if (multiRegionConfiguration.getMultiRegionKeyType() == null ^ this.getMultiRegionKeyType() == null) {
            return false;
        }
        if (multiRegionConfiguration.getMultiRegionKeyType() != null && !multiRegionConfiguration.getMultiRegionKeyType().equals(this.getMultiRegionKeyType())) {
            return false;
        }
        if (multiRegionConfiguration.getPrimaryKey() == null ^ this.getPrimaryKey() == null) {
            return false;
        }
        if (multiRegionConfiguration.getPrimaryKey() != null && !multiRegionConfiguration.getPrimaryKey().equals(this.getPrimaryKey())) {
            return false;
        }
        if (multiRegionConfiguration.getReplicaKeys() == null ^ this.getReplicaKeys() == null) {
            return false;
        }
        return multiRegionConfiguration.getReplicaKeys() == null || multiRegionConfiguration.getReplicaKeys().equals(this.getReplicaKeys());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getMultiRegionKeyType() == null ? 0 : this.getMultiRegionKeyType().hashCode());
        n2 = 31 * n2 + (this.getPrimaryKey() == null ? 0 : this.getPrimaryKey().hashCode());
        n2 = 31 * n2 + (this.getReplicaKeys() == null ? 0 : this.getReplicaKeys().hashCode());
        return n2;
    }

    public MultiRegionConfiguration clone() {
        try {
            return (MultiRegionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MultiRegionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

