/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.kms.model.MacAlgorithmSpec;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class GenerateMacResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private ByteBuffer mac;
    private String macAlgorithm;
    private String keyId;

    public void setMac(ByteBuffer byteBuffer) {
        this.mac = byteBuffer;
    }

    public ByteBuffer getMac() {
        return this.mac;
    }

    public GenerateMacResult withMac(ByteBuffer byteBuffer) {
        this.setMac(byteBuffer);
        return this;
    }

    public void setMacAlgorithm(String string) {
        this.macAlgorithm = string;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public GenerateMacResult withMacAlgorithm(String string) {
        this.setMacAlgorithm(string);
        return this;
    }

    public GenerateMacResult withMacAlgorithm(MacAlgorithmSpec macAlgorithmSpec) {
        this.macAlgorithm = macAlgorithmSpec.toString();
        return this;
    }

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public GenerateMacResult withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getMac() != null) {
            stringBuilder.append("Mac: ").append(this.getMac()).append(",");
        }
        if (this.getMacAlgorithm() != null) {
            stringBuilder.append("MacAlgorithm: ").append(this.getMacAlgorithm()).append(",");
        }
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof GenerateMacResult)) {
            return false;
        }
        GenerateMacResult generateMacResult = (GenerateMacResult)object;
        if (generateMacResult.getMac() == null ^ this.getMac() == null) {
            return false;
        }
        if (generateMacResult.getMac() != null && !generateMacResult.getMac().equals(this.getMac())) {
            return false;
        }
        if (generateMacResult.getMacAlgorithm() == null ^ this.getMacAlgorithm() == null) {
            return false;
        }
        if (generateMacResult.getMacAlgorithm() != null && !generateMacResult.getMacAlgorithm().equals(this.getMacAlgorithm())) {
            return false;
        }
        if (generateMacResult.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        return generateMacResult.getKeyId() == null || generateMacResult.getKeyId().equals(this.getKeyId());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getMac() == null ? 0 : this.getMac().hashCode());
        n2 = 31 * n2 + (this.getMacAlgorithm() == null ? 0 : this.getMacAlgorithm().hashCode());
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        return n2;
    }

    public GenerateMacResult clone() {
        try {
            return (GenerateMacResult)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

