/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.kms.model.DataKeyPairSpec;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GenerateDataKeyPairRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalMap<String, String> encryptionContext;
    private String keyId;
    private String keyPairSpec;
    private SdkInternalList<String> grantTokens;

    public Map<String, String> getEncryptionContext() {
        if (this.encryptionContext == null) {
            this.encryptionContext = new SdkInternalMap();
        }
        return this.encryptionContext;
    }

    public void setEncryptionContext(Map<String, String> map) {
        this.encryptionContext = map == null ? null : new SdkInternalMap<String, String>(map);
    }

    public GenerateDataKeyPairRequest withEncryptionContext(Map<String, String> map) {
        this.setEncryptionContext(map);
        return this;
    }

    public GenerateDataKeyPairRequest addEncryptionContextEntry(String string, String string2) {
        if (null == this.encryptionContext) {
            this.encryptionContext = new SdkInternalMap();
        }
        if (this.encryptionContext.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.encryptionContext.put(string, string2);
        return this;
    }

    public GenerateDataKeyPairRequest clearEncryptionContextEntries() {
        this.encryptionContext = null;
        return this;
    }

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public GenerateDataKeyPairRequest withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public void setKeyPairSpec(String string) {
        this.keyPairSpec = string;
    }

    public String getKeyPairSpec() {
        return this.keyPairSpec;
    }

    public GenerateDataKeyPairRequest withKeyPairSpec(String string) {
        this.setKeyPairSpec(string);
        return this;
    }

    public GenerateDataKeyPairRequest withKeyPairSpec(DataKeyPairSpec dataKeyPairSpec) {
        this.keyPairSpec = dataKeyPairSpec.toString();
        return this;
    }

    public List<String> getGrantTokens() {
        if (this.grantTokens == null) {
            this.grantTokens = new SdkInternalList();
        }
        return this.grantTokens;
    }

    public void setGrantTokens(Collection<String> collection) {
        if (collection == null) {
            this.grantTokens = null;
            return;
        }
        this.grantTokens = new SdkInternalList<String>(collection);
    }

    public GenerateDataKeyPairRequest withGrantTokens(String ... stringArray) {
        if (this.grantTokens == null) {
            this.setGrantTokens(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.grantTokens.add(string);
        }
        return this;
    }

    public GenerateDataKeyPairRequest withGrantTokens(Collection<String> collection) {
        this.setGrantTokens(collection);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getEncryptionContext() != null) {
            stringBuilder.append("EncryptionContext: ").append(this.getEncryptionContext()).append(",");
        }
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getKeyPairSpec() != null) {
            stringBuilder.append("KeyPairSpec: ").append(this.getKeyPairSpec()).append(",");
        }
        if (this.getGrantTokens() != null) {
            stringBuilder.append("GrantTokens: ").append(this.getGrantTokens());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof GenerateDataKeyPairRequest)) {
            return false;
        }
        GenerateDataKeyPairRequest generateDataKeyPairRequest = (GenerateDataKeyPairRequest)object;
        if (generateDataKeyPairRequest.getEncryptionContext() == null ^ this.getEncryptionContext() == null) {
            return false;
        }
        if (generateDataKeyPairRequest.getEncryptionContext() != null && !generateDataKeyPairRequest.getEncryptionContext().equals(this.getEncryptionContext())) {
            return false;
        }
        if (generateDataKeyPairRequest.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (generateDataKeyPairRequest.getKeyId() != null && !generateDataKeyPairRequest.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (generateDataKeyPairRequest.getKeyPairSpec() == null ^ this.getKeyPairSpec() == null) {
            return false;
        }
        if (generateDataKeyPairRequest.getKeyPairSpec() != null && !generateDataKeyPairRequest.getKeyPairSpec().equals(this.getKeyPairSpec())) {
            return false;
        }
        if (generateDataKeyPairRequest.getGrantTokens() == null ^ this.getGrantTokens() == null) {
            return false;
        }
        return generateDataKeyPairRequest.getGrantTokens() == null || generateDataKeyPairRequest.getGrantTokens().equals(this.getGrantTokens());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getEncryptionContext() == null ? 0 : this.getEncryptionContext().hashCode());
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getKeyPairSpec() == null ? 0 : this.getKeyPairSpec().hashCode());
        n2 = 31 * n2 + (this.getGrantTokens() == null ? 0 : this.getGrantTokens().hashCode());
        return n2;
    }

    @Override
    public GenerateDataKeyPairRequest clone() {
        return (GenerateDataKeyPairRequest)super.clone();
    }
}

