/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.kms.model.EncryptionAlgorithmSpec;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class DecryptResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String keyId;
    private ByteBuffer plaintext;
    private String encryptionAlgorithm;

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public DecryptResult withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public void setPlaintext(ByteBuffer byteBuffer) {
        this.plaintext = byteBuffer;
    }

    public ByteBuffer getPlaintext() {
        return this.plaintext;
    }

    public DecryptResult withPlaintext(ByteBuffer byteBuffer) {
        this.setPlaintext(byteBuffer);
        return this;
    }

    public void setEncryptionAlgorithm(String string) {
        this.encryptionAlgorithm = string;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public DecryptResult withEncryptionAlgorithm(String string) {
        this.setEncryptionAlgorithm(string);
        return this;
    }

    public DecryptResult withEncryptionAlgorithm(EncryptionAlgorithmSpec encryptionAlgorithmSpec) {
        this.encryptionAlgorithm = encryptionAlgorithmSpec.toString();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getPlaintext() != null) {
            stringBuilder.append("Plaintext: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getEncryptionAlgorithm() != null) {
            stringBuilder.append("EncryptionAlgorithm: ").append(this.getEncryptionAlgorithm());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DecryptResult)) {
            return false;
        }
        DecryptResult decryptResult = (DecryptResult)object;
        if (decryptResult.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (decryptResult.getKeyId() != null && !decryptResult.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (decryptResult.getPlaintext() == null ^ this.getPlaintext() == null) {
            return false;
        }
        if (decryptResult.getPlaintext() != null && !decryptResult.getPlaintext().equals(this.getPlaintext())) {
            return false;
        }
        if (decryptResult.getEncryptionAlgorithm() == null ^ this.getEncryptionAlgorithm() == null) {
            return false;
        }
        return decryptResult.getEncryptionAlgorithm() == null || decryptResult.getEncryptionAlgorithm().equals(this.getEncryptionAlgorithm());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getPlaintext() == null ? 0 : this.getPlaintext().hashCode());
        n2 = 31 * n2 + (this.getEncryptionAlgorithm() == null ? 0 : this.getEncryptionAlgorithm().hashCode());
        return n2;
    }

    public DecryptResult clone() {
        try {
            return (DecryptResult)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

