/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.GrantConstraints;
import com.amazonaws.services.kms.model.GrantOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateGrantRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String keyId;
    private String granteePrincipal;
    private String retiringPrincipal;
    private SdkInternalList<String> operations;
    private GrantConstraints constraints;
    private SdkInternalList<String> grantTokens;
    private String name;

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public CreateGrantRequest withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public void setGranteePrincipal(String string) {
        this.granteePrincipal = string;
    }

    public String getGranteePrincipal() {
        return this.granteePrincipal;
    }

    public CreateGrantRequest withGranteePrincipal(String string) {
        this.setGranteePrincipal(string);
        return this;
    }

    public void setRetiringPrincipal(String string) {
        this.retiringPrincipal = string;
    }

    public String getRetiringPrincipal() {
        return this.retiringPrincipal;
    }

    public CreateGrantRequest withRetiringPrincipal(String string) {
        this.setRetiringPrincipal(string);
        return this;
    }

    public List<String> getOperations() {
        if (this.operations == null) {
            this.operations = new SdkInternalList();
        }
        return this.operations;
    }

    public void setOperations(Collection<String> collection) {
        if (collection == null) {
            this.operations = null;
            return;
        }
        this.operations = new SdkInternalList<String>(collection);
    }

    public CreateGrantRequest withOperations(String ... stringArray) {
        if (this.operations == null) {
            this.setOperations(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.operations.add(string);
        }
        return this;
    }

    public CreateGrantRequest withOperations(Collection<String> collection) {
        this.setOperations(collection);
        return this;
    }

    public CreateGrantRequest withOperations(GrantOperation ... grantOperationArray) {
        SdkInternalList<String> sdkInternalList = new SdkInternalList<String>(grantOperationArray.length);
        for (GrantOperation grantOperation : grantOperationArray) {
            sdkInternalList.add(grantOperation.toString());
        }
        if (this.getOperations() == null) {
            this.setOperations(sdkInternalList);
        } else {
            this.getOperations().addAll(sdkInternalList);
        }
        return this;
    }

    public void setConstraints(GrantConstraints grantConstraints) {
        this.constraints = grantConstraints;
    }

    public GrantConstraints getConstraints() {
        return this.constraints;
    }

    public CreateGrantRequest withConstraints(GrantConstraints grantConstraints) {
        this.setConstraints(grantConstraints);
        return this;
    }

    public List<String> getGrantTokens() {
        if (this.grantTokens == null) {
            this.grantTokens = new SdkInternalList();
        }
        return this.grantTokens;
    }

    public void setGrantTokens(Collection<String> collection) {
        if (collection == null) {
            this.grantTokens = null;
            return;
        }
        this.grantTokens = new SdkInternalList<String>(collection);
    }

    public CreateGrantRequest withGrantTokens(String ... stringArray) {
        if (this.grantTokens == null) {
            this.setGrantTokens(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.grantTokens.add(string);
        }
        return this;
    }

    public CreateGrantRequest withGrantTokens(Collection<String> collection) {
        this.setGrantTokens(collection);
        return this;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public CreateGrantRequest withName(String string) {
        this.setName(string);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getGranteePrincipal() != null) {
            stringBuilder.append("GranteePrincipal: ").append(this.getGranteePrincipal()).append(",");
        }
        if (this.getRetiringPrincipal() != null) {
            stringBuilder.append("RetiringPrincipal: ").append(this.getRetiringPrincipal()).append(",");
        }
        if (this.getOperations() != null) {
            stringBuilder.append("Operations: ").append(this.getOperations()).append(",");
        }
        if (this.getConstraints() != null) {
            stringBuilder.append("Constraints: ").append(this.getConstraints()).append(",");
        }
        if (this.getGrantTokens() != null) {
            stringBuilder.append("GrantTokens: ").append(this.getGrantTokens()).append(",");
        }
        if (this.getName() != null) {
            stringBuilder.append("Name: ").append(this.getName());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CreateGrantRequest)) {
            return false;
        }
        CreateGrantRequest createGrantRequest = (CreateGrantRequest)object;
        if (createGrantRequest.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (createGrantRequest.getKeyId() != null && !createGrantRequest.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (createGrantRequest.getGranteePrincipal() == null ^ this.getGranteePrincipal() == null) {
            return false;
        }
        if (createGrantRequest.getGranteePrincipal() != null && !createGrantRequest.getGranteePrincipal().equals(this.getGranteePrincipal())) {
            return false;
        }
        if (createGrantRequest.getRetiringPrincipal() == null ^ this.getRetiringPrincipal() == null) {
            return false;
        }
        if (createGrantRequest.getRetiringPrincipal() != null && !createGrantRequest.getRetiringPrincipal().equals(this.getRetiringPrincipal())) {
            return false;
        }
        if (createGrantRequest.getOperations() == null ^ this.getOperations() == null) {
            return false;
        }
        if (createGrantRequest.getOperations() != null && !createGrantRequest.getOperations().equals(this.getOperations())) {
            return false;
        }
        if (createGrantRequest.getConstraints() == null ^ this.getConstraints() == null) {
            return false;
        }
        if (createGrantRequest.getConstraints() != null && !createGrantRequest.getConstraints().equals(this.getConstraints())) {
            return false;
        }
        if (createGrantRequest.getGrantTokens() == null ^ this.getGrantTokens() == null) {
            return false;
        }
        if (createGrantRequest.getGrantTokens() != null && !createGrantRequest.getGrantTokens().equals(this.getGrantTokens())) {
            return false;
        }
        if (createGrantRequest.getName() == null ^ this.getName() == null) {
            return false;
        }
        return createGrantRequest.getName() == null || createGrantRequest.getName().equals(this.getName());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getGranteePrincipal() == null ? 0 : this.getGranteePrincipal().hashCode());
        n2 = 31 * n2 + (this.getRetiringPrincipal() == null ? 0 : this.getRetiringPrincipal().hashCode());
        n2 = 31 * n2 + (this.getOperations() == null ? 0 : this.getOperations().hashCode());
        n2 = 31 * n2 + (this.getConstraints() == null ? 0 : this.getConstraints().hashCode());
        n2 = 31 * n2 + (this.getGrantTokens() == null ? 0 : this.getGrantTokens().hashCode());
        n2 = 31 * n2 + (this.getName() == null ? 0 : this.getName().hashCode());
        return n2;
    }

    @Override
    public CreateGrantRequest clone() {
        return (CreateGrantRequest)super.clone();
    }
}

