/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kms.AWSKMSAsync;
import com.amazonaws.services.kms.AWSKMSAsyncClientBuilder;
import com.amazonaws.services.kms.AWSKMSClient;
import com.amazonaws.services.kms.model.CancelKeyDeletionRequest;
import com.amazonaws.services.kms.model.CancelKeyDeletionResult;
import com.amazonaws.services.kms.model.ConnectCustomKeyStoreRequest;
import com.amazonaws.services.kms.model.ConnectCustomKeyStoreResult;
import com.amazonaws.services.kms.model.CreateAliasRequest;
import com.amazonaws.services.kms.model.CreateAliasResult;
import com.amazonaws.services.kms.model.CreateCustomKeyStoreRequest;
import com.amazonaws.services.kms.model.CreateCustomKeyStoreResult;
import com.amazonaws.services.kms.model.CreateGrantRequest;
import com.amazonaws.services.kms.model.CreateGrantResult;
import com.amazonaws.services.kms.model.CreateKeyRequest;
import com.amazonaws.services.kms.model.CreateKeyResult;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.DecryptResult;
import com.amazonaws.services.kms.model.DeleteAliasRequest;
import com.amazonaws.services.kms.model.DeleteAliasResult;
import com.amazonaws.services.kms.model.DeleteCustomKeyStoreRequest;
import com.amazonaws.services.kms.model.DeleteCustomKeyStoreResult;
import com.amazonaws.services.kms.model.DeleteImportedKeyMaterialRequest;
import com.amazonaws.services.kms.model.DeleteImportedKeyMaterialResult;
import com.amazonaws.services.kms.model.DescribeCustomKeyStoresRequest;
import com.amazonaws.services.kms.model.DescribeCustomKeyStoresResult;
import com.amazonaws.services.kms.model.DescribeKeyRequest;
import com.amazonaws.services.kms.model.DescribeKeyResult;
import com.amazonaws.services.kms.model.DisableKeyRequest;
import com.amazonaws.services.kms.model.DisableKeyResult;
import com.amazonaws.services.kms.model.DisableKeyRotationRequest;
import com.amazonaws.services.kms.model.DisableKeyRotationResult;
import com.amazonaws.services.kms.model.DisconnectCustomKeyStoreRequest;
import com.amazonaws.services.kms.model.DisconnectCustomKeyStoreResult;
import com.amazonaws.services.kms.model.EnableKeyRequest;
import com.amazonaws.services.kms.model.EnableKeyResult;
import com.amazonaws.services.kms.model.EnableKeyRotationRequest;
import com.amazonaws.services.kms.model.EnableKeyRotationResult;
import com.amazonaws.services.kms.model.EncryptRequest;
import com.amazonaws.services.kms.model.EncryptResult;
import com.amazonaws.services.kms.model.GenerateDataKeyPairRequest;
import com.amazonaws.services.kms.model.GenerateDataKeyPairResult;
import com.amazonaws.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest;
import com.amazonaws.services.kms.model.GenerateDataKeyPairWithoutPlaintextResult;
import com.amazonaws.services.kms.model.GenerateDataKeyRequest;
import com.amazonaws.services.kms.model.GenerateDataKeyResult;
import com.amazonaws.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import com.amazonaws.services.kms.model.GenerateDataKeyWithoutPlaintextResult;
import com.amazonaws.services.kms.model.GenerateMacRequest;
import com.amazonaws.services.kms.model.GenerateMacResult;
import com.amazonaws.services.kms.model.GenerateRandomRequest;
import com.amazonaws.services.kms.model.GenerateRandomResult;
import com.amazonaws.services.kms.model.GetKeyPolicyRequest;
import com.amazonaws.services.kms.model.GetKeyPolicyResult;
import com.amazonaws.services.kms.model.GetKeyRotationStatusRequest;
import com.amazonaws.services.kms.model.GetKeyRotationStatusResult;
import com.amazonaws.services.kms.model.GetParametersForImportRequest;
import com.amazonaws.services.kms.model.GetParametersForImportResult;
import com.amazonaws.services.kms.model.GetPublicKeyRequest;
import com.amazonaws.services.kms.model.GetPublicKeyResult;
import com.amazonaws.services.kms.model.ImportKeyMaterialRequest;
import com.amazonaws.services.kms.model.ImportKeyMaterialResult;
import com.amazonaws.services.kms.model.ListAliasesRequest;
import com.amazonaws.services.kms.model.ListAliasesResult;
import com.amazonaws.services.kms.model.ListGrantsRequest;
import com.amazonaws.services.kms.model.ListGrantsResult;
import com.amazonaws.services.kms.model.ListKeyPoliciesRequest;
import com.amazonaws.services.kms.model.ListKeyPoliciesResult;
import com.amazonaws.services.kms.model.ListKeysRequest;
import com.amazonaws.services.kms.model.ListKeysResult;
import com.amazonaws.services.kms.model.ListResourceTagsRequest;
import com.amazonaws.services.kms.model.ListResourceTagsResult;
import com.amazonaws.services.kms.model.ListRetirableGrantsRequest;
import com.amazonaws.services.kms.model.ListRetirableGrantsResult;
import com.amazonaws.services.kms.model.PutKeyPolicyRequest;
import com.amazonaws.services.kms.model.PutKeyPolicyResult;
import com.amazonaws.services.kms.model.ReEncryptRequest;
import com.amazonaws.services.kms.model.ReEncryptResult;
import com.amazonaws.services.kms.model.ReplicateKeyRequest;
import com.amazonaws.services.kms.model.ReplicateKeyResult;
import com.amazonaws.services.kms.model.RetireGrantRequest;
import com.amazonaws.services.kms.model.RetireGrantResult;
import com.amazonaws.services.kms.model.RevokeGrantRequest;
import com.amazonaws.services.kms.model.RevokeGrantResult;
import com.amazonaws.services.kms.model.ScheduleKeyDeletionRequest;
import com.amazonaws.services.kms.model.ScheduleKeyDeletionResult;
import com.amazonaws.services.kms.model.SignRequest;
import com.amazonaws.services.kms.model.SignResult;
import com.amazonaws.services.kms.model.TagResourceRequest;
import com.amazonaws.services.kms.model.TagResourceResult;
import com.amazonaws.services.kms.model.UntagResourceRequest;
import com.amazonaws.services.kms.model.UntagResourceResult;
import com.amazonaws.services.kms.model.UpdateAliasRequest;
import com.amazonaws.services.kms.model.UpdateAliasResult;
import com.amazonaws.services.kms.model.UpdateCustomKeyStoreRequest;
import com.amazonaws.services.kms.model.UpdateCustomKeyStoreResult;
import com.amazonaws.services.kms.model.UpdateKeyDescriptionRequest;
import com.amazonaws.services.kms.model.UpdateKeyDescriptionResult;
import com.amazonaws.services.kms.model.UpdatePrimaryRegionRequest;
import com.amazonaws.services.kms.model.UpdatePrimaryRegionResult;
import com.amazonaws.services.kms.model.VerifyMacRequest;
import com.amazonaws.services.kms.model.VerifyMacResult;
import com.amazonaws.services.kms.model.VerifyRequest;
import com.amazonaws.services.kms.model.VerifyResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSKMSAsyncClient
extends AWSKMSClient
implements AWSKMSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSKMSAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSKMSAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSKMSAsyncClient(AWSCredentials aWSCredentials) {
        this(aWSCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSKMSAsyncClient(AWSCredentials aWSCredentials, ExecutorService executorService) {
        this(aWSCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSKMSAsyncClient(AWSCredentials aWSCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(aWSCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSKMSAsyncClient(AWSCredentialsProvider aWSCredentialsProvider) {
        this(aWSCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSKMSAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(aWSCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSKMSAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ExecutorService executorService) {
        this(aWSCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSKMSAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(aWSCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSKMSAsyncClientBuilder asyncBuilder() {
        return AWSKMSAsyncClientBuilder.standard();
    }

    AWSKMSAsyncClient(AwsAsyncClientParams awsAsyncClientParams) {
        this(awsAsyncClientParams, false);
    }

    AWSKMSAsyncClient(AwsAsyncClientParams awsAsyncClientParams, boolean bl) {
        super(awsAsyncClientParams, bl);
        this.executorService = awsAsyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelKeyDeletionResult> cancelKeyDeletionAsync(CancelKeyDeletionRequest cancelKeyDeletionRequest) {
        return this.cancelKeyDeletionAsync(cancelKeyDeletionRequest, null);
    }

    @Override
    public Future<CancelKeyDeletionResult> cancelKeyDeletionAsync(CancelKeyDeletionRequest cancelKeyDeletionRequest, final AsyncHandler<CancelKeyDeletionRequest, CancelKeyDeletionResult> asyncHandler) {
        final CancelKeyDeletionRequest cancelKeyDeletionRequest2 = this.beforeClientExecution(cancelKeyDeletionRequest);
        return this.executorService.submit(new Callable<CancelKeyDeletionResult>(){

            @Override
            public CancelKeyDeletionResult call() throws Exception {
                CancelKeyDeletionResult cancelKeyDeletionResult = null;
                try {
                    cancelKeyDeletionResult = AWSKMSAsyncClient.this.executeCancelKeyDeletion(cancelKeyDeletionRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(cancelKeyDeletionRequest2, cancelKeyDeletionResult);
                }
                return cancelKeyDeletionResult;
            }
        });
    }

    @Override
    public Future<ConnectCustomKeyStoreResult> connectCustomKeyStoreAsync(ConnectCustomKeyStoreRequest connectCustomKeyStoreRequest) {
        return this.connectCustomKeyStoreAsync(connectCustomKeyStoreRequest, null);
    }

    @Override
    public Future<ConnectCustomKeyStoreResult> connectCustomKeyStoreAsync(ConnectCustomKeyStoreRequest connectCustomKeyStoreRequest, final AsyncHandler<ConnectCustomKeyStoreRequest, ConnectCustomKeyStoreResult> asyncHandler) {
        final ConnectCustomKeyStoreRequest connectCustomKeyStoreRequest2 = this.beforeClientExecution(connectCustomKeyStoreRequest);
        return this.executorService.submit(new Callable<ConnectCustomKeyStoreResult>(){

            @Override
            public ConnectCustomKeyStoreResult call() throws Exception {
                ConnectCustomKeyStoreResult connectCustomKeyStoreResult = null;
                try {
                    connectCustomKeyStoreResult = AWSKMSAsyncClient.this.executeConnectCustomKeyStore(connectCustomKeyStoreRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(connectCustomKeyStoreRequest2, connectCustomKeyStoreResult);
                }
                return connectCustomKeyStoreResult;
            }
        });
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(CreateAliasRequest createAliasRequest) {
        return this.createAliasAsync(createAliasRequest, null);
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(CreateAliasRequest createAliasRequest, final AsyncHandler<CreateAliasRequest, CreateAliasResult> asyncHandler) {
        final CreateAliasRequest createAliasRequest2 = this.beforeClientExecution(createAliasRequest);
        return this.executorService.submit(new Callable<CreateAliasResult>(){

            @Override
            public CreateAliasResult call() throws Exception {
                CreateAliasResult createAliasResult = null;
                try {
                    createAliasResult = AWSKMSAsyncClient.this.executeCreateAlias(createAliasRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(createAliasRequest2, createAliasResult);
                }
                return createAliasResult;
            }
        });
    }

    @Override
    public Future<CreateCustomKeyStoreResult> createCustomKeyStoreAsync(CreateCustomKeyStoreRequest createCustomKeyStoreRequest) {
        return this.createCustomKeyStoreAsync(createCustomKeyStoreRequest, null);
    }

    @Override
    public Future<CreateCustomKeyStoreResult> createCustomKeyStoreAsync(CreateCustomKeyStoreRequest createCustomKeyStoreRequest, final AsyncHandler<CreateCustomKeyStoreRequest, CreateCustomKeyStoreResult> asyncHandler) {
        final CreateCustomKeyStoreRequest createCustomKeyStoreRequest2 = this.beforeClientExecution(createCustomKeyStoreRequest);
        return this.executorService.submit(new Callable<CreateCustomKeyStoreResult>(){

            @Override
            public CreateCustomKeyStoreResult call() throws Exception {
                CreateCustomKeyStoreResult createCustomKeyStoreResult = null;
                try {
                    createCustomKeyStoreResult = AWSKMSAsyncClient.this.executeCreateCustomKeyStore(createCustomKeyStoreRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(createCustomKeyStoreRequest2, createCustomKeyStoreResult);
                }
                return createCustomKeyStoreResult;
            }
        });
    }

    @Override
    public Future<CreateGrantResult> createGrantAsync(CreateGrantRequest createGrantRequest) {
        return this.createGrantAsync(createGrantRequest, null);
    }

    @Override
    public Future<CreateGrantResult> createGrantAsync(CreateGrantRequest createGrantRequest, final AsyncHandler<CreateGrantRequest, CreateGrantResult> asyncHandler) {
        final CreateGrantRequest createGrantRequest2 = this.beforeClientExecution(createGrantRequest);
        return this.executorService.submit(new Callable<CreateGrantResult>(){

            @Override
            public CreateGrantResult call() throws Exception {
                CreateGrantResult createGrantResult = null;
                try {
                    createGrantResult = AWSKMSAsyncClient.this.executeCreateGrant(createGrantRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(createGrantRequest2, createGrantResult);
                }
                return createGrantResult;
            }
        });
    }

    @Override
    public Future<CreateKeyResult> createKeyAsync(CreateKeyRequest createKeyRequest) {
        return this.createKeyAsync(createKeyRequest, null);
    }

    @Override
    public Future<CreateKeyResult> createKeyAsync(CreateKeyRequest createKeyRequest, final AsyncHandler<CreateKeyRequest, CreateKeyResult> asyncHandler) {
        final CreateKeyRequest createKeyRequest2 = this.beforeClientExecution(createKeyRequest);
        return this.executorService.submit(new Callable<CreateKeyResult>(){

            @Override
            public CreateKeyResult call() throws Exception {
                CreateKeyResult createKeyResult = null;
                try {
                    createKeyResult = AWSKMSAsyncClient.this.executeCreateKey(createKeyRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(createKeyRequest2, createKeyResult);
                }
                return createKeyResult;
            }
        });
    }

    @Override
    public Future<CreateKeyResult> createKeyAsync() {
        return this.createKeyAsync(new CreateKeyRequest());
    }

    @Override
    public Future<CreateKeyResult> createKeyAsync(AsyncHandler<CreateKeyRequest, CreateKeyResult> asyncHandler) {
        return this.createKeyAsync(new CreateKeyRequest(), asyncHandler);
    }

    @Override
    public Future<DecryptResult> decryptAsync(DecryptRequest decryptRequest) {
        return this.decryptAsync(decryptRequest, null);
    }

    @Override
    public Future<DecryptResult> decryptAsync(DecryptRequest decryptRequest, final AsyncHandler<DecryptRequest, DecryptResult> asyncHandler) {
        final DecryptRequest decryptRequest2 = this.beforeClientExecution(decryptRequest);
        return this.executorService.submit(new Callable<DecryptResult>(){

            @Override
            public DecryptResult call() throws Exception {
                DecryptResult decryptResult = null;
                try {
                    decryptResult = AWSKMSAsyncClient.this.executeDecrypt(decryptRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(decryptRequest2, decryptResult);
                }
                return decryptResult;
            }
        });
    }

    @Override
    public Future<DeleteAliasResult> deleteAliasAsync(DeleteAliasRequest deleteAliasRequest) {
        return this.deleteAliasAsync(deleteAliasRequest, null);
    }

    @Override
    public Future<DeleteAliasResult> deleteAliasAsync(DeleteAliasRequest deleteAliasRequest, final AsyncHandler<DeleteAliasRequest, DeleteAliasResult> asyncHandler) {
        final DeleteAliasRequest deleteAliasRequest2 = this.beforeClientExecution(deleteAliasRequest);
        return this.executorService.submit(new Callable<DeleteAliasResult>(){

            @Override
            public DeleteAliasResult call() throws Exception {
                DeleteAliasResult deleteAliasResult = null;
                try {
                    deleteAliasResult = AWSKMSAsyncClient.this.executeDeleteAlias(deleteAliasRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(deleteAliasRequest2, deleteAliasResult);
                }
                return deleteAliasResult;
            }
        });
    }

    @Override
    public Future<DeleteCustomKeyStoreResult> deleteCustomKeyStoreAsync(DeleteCustomKeyStoreRequest deleteCustomKeyStoreRequest) {
        return this.deleteCustomKeyStoreAsync(deleteCustomKeyStoreRequest, null);
    }

    @Override
    public Future<DeleteCustomKeyStoreResult> deleteCustomKeyStoreAsync(DeleteCustomKeyStoreRequest deleteCustomKeyStoreRequest, final AsyncHandler<DeleteCustomKeyStoreRequest, DeleteCustomKeyStoreResult> asyncHandler) {
        final DeleteCustomKeyStoreRequest deleteCustomKeyStoreRequest2 = this.beforeClientExecution(deleteCustomKeyStoreRequest);
        return this.executorService.submit(new Callable<DeleteCustomKeyStoreResult>(){

            @Override
            public DeleteCustomKeyStoreResult call() throws Exception {
                DeleteCustomKeyStoreResult deleteCustomKeyStoreResult = null;
                try {
                    deleteCustomKeyStoreResult = AWSKMSAsyncClient.this.executeDeleteCustomKeyStore(deleteCustomKeyStoreRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(deleteCustomKeyStoreRequest2, deleteCustomKeyStoreResult);
                }
                return deleteCustomKeyStoreResult;
            }
        });
    }

    @Override
    public Future<DeleteImportedKeyMaterialResult> deleteImportedKeyMaterialAsync(DeleteImportedKeyMaterialRequest deleteImportedKeyMaterialRequest) {
        return this.deleteImportedKeyMaterialAsync(deleteImportedKeyMaterialRequest, null);
    }

    @Override
    public Future<DeleteImportedKeyMaterialResult> deleteImportedKeyMaterialAsync(DeleteImportedKeyMaterialRequest deleteImportedKeyMaterialRequest, final AsyncHandler<DeleteImportedKeyMaterialRequest, DeleteImportedKeyMaterialResult> asyncHandler) {
        final DeleteImportedKeyMaterialRequest deleteImportedKeyMaterialRequest2 = this.beforeClientExecution(deleteImportedKeyMaterialRequest);
        return this.executorService.submit(new Callable<DeleteImportedKeyMaterialResult>(){

            @Override
            public DeleteImportedKeyMaterialResult call() throws Exception {
                DeleteImportedKeyMaterialResult deleteImportedKeyMaterialResult = null;
                try {
                    deleteImportedKeyMaterialResult = AWSKMSAsyncClient.this.executeDeleteImportedKeyMaterial(deleteImportedKeyMaterialRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(deleteImportedKeyMaterialRequest2, deleteImportedKeyMaterialResult);
                }
                return deleteImportedKeyMaterialResult;
            }
        });
    }

    @Override
    public Future<DescribeCustomKeyStoresResult> describeCustomKeyStoresAsync(DescribeCustomKeyStoresRequest describeCustomKeyStoresRequest) {
        return this.describeCustomKeyStoresAsync(describeCustomKeyStoresRequest, null);
    }

    @Override
    public Future<DescribeCustomKeyStoresResult> describeCustomKeyStoresAsync(DescribeCustomKeyStoresRequest describeCustomKeyStoresRequest, final AsyncHandler<DescribeCustomKeyStoresRequest, DescribeCustomKeyStoresResult> asyncHandler) {
        final DescribeCustomKeyStoresRequest describeCustomKeyStoresRequest2 = this.beforeClientExecution(describeCustomKeyStoresRequest);
        return this.executorService.submit(new Callable<DescribeCustomKeyStoresResult>(){

            @Override
            public DescribeCustomKeyStoresResult call() throws Exception {
                DescribeCustomKeyStoresResult describeCustomKeyStoresResult = null;
                try {
                    describeCustomKeyStoresResult = AWSKMSAsyncClient.this.executeDescribeCustomKeyStores(describeCustomKeyStoresRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(describeCustomKeyStoresRequest2, describeCustomKeyStoresResult);
                }
                return describeCustomKeyStoresResult;
            }
        });
    }

    @Override
    public Future<DescribeKeyResult> describeKeyAsync(DescribeKeyRequest describeKeyRequest) {
        return this.describeKeyAsync(describeKeyRequest, null);
    }

    @Override
    public Future<DescribeKeyResult> describeKeyAsync(DescribeKeyRequest describeKeyRequest, final AsyncHandler<DescribeKeyRequest, DescribeKeyResult> asyncHandler) {
        final DescribeKeyRequest describeKeyRequest2 = this.beforeClientExecution(describeKeyRequest);
        return this.executorService.submit(new Callable<DescribeKeyResult>(){

            @Override
            public DescribeKeyResult call() throws Exception {
                DescribeKeyResult describeKeyResult = null;
                try {
                    describeKeyResult = AWSKMSAsyncClient.this.executeDescribeKey(describeKeyRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(describeKeyRequest2, describeKeyResult);
                }
                return describeKeyResult;
            }
        });
    }

    @Override
    public Future<DisableKeyResult> disableKeyAsync(DisableKeyRequest disableKeyRequest) {
        return this.disableKeyAsync(disableKeyRequest, null);
    }

    @Override
    public Future<DisableKeyResult> disableKeyAsync(DisableKeyRequest disableKeyRequest, final AsyncHandler<DisableKeyRequest, DisableKeyResult> asyncHandler) {
        final DisableKeyRequest disableKeyRequest2 = this.beforeClientExecution(disableKeyRequest);
        return this.executorService.submit(new Callable<DisableKeyResult>(){

            @Override
            public DisableKeyResult call() throws Exception {
                DisableKeyResult disableKeyResult = null;
                try {
                    disableKeyResult = AWSKMSAsyncClient.this.executeDisableKey(disableKeyRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(disableKeyRequest2, disableKeyResult);
                }
                return disableKeyResult;
            }
        });
    }

    @Override
    public Future<DisableKeyRotationResult> disableKeyRotationAsync(DisableKeyRotationRequest disableKeyRotationRequest) {
        return this.disableKeyRotationAsync(disableKeyRotationRequest, null);
    }

    @Override
    public Future<DisableKeyRotationResult> disableKeyRotationAsync(DisableKeyRotationRequest disableKeyRotationRequest, final AsyncHandler<DisableKeyRotationRequest, DisableKeyRotationResult> asyncHandler) {
        final DisableKeyRotationRequest disableKeyRotationRequest2 = this.beforeClientExecution(disableKeyRotationRequest);
        return this.executorService.submit(new Callable<DisableKeyRotationResult>(){

            @Override
            public DisableKeyRotationResult call() throws Exception {
                DisableKeyRotationResult disableKeyRotationResult = null;
                try {
                    disableKeyRotationResult = AWSKMSAsyncClient.this.executeDisableKeyRotation(disableKeyRotationRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(disableKeyRotationRequest2, disableKeyRotationResult);
                }
                return disableKeyRotationResult;
            }
        });
    }

    @Override
    public Future<DisconnectCustomKeyStoreResult> disconnectCustomKeyStoreAsync(DisconnectCustomKeyStoreRequest disconnectCustomKeyStoreRequest) {
        return this.disconnectCustomKeyStoreAsync(disconnectCustomKeyStoreRequest, null);
    }

    @Override
    public Future<DisconnectCustomKeyStoreResult> disconnectCustomKeyStoreAsync(DisconnectCustomKeyStoreRequest disconnectCustomKeyStoreRequest, final AsyncHandler<DisconnectCustomKeyStoreRequest, DisconnectCustomKeyStoreResult> asyncHandler) {
        final DisconnectCustomKeyStoreRequest disconnectCustomKeyStoreRequest2 = this.beforeClientExecution(disconnectCustomKeyStoreRequest);
        return this.executorService.submit(new Callable<DisconnectCustomKeyStoreResult>(){

            @Override
            public DisconnectCustomKeyStoreResult call() throws Exception {
                DisconnectCustomKeyStoreResult disconnectCustomKeyStoreResult = null;
                try {
                    disconnectCustomKeyStoreResult = AWSKMSAsyncClient.this.executeDisconnectCustomKeyStore(disconnectCustomKeyStoreRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(disconnectCustomKeyStoreRequest2, disconnectCustomKeyStoreResult);
                }
                return disconnectCustomKeyStoreResult;
            }
        });
    }

    @Override
    public Future<EnableKeyResult> enableKeyAsync(EnableKeyRequest enableKeyRequest) {
        return this.enableKeyAsync(enableKeyRequest, null);
    }

    @Override
    public Future<EnableKeyResult> enableKeyAsync(EnableKeyRequest enableKeyRequest, final AsyncHandler<EnableKeyRequest, EnableKeyResult> asyncHandler) {
        final EnableKeyRequest enableKeyRequest2 = this.beforeClientExecution(enableKeyRequest);
        return this.executorService.submit(new Callable<EnableKeyResult>(){

            @Override
            public EnableKeyResult call() throws Exception {
                EnableKeyResult enableKeyResult = null;
                try {
                    enableKeyResult = AWSKMSAsyncClient.this.executeEnableKey(enableKeyRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(enableKeyRequest2, enableKeyResult);
                }
                return enableKeyResult;
            }
        });
    }

    @Override
    public Future<EnableKeyRotationResult> enableKeyRotationAsync(EnableKeyRotationRequest enableKeyRotationRequest) {
        return this.enableKeyRotationAsync(enableKeyRotationRequest, null);
    }

    @Override
    public Future<EnableKeyRotationResult> enableKeyRotationAsync(EnableKeyRotationRequest enableKeyRotationRequest, final AsyncHandler<EnableKeyRotationRequest, EnableKeyRotationResult> asyncHandler) {
        final EnableKeyRotationRequest enableKeyRotationRequest2 = this.beforeClientExecution(enableKeyRotationRequest);
        return this.executorService.submit(new Callable<EnableKeyRotationResult>(){

            @Override
            public EnableKeyRotationResult call() throws Exception {
                EnableKeyRotationResult enableKeyRotationResult = null;
                try {
                    enableKeyRotationResult = AWSKMSAsyncClient.this.executeEnableKeyRotation(enableKeyRotationRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(enableKeyRotationRequest2, enableKeyRotationResult);
                }
                return enableKeyRotationResult;
            }
        });
    }

    @Override
    public Future<EncryptResult> encryptAsync(EncryptRequest encryptRequest) {
        return this.encryptAsync(encryptRequest, null);
    }

    @Override
    public Future<EncryptResult> encryptAsync(EncryptRequest encryptRequest, final AsyncHandler<EncryptRequest, EncryptResult> asyncHandler) {
        final EncryptRequest encryptRequest2 = this.beforeClientExecution(encryptRequest);
        return this.executorService.submit(new Callable<EncryptResult>(){

            @Override
            public EncryptResult call() throws Exception {
                EncryptResult encryptResult = null;
                try {
                    encryptResult = AWSKMSAsyncClient.this.executeEncrypt(encryptRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(encryptRequest2, encryptResult);
                }
                return encryptResult;
            }
        });
    }

    @Override
    public Future<GenerateDataKeyResult> generateDataKeyAsync(GenerateDataKeyRequest generateDataKeyRequest) {
        return this.generateDataKeyAsync(generateDataKeyRequest, null);
    }

    @Override
    public Future<GenerateDataKeyResult> generateDataKeyAsync(GenerateDataKeyRequest generateDataKeyRequest, final AsyncHandler<GenerateDataKeyRequest, GenerateDataKeyResult> asyncHandler) {
        final GenerateDataKeyRequest generateDataKeyRequest2 = this.beforeClientExecution(generateDataKeyRequest);
        return this.executorService.submit(new Callable<GenerateDataKeyResult>(){

            @Override
            public GenerateDataKeyResult call() throws Exception {
                GenerateDataKeyResult generateDataKeyResult = null;
                try {
                    generateDataKeyResult = AWSKMSAsyncClient.this.executeGenerateDataKey(generateDataKeyRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(generateDataKeyRequest2, generateDataKeyResult);
                }
                return generateDataKeyResult;
            }
        });
    }

    @Override
    public Future<GenerateDataKeyPairResult> generateDataKeyPairAsync(GenerateDataKeyPairRequest generateDataKeyPairRequest) {
        return this.generateDataKeyPairAsync(generateDataKeyPairRequest, null);
    }

    @Override
    public Future<GenerateDataKeyPairResult> generateDataKeyPairAsync(GenerateDataKeyPairRequest generateDataKeyPairRequest, final AsyncHandler<GenerateDataKeyPairRequest, GenerateDataKeyPairResult> asyncHandler) {
        final GenerateDataKeyPairRequest generateDataKeyPairRequest2 = this.beforeClientExecution(generateDataKeyPairRequest);
        return this.executorService.submit(new Callable<GenerateDataKeyPairResult>(){

            @Override
            public GenerateDataKeyPairResult call() throws Exception {
                GenerateDataKeyPairResult generateDataKeyPairResult = null;
                try {
                    generateDataKeyPairResult = AWSKMSAsyncClient.this.executeGenerateDataKeyPair(generateDataKeyPairRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(generateDataKeyPairRequest2, generateDataKeyPairResult);
                }
                return generateDataKeyPairResult;
            }
        });
    }

    @Override
    public Future<GenerateDataKeyPairWithoutPlaintextResult> generateDataKeyPairWithoutPlaintextAsync(GenerateDataKeyPairWithoutPlaintextRequest generateDataKeyPairWithoutPlaintextRequest) {
        return this.generateDataKeyPairWithoutPlaintextAsync(generateDataKeyPairWithoutPlaintextRequest, null);
    }

    @Override
    public Future<GenerateDataKeyPairWithoutPlaintextResult> generateDataKeyPairWithoutPlaintextAsync(GenerateDataKeyPairWithoutPlaintextRequest generateDataKeyPairWithoutPlaintextRequest, final AsyncHandler<GenerateDataKeyPairWithoutPlaintextRequest, GenerateDataKeyPairWithoutPlaintextResult> asyncHandler) {
        final GenerateDataKeyPairWithoutPlaintextRequest generateDataKeyPairWithoutPlaintextRequest2 = this.beforeClientExecution(generateDataKeyPairWithoutPlaintextRequest);
        return this.executorService.submit(new Callable<GenerateDataKeyPairWithoutPlaintextResult>(){

            @Override
            public GenerateDataKeyPairWithoutPlaintextResult call() throws Exception {
                GenerateDataKeyPairWithoutPlaintextResult generateDataKeyPairWithoutPlaintextResult = null;
                try {
                    generateDataKeyPairWithoutPlaintextResult = AWSKMSAsyncClient.this.executeGenerateDataKeyPairWithoutPlaintext(generateDataKeyPairWithoutPlaintextRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(generateDataKeyPairWithoutPlaintextRequest2, generateDataKeyPairWithoutPlaintextResult);
                }
                return generateDataKeyPairWithoutPlaintextResult;
            }
        });
    }

    @Override
    public Future<GenerateDataKeyWithoutPlaintextResult> generateDataKeyWithoutPlaintextAsync(GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest) {
        return this.generateDataKeyWithoutPlaintextAsync(generateDataKeyWithoutPlaintextRequest, null);
    }

    @Override
    public Future<GenerateDataKeyWithoutPlaintextResult> generateDataKeyWithoutPlaintextAsync(GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest, final AsyncHandler<GenerateDataKeyWithoutPlaintextRequest, GenerateDataKeyWithoutPlaintextResult> asyncHandler) {
        final GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest2 = this.beforeClientExecution(generateDataKeyWithoutPlaintextRequest);
        return this.executorService.submit(new Callable<GenerateDataKeyWithoutPlaintextResult>(){

            @Override
            public GenerateDataKeyWithoutPlaintextResult call() throws Exception {
                GenerateDataKeyWithoutPlaintextResult generateDataKeyWithoutPlaintextResult = null;
                try {
                    generateDataKeyWithoutPlaintextResult = AWSKMSAsyncClient.this.executeGenerateDataKeyWithoutPlaintext(generateDataKeyWithoutPlaintextRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(generateDataKeyWithoutPlaintextRequest2, generateDataKeyWithoutPlaintextResult);
                }
                return generateDataKeyWithoutPlaintextResult;
            }
        });
    }

    @Override
    public Future<GenerateMacResult> generateMacAsync(GenerateMacRequest generateMacRequest) {
        return this.generateMacAsync(generateMacRequest, null);
    }

    @Override
    public Future<GenerateMacResult> generateMacAsync(GenerateMacRequest generateMacRequest, final AsyncHandler<GenerateMacRequest, GenerateMacResult> asyncHandler) {
        final GenerateMacRequest generateMacRequest2 = this.beforeClientExecution(generateMacRequest);
        return this.executorService.submit(new Callable<GenerateMacResult>(){

            @Override
            public GenerateMacResult call() throws Exception {
                GenerateMacResult generateMacResult = null;
                try {
                    generateMacResult = AWSKMSAsyncClient.this.executeGenerateMac(generateMacRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(generateMacRequest2, generateMacResult);
                }
                return generateMacResult;
            }
        });
    }

    @Override
    public Future<GenerateRandomResult> generateRandomAsync(GenerateRandomRequest generateRandomRequest) {
        return this.generateRandomAsync(generateRandomRequest, null);
    }

    @Override
    public Future<GenerateRandomResult> generateRandomAsync(GenerateRandomRequest generateRandomRequest, final AsyncHandler<GenerateRandomRequest, GenerateRandomResult> asyncHandler) {
        final GenerateRandomRequest generateRandomRequest2 = this.beforeClientExecution(generateRandomRequest);
        return this.executorService.submit(new Callable<GenerateRandomResult>(){

            @Override
            public GenerateRandomResult call() throws Exception {
                GenerateRandomResult generateRandomResult = null;
                try {
                    generateRandomResult = AWSKMSAsyncClient.this.executeGenerateRandom(generateRandomRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(generateRandomRequest2, generateRandomResult);
                }
                return generateRandomResult;
            }
        });
    }

    @Override
    public Future<GenerateRandomResult> generateRandomAsync() {
        return this.generateRandomAsync(new GenerateRandomRequest());
    }

    @Override
    public Future<GenerateRandomResult> generateRandomAsync(AsyncHandler<GenerateRandomRequest, GenerateRandomResult> asyncHandler) {
        return this.generateRandomAsync(new GenerateRandomRequest(), asyncHandler);
    }

    @Override
    public Future<GetKeyPolicyResult> getKeyPolicyAsync(GetKeyPolicyRequest getKeyPolicyRequest) {
        return this.getKeyPolicyAsync(getKeyPolicyRequest, null);
    }

    @Override
    public Future<GetKeyPolicyResult> getKeyPolicyAsync(GetKeyPolicyRequest getKeyPolicyRequest, final AsyncHandler<GetKeyPolicyRequest, GetKeyPolicyResult> asyncHandler) {
        final GetKeyPolicyRequest getKeyPolicyRequest2 = this.beforeClientExecution(getKeyPolicyRequest);
        return this.executorService.submit(new Callable<GetKeyPolicyResult>(){

            @Override
            public GetKeyPolicyResult call() throws Exception {
                GetKeyPolicyResult getKeyPolicyResult = null;
                try {
                    getKeyPolicyResult = AWSKMSAsyncClient.this.executeGetKeyPolicy(getKeyPolicyRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(getKeyPolicyRequest2, getKeyPolicyResult);
                }
                return getKeyPolicyResult;
            }
        });
    }

    @Override
    public Future<GetKeyRotationStatusResult> getKeyRotationStatusAsync(GetKeyRotationStatusRequest getKeyRotationStatusRequest) {
        return this.getKeyRotationStatusAsync(getKeyRotationStatusRequest, null);
    }

    @Override
    public Future<GetKeyRotationStatusResult> getKeyRotationStatusAsync(GetKeyRotationStatusRequest getKeyRotationStatusRequest, final AsyncHandler<GetKeyRotationStatusRequest, GetKeyRotationStatusResult> asyncHandler) {
        final GetKeyRotationStatusRequest getKeyRotationStatusRequest2 = this.beforeClientExecution(getKeyRotationStatusRequest);
        return this.executorService.submit(new Callable<GetKeyRotationStatusResult>(){

            @Override
            public GetKeyRotationStatusResult call() throws Exception {
                GetKeyRotationStatusResult getKeyRotationStatusResult = null;
                try {
                    getKeyRotationStatusResult = AWSKMSAsyncClient.this.executeGetKeyRotationStatus(getKeyRotationStatusRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(getKeyRotationStatusRequest2, getKeyRotationStatusResult);
                }
                return getKeyRotationStatusResult;
            }
        });
    }

    @Override
    public Future<GetParametersForImportResult> getParametersForImportAsync(GetParametersForImportRequest getParametersForImportRequest) {
        return this.getParametersForImportAsync(getParametersForImportRequest, null);
    }

    @Override
    public Future<GetParametersForImportResult> getParametersForImportAsync(GetParametersForImportRequest getParametersForImportRequest, final AsyncHandler<GetParametersForImportRequest, GetParametersForImportResult> asyncHandler) {
        final GetParametersForImportRequest getParametersForImportRequest2 = this.beforeClientExecution(getParametersForImportRequest);
        return this.executorService.submit(new Callable<GetParametersForImportResult>(){

            @Override
            public GetParametersForImportResult call() throws Exception {
                GetParametersForImportResult getParametersForImportResult = null;
                try {
                    getParametersForImportResult = AWSKMSAsyncClient.this.executeGetParametersForImport(getParametersForImportRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(getParametersForImportRequest2, getParametersForImportResult);
                }
                return getParametersForImportResult;
            }
        });
    }

    @Override
    public Future<GetPublicKeyResult> getPublicKeyAsync(GetPublicKeyRequest getPublicKeyRequest) {
        return this.getPublicKeyAsync(getPublicKeyRequest, null);
    }

    @Override
    public Future<GetPublicKeyResult> getPublicKeyAsync(GetPublicKeyRequest getPublicKeyRequest, final AsyncHandler<GetPublicKeyRequest, GetPublicKeyResult> asyncHandler) {
        final GetPublicKeyRequest getPublicKeyRequest2 = this.beforeClientExecution(getPublicKeyRequest);
        return this.executorService.submit(new Callable<GetPublicKeyResult>(){

            @Override
            public GetPublicKeyResult call() throws Exception {
                GetPublicKeyResult getPublicKeyResult = null;
                try {
                    getPublicKeyResult = AWSKMSAsyncClient.this.executeGetPublicKey(getPublicKeyRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(getPublicKeyRequest2, getPublicKeyResult);
                }
                return getPublicKeyResult;
            }
        });
    }

    @Override
    public Future<ImportKeyMaterialResult> importKeyMaterialAsync(ImportKeyMaterialRequest importKeyMaterialRequest) {
        return this.importKeyMaterialAsync(importKeyMaterialRequest, null);
    }

    @Override
    public Future<ImportKeyMaterialResult> importKeyMaterialAsync(ImportKeyMaterialRequest importKeyMaterialRequest, final AsyncHandler<ImportKeyMaterialRequest, ImportKeyMaterialResult> asyncHandler) {
        final ImportKeyMaterialRequest importKeyMaterialRequest2 = this.beforeClientExecution(importKeyMaterialRequest);
        return this.executorService.submit(new Callable<ImportKeyMaterialResult>(){

            @Override
            public ImportKeyMaterialResult call() throws Exception {
                ImportKeyMaterialResult importKeyMaterialResult = null;
                try {
                    importKeyMaterialResult = AWSKMSAsyncClient.this.executeImportKeyMaterial(importKeyMaterialRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(importKeyMaterialRequest2, importKeyMaterialResult);
                }
                return importKeyMaterialResult;
            }
        });
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync(ListAliasesRequest listAliasesRequest) {
        return this.listAliasesAsync(listAliasesRequest, null);
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync(ListAliasesRequest listAliasesRequest, final AsyncHandler<ListAliasesRequest, ListAliasesResult> asyncHandler) {
        final ListAliasesRequest listAliasesRequest2 = this.beforeClientExecution(listAliasesRequest);
        return this.executorService.submit(new Callable<ListAliasesResult>(){

            @Override
            public ListAliasesResult call() throws Exception {
                ListAliasesResult listAliasesResult = null;
                try {
                    listAliasesResult = AWSKMSAsyncClient.this.executeListAliases(listAliasesRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(listAliasesRequest2, listAliasesResult);
                }
                return listAliasesResult;
            }
        });
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync() {
        return this.listAliasesAsync(new ListAliasesRequest());
    }

    @Override
    public Future<ListAliasesResult> listAliasesAsync(AsyncHandler<ListAliasesRequest, ListAliasesResult> asyncHandler) {
        return this.listAliasesAsync(new ListAliasesRequest(), asyncHandler);
    }

    @Override
    public Future<ListGrantsResult> listGrantsAsync(ListGrantsRequest listGrantsRequest) {
        return this.listGrantsAsync(listGrantsRequest, null);
    }

    @Override
    public Future<ListGrantsResult> listGrantsAsync(ListGrantsRequest listGrantsRequest, final AsyncHandler<ListGrantsRequest, ListGrantsResult> asyncHandler) {
        final ListGrantsRequest listGrantsRequest2 = this.beforeClientExecution(listGrantsRequest);
        return this.executorService.submit(new Callable<ListGrantsResult>(){

            @Override
            public ListGrantsResult call() throws Exception {
                ListGrantsResult listGrantsResult = null;
                try {
                    listGrantsResult = AWSKMSAsyncClient.this.executeListGrants(listGrantsRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(listGrantsRequest2, listGrantsResult);
                }
                return listGrantsResult;
            }
        });
    }

    @Override
    public Future<ListKeyPoliciesResult> listKeyPoliciesAsync(ListKeyPoliciesRequest listKeyPoliciesRequest) {
        return this.listKeyPoliciesAsync(listKeyPoliciesRequest, null);
    }

    @Override
    public Future<ListKeyPoliciesResult> listKeyPoliciesAsync(ListKeyPoliciesRequest listKeyPoliciesRequest, final AsyncHandler<ListKeyPoliciesRequest, ListKeyPoliciesResult> asyncHandler) {
        final ListKeyPoliciesRequest listKeyPoliciesRequest2 = this.beforeClientExecution(listKeyPoliciesRequest);
        return this.executorService.submit(new Callable<ListKeyPoliciesResult>(){

            @Override
            public ListKeyPoliciesResult call() throws Exception {
                ListKeyPoliciesResult listKeyPoliciesResult = null;
                try {
                    listKeyPoliciesResult = AWSKMSAsyncClient.this.executeListKeyPolicies(listKeyPoliciesRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(listKeyPoliciesRequest2, listKeyPoliciesResult);
                }
                return listKeyPoliciesResult;
            }
        });
    }

    @Override
    public Future<ListKeysResult> listKeysAsync(ListKeysRequest listKeysRequest) {
        return this.listKeysAsync(listKeysRequest, null);
    }

    @Override
    public Future<ListKeysResult> listKeysAsync(ListKeysRequest listKeysRequest, final AsyncHandler<ListKeysRequest, ListKeysResult> asyncHandler) {
        final ListKeysRequest listKeysRequest2 = this.beforeClientExecution(listKeysRequest);
        return this.executorService.submit(new Callable<ListKeysResult>(){

            @Override
            public ListKeysResult call() throws Exception {
                ListKeysResult listKeysResult = null;
                try {
                    listKeysResult = AWSKMSAsyncClient.this.executeListKeys(listKeysRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(listKeysRequest2, listKeysResult);
                }
                return listKeysResult;
            }
        });
    }

    @Override
    public Future<ListKeysResult> listKeysAsync() {
        return this.listKeysAsync(new ListKeysRequest());
    }

    @Override
    public Future<ListKeysResult> listKeysAsync(AsyncHandler<ListKeysRequest, ListKeysResult> asyncHandler) {
        return this.listKeysAsync(new ListKeysRequest(), asyncHandler);
    }

    @Override
    public Future<ListResourceTagsResult> listResourceTagsAsync(ListResourceTagsRequest listResourceTagsRequest) {
        return this.listResourceTagsAsync(listResourceTagsRequest, null);
    }

    @Override
    public Future<ListResourceTagsResult> listResourceTagsAsync(ListResourceTagsRequest listResourceTagsRequest, final AsyncHandler<ListResourceTagsRequest, ListResourceTagsResult> asyncHandler) {
        final ListResourceTagsRequest listResourceTagsRequest2 = this.beforeClientExecution(listResourceTagsRequest);
        return this.executorService.submit(new Callable<ListResourceTagsResult>(){

            @Override
            public ListResourceTagsResult call() throws Exception {
                ListResourceTagsResult listResourceTagsResult = null;
                try {
                    listResourceTagsResult = AWSKMSAsyncClient.this.executeListResourceTags(listResourceTagsRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(listResourceTagsRequest2, listResourceTagsResult);
                }
                return listResourceTagsResult;
            }
        });
    }

    @Override
    public Future<ListRetirableGrantsResult> listRetirableGrantsAsync(ListRetirableGrantsRequest listRetirableGrantsRequest) {
        return this.listRetirableGrantsAsync(listRetirableGrantsRequest, null);
    }

    @Override
    public Future<ListRetirableGrantsResult> listRetirableGrantsAsync(ListRetirableGrantsRequest listRetirableGrantsRequest, final AsyncHandler<ListRetirableGrantsRequest, ListRetirableGrantsResult> asyncHandler) {
        final ListRetirableGrantsRequest listRetirableGrantsRequest2 = this.beforeClientExecution(listRetirableGrantsRequest);
        return this.executorService.submit(new Callable<ListRetirableGrantsResult>(){

            @Override
            public ListRetirableGrantsResult call() throws Exception {
                ListRetirableGrantsResult listRetirableGrantsResult = null;
                try {
                    listRetirableGrantsResult = AWSKMSAsyncClient.this.executeListRetirableGrants(listRetirableGrantsRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(listRetirableGrantsRequest2, listRetirableGrantsResult);
                }
                return listRetirableGrantsResult;
            }
        });
    }

    @Override
    public Future<PutKeyPolicyResult> putKeyPolicyAsync(PutKeyPolicyRequest putKeyPolicyRequest) {
        return this.putKeyPolicyAsync(putKeyPolicyRequest, null);
    }

    @Override
    public Future<PutKeyPolicyResult> putKeyPolicyAsync(PutKeyPolicyRequest putKeyPolicyRequest, final AsyncHandler<PutKeyPolicyRequest, PutKeyPolicyResult> asyncHandler) {
        final PutKeyPolicyRequest putKeyPolicyRequest2 = this.beforeClientExecution(putKeyPolicyRequest);
        return this.executorService.submit(new Callable<PutKeyPolicyResult>(){

            @Override
            public PutKeyPolicyResult call() throws Exception {
                PutKeyPolicyResult putKeyPolicyResult = null;
                try {
                    putKeyPolicyResult = AWSKMSAsyncClient.this.executePutKeyPolicy(putKeyPolicyRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(putKeyPolicyRequest2, putKeyPolicyResult);
                }
                return putKeyPolicyResult;
            }
        });
    }

    @Override
    public Future<ReEncryptResult> reEncryptAsync(ReEncryptRequest reEncryptRequest) {
        return this.reEncryptAsync(reEncryptRequest, null);
    }

    @Override
    public Future<ReEncryptResult> reEncryptAsync(ReEncryptRequest reEncryptRequest, final AsyncHandler<ReEncryptRequest, ReEncryptResult> asyncHandler) {
        final ReEncryptRequest reEncryptRequest2 = this.beforeClientExecution(reEncryptRequest);
        return this.executorService.submit(new Callable<ReEncryptResult>(){

            @Override
            public ReEncryptResult call() throws Exception {
                ReEncryptResult reEncryptResult = null;
                try {
                    reEncryptResult = AWSKMSAsyncClient.this.executeReEncrypt(reEncryptRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(reEncryptRequest2, reEncryptResult);
                }
                return reEncryptResult;
            }
        });
    }

    @Override
    public Future<ReplicateKeyResult> replicateKeyAsync(ReplicateKeyRequest replicateKeyRequest) {
        return this.replicateKeyAsync(replicateKeyRequest, null);
    }

    @Override
    public Future<ReplicateKeyResult> replicateKeyAsync(ReplicateKeyRequest replicateKeyRequest, final AsyncHandler<ReplicateKeyRequest, ReplicateKeyResult> asyncHandler) {
        final ReplicateKeyRequest replicateKeyRequest2 = this.beforeClientExecution(replicateKeyRequest);
        return this.executorService.submit(new Callable<ReplicateKeyResult>(){

            @Override
            public ReplicateKeyResult call() throws Exception {
                ReplicateKeyResult replicateKeyResult = null;
                try {
                    replicateKeyResult = AWSKMSAsyncClient.this.executeReplicateKey(replicateKeyRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(replicateKeyRequest2, replicateKeyResult);
                }
                return replicateKeyResult;
            }
        });
    }

    @Override
    public Future<RetireGrantResult> retireGrantAsync(RetireGrantRequest retireGrantRequest) {
        return this.retireGrantAsync(retireGrantRequest, null);
    }

    @Override
    public Future<RetireGrantResult> retireGrantAsync(RetireGrantRequest retireGrantRequest, final AsyncHandler<RetireGrantRequest, RetireGrantResult> asyncHandler) {
        final RetireGrantRequest retireGrantRequest2 = this.beforeClientExecution(retireGrantRequest);
        return this.executorService.submit(new Callable<RetireGrantResult>(){

            @Override
            public RetireGrantResult call() throws Exception {
                RetireGrantResult retireGrantResult = null;
                try {
                    retireGrantResult = AWSKMSAsyncClient.this.executeRetireGrant(retireGrantRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(retireGrantRequest2, retireGrantResult);
                }
                return retireGrantResult;
            }
        });
    }

    @Override
    public Future<RetireGrantResult> retireGrantAsync() {
        return this.retireGrantAsync(new RetireGrantRequest());
    }

    @Override
    public Future<RetireGrantResult> retireGrantAsync(AsyncHandler<RetireGrantRequest, RetireGrantResult> asyncHandler) {
        return this.retireGrantAsync(new RetireGrantRequest(), asyncHandler);
    }

    @Override
    public Future<RevokeGrantResult> revokeGrantAsync(RevokeGrantRequest revokeGrantRequest) {
        return this.revokeGrantAsync(revokeGrantRequest, null);
    }

    @Override
    public Future<RevokeGrantResult> revokeGrantAsync(RevokeGrantRequest revokeGrantRequest, final AsyncHandler<RevokeGrantRequest, RevokeGrantResult> asyncHandler) {
        final RevokeGrantRequest revokeGrantRequest2 = this.beforeClientExecution(revokeGrantRequest);
        return this.executorService.submit(new Callable<RevokeGrantResult>(){

            @Override
            public RevokeGrantResult call() throws Exception {
                RevokeGrantResult revokeGrantResult = null;
                try {
                    revokeGrantResult = AWSKMSAsyncClient.this.executeRevokeGrant(revokeGrantRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(revokeGrantRequest2, revokeGrantResult);
                }
                return revokeGrantResult;
            }
        });
    }

    @Override
    public Future<ScheduleKeyDeletionResult> scheduleKeyDeletionAsync(ScheduleKeyDeletionRequest scheduleKeyDeletionRequest) {
        return this.scheduleKeyDeletionAsync(scheduleKeyDeletionRequest, null);
    }

    @Override
    public Future<ScheduleKeyDeletionResult> scheduleKeyDeletionAsync(ScheduleKeyDeletionRequest scheduleKeyDeletionRequest, final AsyncHandler<ScheduleKeyDeletionRequest, ScheduleKeyDeletionResult> asyncHandler) {
        final ScheduleKeyDeletionRequest scheduleKeyDeletionRequest2 = this.beforeClientExecution(scheduleKeyDeletionRequest);
        return this.executorService.submit(new Callable<ScheduleKeyDeletionResult>(){

            @Override
            public ScheduleKeyDeletionResult call() throws Exception {
                ScheduleKeyDeletionResult scheduleKeyDeletionResult = null;
                try {
                    scheduleKeyDeletionResult = AWSKMSAsyncClient.this.executeScheduleKeyDeletion(scheduleKeyDeletionRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(scheduleKeyDeletionRequest2, scheduleKeyDeletionResult);
                }
                return scheduleKeyDeletionResult;
            }
        });
    }

    @Override
    public Future<SignResult> signAsync(SignRequest signRequest) {
        return this.signAsync(signRequest, null);
    }

    @Override
    public Future<SignResult> signAsync(SignRequest signRequest, final AsyncHandler<SignRequest, SignResult> asyncHandler) {
        final SignRequest signRequest2 = this.beforeClientExecution(signRequest);
        return this.executorService.submit(new Callable<SignResult>(){

            @Override
            public SignResult call() throws Exception {
                SignResult signResult = null;
                try {
                    signResult = AWSKMSAsyncClient.this.executeSign(signRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(signRequest2, signResult);
                }
                return signResult;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest tagResourceRequest) {
        return this.tagResourceAsync(tagResourceRequest, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest tagResourceRequest, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest tagResourceRequest2 = this.beforeClientExecution(tagResourceRequest);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult tagResourceResult = null;
                try {
                    tagResourceResult = AWSKMSAsyncClient.this.executeTagResource(tagResourceRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(tagResourceRequest2, tagResourceResult);
                }
                return tagResourceResult;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest untagResourceRequest) {
        return this.untagResourceAsync(untagResourceRequest, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest untagResourceRequest, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest untagResourceRequest2 = this.beforeClientExecution(untagResourceRequest);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult untagResourceResult = null;
                try {
                    untagResourceResult = AWSKMSAsyncClient.this.executeUntagResource(untagResourceRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(untagResourceRequest2, untagResourceResult);
                }
                return untagResourceResult;
            }
        });
    }

    @Override
    public Future<UpdateAliasResult> updateAliasAsync(UpdateAliasRequest updateAliasRequest) {
        return this.updateAliasAsync(updateAliasRequest, null);
    }

    @Override
    public Future<UpdateAliasResult> updateAliasAsync(UpdateAliasRequest updateAliasRequest, final AsyncHandler<UpdateAliasRequest, UpdateAliasResult> asyncHandler) {
        final UpdateAliasRequest updateAliasRequest2 = this.beforeClientExecution(updateAliasRequest);
        return this.executorService.submit(new Callable<UpdateAliasResult>(){

            @Override
            public UpdateAliasResult call() throws Exception {
                UpdateAliasResult updateAliasResult = null;
                try {
                    updateAliasResult = AWSKMSAsyncClient.this.executeUpdateAlias(updateAliasRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(updateAliasRequest2, updateAliasResult);
                }
                return updateAliasResult;
            }
        });
    }

    @Override
    public Future<UpdateCustomKeyStoreResult> updateCustomKeyStoreAsync(UpdateCustomKeyStoreRequest updateCustomKeyStoreRequest) {
        return this.updateCustomKeyStoreAsync(updateCustomKeyStoreRequest, null);
    }

    @Override
    public Future<UpdateCustomKeyStoreResult> updateCustomKeyStoreAsync(UpdateCustomKeyStoreRequest updateCustomKeyStoreRequest, final AsyncHandler<UpdateCustomKeyStoreRequest, UpdateCustomKeyStoreResult> asyncHandler) {
        final UpdateCustomKeyStoreRequest updateCustomKeyStoreRequest2 = this.beforeClientExecution(updateCustomKeyStoreRequest);
        return this.executorService.submit(new Callable<UpdateCustomKeyStoreResult>(){

            @Override
            public UpdateCustomKeyStoreResult call() throws Exception {
                UpdateCustomKeyStoreResult updateCustomKeyStoreResult = null;
                try {
                    updateCustomKeyStoreResult = AWSKMSAsyncClient.this.executeUpdateCustomKeyStore(updateCustomKeyStoreRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(updateCustomKeyStoreRequest2, updateCustomKeyStoreResult);
                }
                return updateCustomKeyStoreResult;
            }
        });
    }

    @Override
    public Future<UpdateKeyDescriptionResult> updateKeyDescriptionAsync(UpdateKeyDescriptionRequest updateKeyDescriptionRequest) {
        return this.updateKeyDescriptionAsync(updateKeyDescriptionRequest, null);
    }

    @Override
    public Future<UpdateKeyDescriptionResult> updateKeyDescriptionAsync(UpdateKeyDescriptionRequest updateKeyDescriptionRequest, final AsyncHandler<UpdateKeyDescriptionRequest, UpdateKeyDescriptionResult> asyncHandler) {
        final UpdateKeyDescriptionRequest updateKeyDescriptionRequest2 = this.beforeClientExecution(updateKeyDescriptionRequest);
        return this.executorService.submit(new Callable<UpdateKeyDescriptionResult>(){

            @Override
            public UpdateKeyDescriptionResult call() throws Exception {
                UpdateKeyDescriptionResult updateKeyDescriptionResult = null;
                try {
                    updateKeyDescriptionResult = AWSKMSAsyncClient.this.executeUpdateKeyDescription(updateKeyDescriptionRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(updateKeyDescriptionRequest2, updateKeyDescriptionResult);
                }
                return updateKeyDescriptionResult;
            }
        });
    }

    @Override
    public Future<UpdatePrimaryRegionResult> updatePrimaryRegionAsync(UpdatePrimaryRegionRequest updatePrimaryRegionRequest) {
        return this.updatePrimaryRegionAsync(updatePrimaryRegionRequest, null);
    }

    @Override
    public Future<UpdatePrimaryRegionResult> updatePrimaryRegionAsync(UpdatePrimaryRegionRequest updatePrimaryRegionRequest, final AsyncHandler<UpdatePrimaryRegionRequest, UpdatePrimaryRegionResult> asyncHandler) {
        final UpdatePrimaryRegionRequest updatePrimaryRegionRequest2 = this.beforeClientExecution(updatePrimaryRegionRequest);
        return this.executorService.submit(new Callable<UpdatePrimaryRegionResult>(){

            @Override
            public UpdatePrimaryRegionResult call() throws Exception {
                UpdatePrimaryRegionResult updatePrimaryRegionResult = null;
                try {
                    updatePrimaryRegionResult = AWSKMSAsyncClient.this.executeUpdatePrimaryRegion(updatePrimaryRegionRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(updatePrimaryRegionRequest2, updatePrimaryRegionResult);
                }
                return updatePrimaryRegionResult;
            }
        });
    }

    @Override
    public Future<VerifyResult> verifyAsync(VerifyRequest verifyRequest) {
        return this.verifyAsync(verifyRequest, null);
    }

    @Override
    public Future<VerifyResult> verifyAsync(VerifyRequest verifyRequest, final AsyncHandler<VerifyRequest, VerifyResult> asyncHandler) {
        final VerifyRequest verifyRequest2 = this.beforeClientExecution(verifyRequest);
        return this.executorService.submit(new Callable<VerifyResult>(){

            @Override
            public VerifyResult call() throws Exception {
                VerifyResult verifyResult = null;
                try {
                    verifyResult = AWSKMSAsyncClient.this.executeVerify(verifyRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(verifyRequest2, verifyResult);
                }
                return verifyResult;
            }
        });
    }

    @Override
    public Future<VerifyMacResult> verifyMacAsync(VerifyMacRequest verifyMacRequest) {
        return this.verifyMacAsync(verifyMacRequest, null);
    }

    @Override
    public Future<VerifyMacResult> verifyMacAsync(VerifyMacRequest verifyMacRequest, final AsyncHandler<VerifyMacRequest, VerifyMacResult> asyncHandler) {
        final VerifyMacRequest verifyMacRequest2 = this.beforeClientExecution(verifyMacRequest);
        return this.executorService.submit(new Callable<VerifyMacResult>(){

            @Override
            public VerifyMacResult call() throws Exception {
                VerifyMacResult verifyMacResult = null;
                try {
                    verifyMacResult = AWSKMSAsyncClient.this.executeVerifyMac(verifyMacRequest2);
                }
                catch (Exception exception) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(exception);
                    }
                    throw exception;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(verifyMacRequest2, verifyMacResult);
                }
                return verifyMacResult;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

