/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry.v2;

import com.amazonaws.retry.v2.RetryCondition;
import com.amazonaws.retry.v2.RetryPolicyContext;
import com.amazonaws.util.ValidationUtils;

public class MaxNumberOfRetriesCondition
implements RetryCondition {
    private final int maxNumberOfRetries;

    public MaxNumberOfRetriesCondition(int n) {
        this.maxNumberOfRetries = ValidationUtils.assertIsPositive(n, "maxNumberOfRetries");
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext retryPolicyContext) {
        return retryPolicyContext.retriesAttempted() < this.maxNumberOfRetries;
    }
}

