/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.auth.profile.internal.BasicProfileConfigFileLoader;
import com.amazonaws.internal.config.InternalConfig;
import com.amazonaws.retry.RetryMode;

@SdkInternalApi
public final class RetryModeResolver {
    private static final String PROFILE_PROPERTY = "retry_mode";
    private static final RetryMode SDK_DEFAULT_RETRY_MODE = RetryMode.LEGACY;
    private final BasicProfileConfigFileLoader configFileLoader;
    private final InternalConfig internalConfig;
    private final RetryMode retryMode;

    public RetryModeResolver() {
        this(BasicProfileConfigFileLoader.INSTANCE, InternalConfig.Factory.getInternalConfig());
    }

    @SdkTestInternalApi
    RetryModeResolver(BasicProfileConfigFileLoader basicProfileConfigFileLoader, InternalConfig internalConfig) {
        this.configFileLoader = basicProfileConfigFileLoader;
        this.internalConfig = internalConfig;
        this.retryMode = this.resolveRetryMode();
    }

    public RetryMode retryMode() {
        return this.retryMode;
    }

    private RetryMode systemProperty() {
        return RetryMode.fromName(System.getProperty("com.amazonaws.sdk.retryMode"));
    }

    private RetryMode envVar() {
        return RetryMode.fromName(System.getenv("AWS_RETRY_MODE"));
    }

    private RetryMode internalDefault() {
        return RetryMode.fromName(this.internalConfig.getDefaultRetryMode());
    }

    private RetryMode resolveRetryMode() {
        RetryMode retryMode = this.envVar();
        if (retryMode != null) {
            return retryMode;
        }
        retryMode = this.systemProperty();
        if (retryMode != null) {
            return retryMode;
        }
        retryMode = this.profile();
        if (retryMode != null) {
            return retryMode;
        }
        retryMode = this.internalDefault();
        if (retryMode != null) {
            return retryMode;
        }
        return SDK_DEFAULT_RETRY_MODE;
    }

    private RetryMode profile() {
        BasicProfile basicProfile = this.configFileLoader.getProfile();
        if (basicProfile == null) {
            return null;
        }
        String string = basicProfile.getPropertyValue(PROFILE_PROPERTY);
        return RetryMode.fromName(string);
    }
}

