/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.auth.profile.internal.AllProfiles;
import com.amazonaws.auth.profile.internal.AwsProfileNameLoader;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.auth.profile.internal.BasicProfileConfigLoader;
import com.amazonaws.profile.path.AwsProfileFileLocationProvider;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.util.StringUtils;
import java.io.File;

public class AwsProfileRegionProvider
extends AwsRegionProvider {
    private final String profileName;
    private final AwsProfileFileLocationProvider locationProvider;
    private final BasicProfileConfigLoader profileConfigLoader;

    public AwsProfileRegionProvider() {
        this(AwsProfileNameLoader.INSTANCE.loadProfileName());
    }

    public AwsProfileRegionProvider(String string) {
        this(string, AwsProfileFileLocationProvider.DEFAULT_CONFIG_LOCATION_PROVIDER, BasicProfileConfigLoader.INSTANCE);
    }

    @SdkTestInternalApi
    AwsProfileRegionProvider(String string, AwsProfileFileLocationProvider awsProfileFileLocationProvider, BasicProfileConfigLoader basicProfileConfigLoader) {
        this.profileName = string;
        this.locationProvider = awsProfileFileLocationProvider;
        this.profileConfigLoader = basicProfileConfigLoader;
    }

    @Override
    public String getRegion() throws SdkClientException {
        BasicProfile basicProfile;
        File file = this.locationProvider.getLocation();
        if (file != null && file.exists() && (basicProfile = this.loadProfile(file)) != null && !StringUtils.isNullOrEmpty(basicProfile.getRegion())) {
            return basicProfile.getRegion();
        }
        return null;
    }

    private BasicProfile loadProfile(File file) {
        AllProfiles allProfiles = this.profileConfigLoader.loadProfiles(file);
        return allProfiles.getProfile(this.profileName);
    }
}

