/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.json.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.protocol.json.StructuredJsonMarshaller;
import com.amazonaws.protocol.json.internal.JsonMarshaller;
import com.amazonaws.protocol.json.internal.JsonMarshallerContext;
import com.amazonaws.util.TimestampFormat;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class SimpleTypeJsonMarshallers {
    public static final JsonMarshaller<Void> NULL = new JsonMarshaller<Void>(){

        @Override
        public void marshall(Void void_, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<Void> marshallingInfo) {
            if (marshallingInfo == null) {
                jsonMarshallerContext.jsonGenerator().writeNull();
            } else if (marshallingInfo.isExplicitPayloadMember()) {
                if (marshallingInfo.marshallLocationName() != null) {
                    throw new IllegalStateException("Expected marshalling location name to be null if explicit member is null");
                }
                jsonMarshallerContext.emptyBodyJsonMarshaller().marshall(jsonMarshallerContext.jsonGenerator());
            }
        }
    };
    public static final JsonMarshaller<String> STRING = new BaseJsonMarshaller<String>(){

        @Override
        public void marshall(String string, StructuredJsonGenerator structuredJsonGenerator, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<String> marshallingInfo) {
            structuredJsonGenerator.writeValue(string);
        }
    };
    public static final JsonMarshaller<Integer> INTEGER = new BaseJsonMarshaller<Integer>(){

        @Override
        public void marshall(Integer n, StructuredJsonGenerator structuredJsonGenerator, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<Integer> marshallingInfo) {
            structuredJsonGenerator.writeValue(n);
        }
    };
    public static final JsonMarshaller<Long> LONG = new BaseJsonMarshaller<Long>(){

        @Override
        public void marshall(Long l, StructuredJsonGenerator structuredJsonGenerator, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<Long> marshallingInfo) {
            structuredJsonGenerator.writeValue(l);
        }
    };
    public static final JsonMarshaller<Short> SHORT = new BaseJsonMarshaller<Short>(){

        @Override
        public void marshall(Short s2, StructuredJsonGenerator structuredJsonGenerator, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<Short> marshallingInfo) {
            structuredJsonGenerator.writeValue(s2);
        }
    };
    public static final JsonMarshaller<Float> FLOAT = new BaseJsonMarshaller<Float>(){

        @Override
        public void marshall(Float f, StructuredJsonGenerator structuredJsonGenerator, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<Float> marshallingInfo) {
            structuredJsonGenerator.writeValue(f.floatValue());
        }
    };
    public static final JsonMarshaller<BigDecimal> BIG_DECIMAL = new BaseJsonMarshaller<BigDecimal>(){

        @Override
        public void marshall(BigDecimal bigDecimal, StructuredJsonGenerator structuredJsonGenerator, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<BigDecimal> marshallingInfo) {
            structuredJsonGenerator.writeValue(bigDecimal);
        }
    };
    public static final JsonMarshaller<Double> DOUBLE = new BaseJsonMarshaller<Double>(){

        @Override
        public void marshall(Double d, StructuredJsonGenerator structuredJsonGenerator, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<Double> marshallingInfo) {
            structuredJsonGenerator.writeValue(d);
        }
    };
    public static final JsonMarshaller<Boolean> BOOLEAN = new BaseJsonMarshaller<Boolean>(){

        @Override
        public void marshall(Boolean bl, StructuredJsonGenerator structuredJsonGenerator, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<Boolean> marshallingInfo) {
            structuredJsonGenerator.writeValue(bl);
        }
    };
    public static final JsonMarshaller<Date> DATE = new BaseJsonMarshaller<Date>(){

        @Override
        public void marshall(Date date, StructuredJsonGenerator structuredJsonGenerator, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<Date> marshallingInfo) {
            TimestampFormat timestampFormat = TimestampFormat.UNIX_TIMESTAMP;
            if (marshallingInfo != null && marshallingInfo.timestampFormat() != null) {
                timestampFormat = marshallingInfo.timestampFormat();
            }
            structuredJsonGenerator.writeValue(date, timestampFormat);
        }
    };
    public static final JsonMarshaller<ByteBuffer> BYTE_BUFFER = new BaseJsonMarshaller<ByteBuffer>(){

        @Override
        public void marshall(ByteBuffer byteBuffer, StructuredJsonGenerator structuredJsonGenerator, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<ByteBuffer> marshallingInfo) {
            structuredJsonGenerator.writeValue(byteBuffer);
        }
    };
    public static final JsonMarshaller<StructuredPojo> STRUCTURED = new BaseJsonMarshaller<StructuredPojo>(){

        @Override
        public void marshall(StructuredPojo structuredPojo, StructuredJsonGenerator structuredJsonGenerator, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<StructuredPojo> marshallingInfo) {
            structuredJsonGenerator.writeStartObject();
            structuredPojo.marshall(jsonMarshallerContext.protocolHandler());
            structuredJsonGenerator.writeEndObject();
        }
    };
    public static final JsonMarshaller<List> LIST = new BaseJsonMarshaller<List>(){

        @Override
        public void marshall(List list, StructuredJsonGenerator structuredJsonGenerator, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<List> marshallingInfo) {
            structuredJsonGenerator.writeStartArray();
            for (Object e : list) {
                jsonMarshallerContext.marshall(MarshallLocation.PAYLOAD, e);
            }
            structuredJsonGenerator.writeEndArray();
        }

        @Override
        protected boolean shouldEmit(List list) {
            return !list.isEmpty() || !(list instanceof SdkInternalList) || !((SdkInternalList)list).isAutoConstruct();
        }
    };
    public static final JsonMarshaller<Map> MAP = new BaseJsonMarshaller<Map>(){

        @Override
        public void marshall(Map map, StructuredJsonGenerator structuredJsonGenerator, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<Map> marshallingInfo) {
            structuredJsonGenerator.writeStartObject();
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                Object v = entry.getValue();
                structuredJsonGenerator.writeFieldName((String)entry.getKey());
                jsonMarshallerContext.marshall(MarshallLocation.PAYLOAD, v);
            }
            structuredJsonGenerator.writeEndObject();
        }

        @Override
        protected boolean shouldEmit(Map map) {
            return !map.isEmpty() || !(map instanceof SdkInternalMap) || !((SdkInternalMap)map).isAutoConstruct();
        }
    };

    public static <T> JsonMarshaller<T> adapt(final StructuredJsonMarshaller<T> structuredJsonMarshaller) {
        return new BaseJsonMarshaller<T>(){

            @Override
            public void marshall(T t2, StructuredJsonGenerator structuredJsonGenerator, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<T> marshallingInfo) {
                structuredJsonMarshaller.marshall(t2, structuredJsonGenerator);
            }
        };
    }

    private static abstract class BaseJsonMarshaller<T>
    implements JsonMarshaller<T> {
        private BaseJsonMarshaller() {
        }

        @Override
        public final void marshall(T t2, JsonMarshallerContext jsonMarshallerContext, MarshallingInfo<T> marshallingInfo) {
            if (!this.shouldEmit(t2)) {
                return;
            }
            if (marshallingInfo != null && marshallingInfo.marshallLocationName() != null) {
                jsonMarshallerContext.jsonGenerator().writeFieldName(marshallingInfo.marshallLocationName());
            }
            this.marshall(t2, jsonMarshallerContext.jsonGenerator(), jsonMarshallerContext, marshallingInfo);
        }

        public abstract void marshall(T var1, StructuredJsonGenerator var2, JsonMarshallerContext var3, MarshallingInfo<T> var4);

        protected boolean shouldEmit(T t2) {
            return true;
        }
    }
}

