/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.json;

import com.amazonaws.protocol.json.IonParser;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import software.amazon.ion.IonSystem;

class IonFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    private static final boolean SHOULD_CLOSE_READER_YES = true;
    private static final boolean SHOULD_CLOSE_READER_NO = false;
    private final transient IonSystem ionSystem;

    public IonFactory(IonSystem ionSystem) {
        this.ionSystem = ionSystem;
    }

    @Override
    public JsonParser createParser(InputStream inputStream2) throws IOException, JsonParseException {
        return new IonParser(this.ionSystem.newReader(inputStream2), false);
    }

    @Override
    public JsonParser createParser(byte[] byArray) throws IOException, JsonParseException {
        return new IonParser(this.ionSystem.newReader(byArray), false);
    }

    @Override
    public JsonParser createParser(byte[] byArray, int n, int n2) throws IOException, JsonParseException {
        return new IonParser(this.ionSystem.newReader(byArray, n, n2), false);
    }

    @Override
    public JsonParser createParser(char[] cArray) throws IOException, JsonParseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonParser createParser(char[] cArray, int n, int n2) throws IOException, JsonParseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonParser createParser(String string) throws IOException, JsonParseException {
        return new IonParser(this.ionSystem.newReader(string), false);
    }

    @Override
    public JsonParser createParser(Reader reader) throws IOException, JsonParseException {
        return new IonParser(this.ionSystem.newReader(reader), false);
    }

    @Override
    public JsonParser createParser(File file) throws IOException, JsonParseException {
        return new IonParser(this.ionSystem.newReader(new FileInputStream(file)), true);
    }

    @Override
    public JsonParser createParser(URL uRL) throws IOException, JsonParseException {
        return new IonParser(this.ionSystem.newReader(uRL.openStream()), true);
    }
}

