/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.partitions;

import com.amazonaws.partitions.model.Endpoint;
import com.amazonaws.partitions.model.Partition;
import com.amazonaws.partitions.model.Service;
import com.amazonaws.regions.RegionImpl;
import com.amazonaws.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PartitionRegionImpl
implements RegionImpl {
    private static final String SERVICE = "{service}";
    private static final String REGION = "{region}";
    private static final String DNS_SUFFIX = "{dnsSuffix}";
    private final Partition partition;
    private final String region;
    private final Map<String, Endpoint> endpointCache = new ConcurrentHashMap<String, Endpoint>();

    public PartitionRegionImpl(String string, Partition partition) {
        this.partition = ValidationUtils.assertNotNull(partition, "partition");
        this.region = ValidationUtils.assertNotNull(string, "region");
    }

    @Override
    public String getName() {
        return this.region;
    }

    @Override
    public String getDomain() {
        return this.partition.getDnsSuffix();
    }

    @Override
    public String getPartition() {
        return this.partition.getPartition();
    }

    @Override
    public String getServiceEndpoint(String string) {
        return this.getEndpointString(string, this.getEndpoint(string));
    }

    private Endpoint getEndpoint(String string) {
        Endpoint endpoint = this.endpointCache.get(string);
        if (endpoint == null && (endpoint = this.computeEndpoint(string)) == null) {
            return null;
        }
        this.endpointCache.put(string, endpoint);
        return endpoint;
    }

    private Endpoint computeEndpoint(String string) {
        Service service = this.partition.getServices().get(string);
        if (service != null) {
            if (service.getEndpoints().containsKey(this.region)) {
                Endpoint endpoint = Endpoint.merge(this.partition.getDefaults(), Endpoint.merge(service.getDefaults(), service.getEndpoints().get(this.region)));
                return endpoint;
            }
            if (service.isPartitionWideEndpointAvailable() && !service.isRegionalized()) {
                Endpoint endpoint = Endpoint.merge(this.partition.getDefaults(), Endpoint.merge(service.getDefaults(), service.getEndpoints().get(service.getPartitionEndpoint())));
                return endpoint;
            }
            if (this.partition.getDefaults() != null && this.partition.getDefaults().getHostName() != null) {
                return this.partition.getDefaults();
            }
        }
        return null;
    }

    private String getEndpointString(String string, Endpoint endpoint) {
        return endpoint == null ? null : endpoint.getHostName().replace(SERVICE, string).replace(REGION, this.region).replace(DNS_SUFFIX, this.partition.getDnsSuffix());
    }

    @Override
    public boolean isServiceSupported(String string) {
        return this.isServiceSupportedInRegion(string) || this.isServicePartitionWide(string);
    }

    private boolean isServiceSupportedInRegion(String string) {
        return this.partition.getServices().get(string) != null && this.partition.getServices().get(string).getEndpoints().containsKey(this.region);
    }

    private boolean isServicePartitionWide(String string) {
        return this.partition.getServices().get(string) != null && this.partition.getServices().get(string).getPartitionEndpoint() != null;
    }

    @Override
    public boolean hasHttpsEndpoint(String string) {
        if (!this.isServiceSupported(string)) {
            return false;
        }
        return this.getEndpoint(string).hasHttpsSupport();
    }

    @Override
    public boolean hasHttpEndpoint(String string) {
        if (!this.isServiceSupported(string)) {
            return false;
        }
        return this.getEndpoint(string).hasHttpSupport();
    }

    @Override
    public Collection<String> getAvailableEndpoints() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.partition.getServices().keySet()) {
            if (!this.isServiceSupported(string)) continue;
            arrayList.add(this.getServiceEndpoint(string));
        }
        return Collections.unmodifiableCollection(arrayList);
    }
}

