/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.log;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.log.InternalLog;
import com.amazonaws.log.InternalLogApi;
import com.amazonaws.log.JulLogFactory;

@ThreadSafe
public abstract class InternalLogFactory {
    private static volatile InternalLogFactory factory = new JulLogFactory();
    private static volatile boolean factoryConfigured;

    public static InternalLogApi getLog(Class<?> clazz) {
        return factoryConfigured ? factory.doGetLog(clazz) : new InternalLog(clazz.getName());
    }

    public static InternalLogApi getLog(String string) {
        return factoryConfigured ? factory.doGetLog(string) : new InternalLog(string);
    }

    protected abstract InternalLogApi doGetLog(Class<?> var1);

    protected abstract InternalLogApi doGetLog(String var1);

    public static InternalLogFactory getFactory() {
        return factory;
    }

    public static synchronized boolean configureFactory(InternalLogFactory internalLogFactory) {
        if (internalLogFactory == null) {
            throw new IllegalArgumentException();
        }
        if (factoryConfigured) {
            return false;
        }
        factory = internalLogFactory;
        factoryConfigured = true;
        return true;
    }
}

