/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.jmespath;

import com.amazonaws.jmespath.InvalidTypeException;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathFunction;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import java.util.Arrays;
import java.util.List;

public class JmesPathLengthFunction
extends JmesPathFunction {
    public JmesPathLengthFunction(JmesPathExpression ... jmesPathExpressionArray) {
        this(Arrays.asList(jmesPathExpressionArray));
    }

    public JmesPathLengthFunction(List<JmesPathExpression> list) {
        super(list);
    }

    @Override
    public JsonNode evaluate(List<JsonNode> list) throws InvalidTypeException {
        JsonNode jsonNode = list.get(0);
        if (jsonNode.isTextual()) {
            return JmesPathLengthFunction.getStringLength(jsonNode);
        }
        if (jsonNode.isArray() || jsonNode.isObject()) {
            return new IntNode(jsonNode.size());
        }
        throw new InvalidTypeException("Type mismatch. Expecting a string or an array or an object.");
    }

    private static IntNode getStringLength(JsonNode jsonNode) {
        return new IntNode(jsonNode.asText().length());
    }
}

