/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.http;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.internal.http.ErrorCodeParser;
import com.amazonaws.protocol.json.JsonContent;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;

@SdkInternalApi
public class JsonErrorCodeParser
implements ErrorCodeParser {
    static final String X_AMZN_ERROR_TYPE = "x-amzn-ErrorType";
    private final String errorCodeFieldName;

    public JsonErrorCodeParser() {
        this(null);
    }

    public JsonErrorCodeParser(String string) {
        this.errorCodeFieldName = string == null ? "__type" : string;
    }

    @Override
    public String parseErrorCode(HttpResponse httpResponse, JsonContent jsonContent) {
        String string = this.parseErrorCodeFromHeader(httpResponse.getHeaders());
        if (string != null) {
            return string;
        }
        if (jsonContent != null) {
            return this.parseErrorCodeFromContents(jsonContent.getJsonNode());
        }
        return null;
    }

    private String parseErrorCodeFromHeader(Map<String, String> map) {
        int n;
        String string = map.get(X_AMZN_ERROR_TYPE);
        if (string != null && (n = string.indexOf(58)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private String parseErrorCodeFromContents(JsonNode jsonNode) {
        if (jsonNode == null || !jsonNode.has(this.errorCodeFieldName)) {
            return null;
        }
        String string = jsonNode.findValue(this.errorCodeFieldName).asText();
        int n = string.lastIndexOf("#");
        return string.substring(n + 1);
    }
}

