/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLInitializationException;

public class SdkSSLContext {
    public static final SSLContext getPreferredSSLContext(SecureRandom secureRandom) {
        return SdkSSLContext.getPreferredSSLContext(null, secureRandom);
    }

    public static final SSLContext getPreferredSSLContext(KeyManager[] keyManagerArray, SecureRandom secureRandom) {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(keyManagerArray, null, secureRandom);
            return sSLContext;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLInitializationException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (KeyManagementException keyManagementException) {
            throw new SSLInitializationException(keyManagementException.getMessage(), keyManagementException);
        }
    }
}

