/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.internal.Releasable;
import com.amazonaws.internal.ResettableInputStream;
import com.amazonaws.internal.SdkFilterInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@NotThreadSafe
public class ReleasableInputStream
extends SdkFilterInputStream
implements Releasable {
    private static final Log log = LogFactory.getLog(ReleasableInputStream.class);
    private boolean closeDisabled;

    protected ReleasableInputStream(InputStream inputStream2) {
        super(inputStream2);
    }

    @Override
    public final void close() {
        if (!this.closeDisabled) {
            this.doRelease();
        }
    }

    @Override
    public final void release() {
        this.doRelease();
    }

    private void doRelease() {
        block3: {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("FYI", exception);
            }
        }
        if (this.in instanceof Releasable) {
            Releasable releasable = (Releasable)((Object)this.in);
            releasable.release();
        }
        this.abortIfNeeded();
    }

    public final boolean isCloseDisabled() {
        return this.closeDisabled;
    }

    public final <T extends ReleasableInputStream> T disableClose() {
        this.closeDisabled = true;
        ReleasableInputStream releasableInputStream = this;
        return (T)releasableInputStream;
    }

    public static ReleasableInputStream wrap(InputStream inputStream2) {
        if (inputStream2 instanceof ReleasableInputStream) {
            return (ReleasableInputStream)inputStream2;
        }
        if (inputStream2 instanceof FileInputStream) {
            return ResettableInputStream.newResettableInputStream((FileInputStream)inputStream2);
        }
        return new ReleasableInputStream(inputStream2);
    }
}

