/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.internal.DelegateInputStream;
import com.amazonaws.util.AWSRequestMetrics;
import java.io.IOException;
import java.io.InputStream;

public class MetricsInputStream
extends DelegateInputStream {
    private AWSRequestMetrics metrics;

    public MetricsInputStream(InputStream inputStream2) {
        super(inputStream2);
    }

    public void setMetrics(AWSRequestMetrics aWSRequestMetrics) {
        this.metrics = aWSRequestMetrics;
    }

    @Override
    public int read() throws IOException {
        if (this.metrics != null) {
            this.metrics.startEvent(AWSRequestMetrics.Field.HttpSocketReadTime);
        }
        try {
            int n = this.in.read();
            return n;
        }
        finally {
            if (this.metrics != null) {
                this.metrics.endEvent(AWSRequestMetrics.Field.HttpSocketReadTime);
            }
        }
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (this.metrics != null) {
            this.metrics.startEvent(AWSRequestMetrics.Field.HttpSocketReadTime);
        }
        try {
            int n = this.in.read(byArray);
            return n;
        }
        finally {
            if (this.metrics != null) {
                this.metrics.endEvent(AWSRequestMetrics.Field.HttpSocketReadTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.metrics != null) {
            this.metrics.startEvent(AWSRequestMetrics.Field.HttpSocketReadTime);
        }
        try {
            int n3 = this.in.read(byArray, n, n2);
            return n3;
        }
        finally {
            if (this.metrics != null) {
                this.metrics.endEvent(AWSRequestMetrics.Field.HttpSocketReadTime);
            }
        }
    }
}

