/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.internal.ServiceEndpointBuilder;
import com.amazonaws.regions.Region;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@NotThreadSafe
public class DefaultServiceEndpointBuilder
extends ServiceEndpointBuilder {
    private static final Log log = LogFactory.getLog(DefaultServiceEndpointBuilder.class);
    private final String serviceName;
    private final String protocol;
    private Region region;

    public DefaultServiceEndpointBuilder(String string, String string2) {
        this.serviceName = string;
        this.protocol = string2;
    }

    @Override
    public DefaultServiceEndpointBuilder withRegion(Region region) {
        if (region == null) {
            throw new IllegalArgumentException("Region cannot be null");
        }
        this.region = region;
        return this;
    }

    @Override
    public URI getServiceEndpoint() {
        String string = this.region.getServiceEndpoint(this.serviceName);
        if (string == null) {
            string = String.format("%s.%s.%s", this.serviceName, this.region.getName(), this.region.getDomain());
            log.info("{" + this.serviceName + ", " + this.region.getName() + "} was not found in region metadata, trying to construct an endpoint using the standard pattern for this region: '" + string + "'.");
        }
        return this.toURI(this.stripProtocol(string));
    }

    private String stripProtocol(String string) {
        int n = string.indexOf("://");
        return n >= 0 ? string.substring(n + "://".length()) : string;
    }

    private URI toURI(String string) throws IllegalArgumentException {
        try {
            return new URI(String.format("%s://%s", this.protocol, string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    @Override
    public Region getRegion() {
        return this.region;
    }
}

