/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.ValidationUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;

@SdkInternalApi
public class ConnectionUtils {
    private static final int DEFAULT_TIMEOUT_MILLIS = 1000;
    private final int timeoutMillis = ValidationUtils.assertIsPositive(ConnectionUtils.readTimeoutMillisConfiguration(), "AWS_METADATA_SERVICE_TIMEOUT");

    @SdkTestInternalApi
    ConnectionUtils() {
    }

    public static ConnectionUtils getInstance() {
        return ConnectionUtilsSingletonHolder.INSTANCE;
    }

    private static int readTimeoutMillisConfiguration() {
        String string = System.getenv("AWS_METADATA_SERVICE_TIMEOUT");
        if (StringUtils.isNullOrEmpty(string)) {
            return 1000;
        }
        try {
            int n = Integer.parseInt(string);
            return n * 1000;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double d = Double.parseDouble(string);
                return ConnectionUtils.toIntExact(Math.round(d * 1000.0));
            }
            catch (NumberFormatException numberFormatException2) {
                throw new IllegalStateException("AWS_METADATA_SERVICE_TIMEOUT environment variable value does not appear to be an integer or a double: " + string);
            }
        }
    }

    private static int toIntExact(long l) {
        if ((long)((int)l) != l) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)l;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public HttpURLConnection connectToEndpoint(URI uRI, Map<String, String> map) throws IOException {
        return this.connectToEndpoint(uRI, map, "GET");
    }

    public HttpURLConnection connectToEndpoint(URI uRI, Map<String, String> map, String string) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRI.toURL().openConnection(Proxy.NO_PROXY);
        httpURLConnection.setConnectTimeout(this.timeoutMillis);
        httpURLConnection.setReadTimeout(this.timeoutMillis);
        httpURLConnection.setRequestMethod(string);
        httpURLConnection.setDoOutput(true);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            httpURLConnection.addRequestProperty(entry.getKey(), entry.getValue());
        }
        httpURLConnection.connect();
        return httpURLConnection;
    }

    private static final class ConnectionUtilsSingletonHolder {
        private static final ConnectionUtils INSTANCE = new ConnectionUtils();

        private ConnectionUtilsSingletonHolder() {
        }
    }
}

