/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.timers;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

@SdkInternalApi
public class TimeoutThreadPoolBuilder {
    public static ScheduledThreadPoolExecutor buildDefaultTimeoutThreadPool(String string) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(5, TimeoutThreadPoolBuilder.getThreadFactory(string));
        TimeoutThreadPoolBuilder.safeSetRemoveOnCancel(scheduledThreadPoolExecutor);
        scheduledThreadPoolExecutor.setKeepAliveTime(5L, TimeUnit.SECONDS);
        scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
        return scheduledThreadPoolExecutor;
    }

    private static ThreadFactory getThreadFactory(final String string) {
        return new ThreadFactory(){
            private int threadCount = 1;

            @Override
            public Thread newThread(Runnable runnable2) {
                Thread thread2 = new Thread(runnable2);
                if (string != null) {
                    thread2.setName(string + "-" + this.threadCount++);
                }
                thread2.setPriority(10);
                return thread2;
            }
        };
    }

    private static void safeSetRemoveOnCancel(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        try {
            scheduledThreadPoolExecutor.getClass().getMethod("setRemoveOnCancelPolicy", Boolean.TYPE).invoke((Object)scheduledThreadPoolExecutor, Boolean.TRUE);
        }
        catch (IllegalAccessException illegalAccessException) {
            TimeoutThreadPoolBuilder.throwSetRemoveOnCancelException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TimeoutThreadPoolBuilder.throwSetRemoveOnCancelException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            TimeoutThreadPoolBuilder.throwSetRemoveOnCancelException(invocationTargetException.getCause());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SdkClientException("The request timeout feature is only available for Java 1.7 and above.");
        }
        catch (SecurityException securityException) {
            throw new SdkClientException("The request timeout feature needs additional permissions to function.", securityException);
        }
    }

    private static void throwSetRemoveOnCancelException(Throwable throwable) {
        throw new SdkClientException("Unable to setRemoveOnCancelPolicy for request timeout thread pool", throwable);
    }
}

