/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.conn.ssl.privileged;

import com.amazonaws.http.conn.ssl.MasterSecretValidators;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrivilegedMasterSecretValidator
implements MasterSecretValidators.MasterSecretValidator {
    private static final Log LOG = LogFactory.getLog(PrivilegedMasterSecretValidator.class);

    @Override
    public boolean isMasterSecretValid(final Socket socket) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return PrivilegedMasterSecretValidator.this.privilegedIsMasterSecretValid(socket);
            }
        });
    }

    private boolean privilegedIsMasterSecretValid(Socket socket) {
        String string;
        SSLSession sSLSession;
        if (socket instanceof SSLSocket && (sSLSession = this.getSslSession(socket)) != null && "sun.security.ssl.SSLSessionImpl".equals(string = sSLSession.getClass().getName())) {
            try {
                Object object = this.getMasterSecret(sSLSession, string);
                if (object == null) {
                    sSLSession.invalidate();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Invalidated session " + sSLSession);
                    }
                    return false;
                }
            }
            catch (Exception exception) {
                this.failedToVerifyMasterSecret(exception);
            }
        }
        return true;
    }

    private SSLSession getSslSession(Socket socket) {
        return ((SSLSocket)socket).getSession();
    }

    private Object getMasterSecret(SSLSession sSLSession, String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        Method method = clazz.getDeclaredMethod("getMasterSecret", new Class[0]);
        method.setAccessible(true);
        return method.invoke((Object)sSLSession, new Object[0]);
    }

    private void failedToVerifyMasterSecret(Throwable throwable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failed to verify the SSL master secret", throwable);
        }
    }
}

