/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.apache.utils;

import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.settings.HttpClientSettings;
import com.amazonaws.util.FakeIOException;
import com.amazonaws.util.ReflectionMethodInvoker;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;

public class ApacheUtils {
    private static final Log log = LogFactory.getLog(ApacheUtils.class);
    private static final ReflectionMethodInvoker<RequestConfig.Builder, RequestConfig.Builder> normalizeUriInvoker = new ReflectionMethodInvoker<RequestConfig.Builder, RequestConfig.Builder>(RequestConfig.Builder.class, RequestConfig.Builder.class, "setNormalizeUri", Boolean.TYPE);
    private final boolean normalizeUriMethodNotFound = false;

    public static boolean isRequestSuccessful(org.apache.http.HttpResponse httpResponse) {
        int n = httpResponse.getStatusLine().getStatusCode();
        return n / 100 == 2;
    }

    public static HttpResponse createResponse(Request<?> request, HttpRequestBase httpRequestBase, org.apache.http.HttpResponse httpResponse, HttpContext httpContext) throws IOException {
        HttpResponse httpResponse2 = new HttpResponse(request, httpRequestBase, httpContext);
        if (httpResponse.getEntity() != null) {
            httpResponse2.setContent(httpResponse.getEntity().getContent());
        }
        httpResponse2.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        httpResponse2.setStatusText(httpResponse.getStatusLine().getReasonPhrase());
        for (Header header : httpResponse.getAllHeaders()) {
            httpResponse2.addHeader(header.getName(), header.getValue());
        }
        return httpResponse2;
    }

    public static HttpEntity newStringEntity(String string) {
        try {
            return new StringEntity(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SdkClientException("Unable to create HTTP entity: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    public static HttpEntity newBufferedHttpEntity(HttpEntity httpEntity) throws FakeIOException {
        try {
            return new BufferedHttpEntity(httpEntity);
        }
        catch (FakeIOException fakeIOException) {
            throw fakeIOException;
        }
        catch (IOException iOException) {
            throw new SdkClientException("Unable to create HTTP entity: " + iOException.getMessage(), iOException);
        }
    }

    public static HttpClientContext newClientContext(HttpClientSettings httpClientSettings, Map<String, ? extends Object> map) {
        HttpClientContext httpClientContext = new HttpClientContext();
        if (map != null && !map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                httpClientContext.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        ApacheUtils.addPreemptiveAuthenticationProxy(httpClientContext, httpClientSettings);
        RequestConfig.Builder builder = RequestConfig.custom();
        ApacheUtils.disableNormalizeUri(builder);
        httpClientContext.setRequestConfig(builder.build());
        httpClientContext.setAttribute("com.amazonaws.disableSocketProxy", httpClientSettings.disableSocketProxy());
        return httpClientContext;
    }

    public static void disableNormalizeUri(RequestConfig.Builder builder) {
        if (normalizeUriInvoker.isInitialized()) {
            try {
                normalizeUriInvoker.invoke(builder, false);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ApacheUtils.noSuchMethodThrownByNormalizeUriInvoker();
            }
        }
    }

    public static CredentialsProvider newProxyCredentialsProvider(HttpClientSettings httpClientSettings) {
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(ApacheUtils.newAuthScope(httpClientSettings), ApacheUtils.newNTCredentials(httpClientSettings));
        return basicCredentialsProvider;
    }

    private static Credentials newNTCredentials(HttpClientSettings httpClientSettings) {
        return new NTCredentials(httpClientSettings.getProxyUsername(), httpClientSettings.getProxyPassword(), httpClientSettings.getProxyWorkstation(), httpClientSettings.getProxyDomain());
    }

    private static AuthScope newAuthScope(HttpClientSettings httpClientSettings) {
        return new AuthScope(httpClientSettings.getProxyHost(), httpClientSettings.getProxyPort());
    }

    private static void addPreemptiveAuthenticationProxy(HttpClientContext httpClientContext, HttpClientSettings httpClientSettings) {
        if (httpClientSettings.isPreemptiveBasicProxyAuth()) {
            HttpHost httpHost = new HttpHost(httpClientSettings.getProxyHost(), httpClientSettings.getProxyPort());
            CredentialsProvider credentialsProvider = ApacheUtils.newProxyCredentialsProvider(httpClientSettings);
            BasicAuthCache basicAuthCache = new BasicAuthCache();
            BasicScheme basicScheme = new BasicScheme();
            basicAuthCache.put(httpHost, basicScheme);
            httpClientContext.setCredentialsProvider(credentialsProvider);
            httpClientContext.setAuthCache(basicAuthCache);
        }
    }

    private static void noSuchMethodThrownByNormalizeUriInvoker() {
        log.warn("NoSuchMethodException was thrown when disabling normalizeUri. This indicates you are using an old version (< 4.5.8) of Apache http client. It is recommended to use http client version >= 4.5.9 to avoid the breaking change introduced in apache client 4.5.7 and the latency in exception handling. See https://github.com/aws/aws-sdk-java/issues/1919 for more information");
    }

    static {
        try {
            normalizeUriInvoker.initialize();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ApacheUtils.noSuchMethodThrownByNormalizeUriInvoker();
        }
    }
}

