/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.apache.client.impl;

import com.amazonaws.util.CRC32ChecksumCalculatingInputStream;
import com.amazonaws.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.protocol.HttpContext;

public class CRC32ChecksumResponseInterceptor
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        HttpEntity httpEntity = httpResponse.getEntity();
        Header[] headerArray = httpResponse.getHeaders("x-amz-crc32");
        if (httpEntity == null || headerArray == null || headerArray.length == 0) {
            return;
        }
        HttpEntityWrapper httpEntityWrapper = new HttpEntityWrapper(httpEntity){
            private final InputStream content;
            {
                this.content = new CRC32ChecksumCalculatingInputStream(this.wrappedEntity.getContent());
            }

            @Override
            public InputStream getContent() throws IOException {
                return this.content;
            }

            @Override
            public void writeTo(OutputStream outputStream2) throws IOException {
                try {
                    IOUtils.copy(this.getContent(), outputStream2);
                }
                finally {
                    this.getContent().close();
                }
            }
        };
        httpResponse.setEntity(httpEntityWrapper);
        httpContext.setAttribute(CRC32ChecksumCalculatingInputStream.class.getName(), httpEntityWrapper.getContent());
    }
}

