/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.apache.client.impl;

import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.http.apache.SdkProxyRoutePlanner;
import com.amazonaws.http.apache.client.impl.ApacheConnectionManagerFactory;
import com.amazonaws.http.apache.client.impl.CRC32ChecksumResponseInterceptor;
import com.amazonaws.http.apache.client.impl.ConnectionManagerAwareHttpClient;
import com.amazonaws.http.apache.client.impl.SdkHttpClient;
import com.amazonaws.http.apache.utils.ApacheUtils;
import com.amazonaws.http.client.ConnectionManagerFactory;
import com.amazonaws.http.client.HttpClientFactory;
import com.amazonaws.http.conn.ClientConnectionManagerFactory;
import com.amazonaws.http.conn.SdkConnectionKeepAliveStrategy;
import com.amazonaws.http.protocol.SdkHttpRequestExecutor;
import com.amazonaws.http.settings.HttpClientSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class ApacheHttpClientFactory
implements HttpClientFactory<ConnectionManagerAwareHttpClient> {
    private static final Log LOG = LogFactory.getLog(AmazonHttpClient.class);
    private final ConnectionManagerFactory<HttpClientConnectionManager> cmFactory = new ApacheConnectionManagerFactory();

    @Override
    public ConnectionManagerAwareHttpClient create(HttpClientSettings httpClientSettings) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        HttpClientConnectionManager httpClientConnectionManager = this.cmFactory.create(httpClientSettings);
        httpClientBuilder.setRequestExecutor(new SdkHttpRequestExecutor()).setKeepAliveStrategy(this.buildKeepAliveStrategy(httpClientSettings)).disableRedirectHandling().disableAutomaticRetries().setConnectionManager(ClientConnectionManagerFactory.wrap(httpClientConnectionManager));
        if (!httpClientSettings.useGzip()) {
            httpClientBuilder.disableContentCompression();
        }
        CRC32ChecksumResponseInterceptor cRC32ChecksumResponseInterceptor = new CRC32ChecksumResponseInterceptor();
        if (httpClientSettings.calculateCRC32FromCompressedData()) {
            httpClientBuilder.addInterceptorFirst(cRC32ChecksumResponseInterceptor);
        } else {
            httpClientBuilder.addInterceptorLast(cRC32ChecksumResponseInterceptor);
        }
        this.addProxyConfig(httpClientBuilder, httpClientSettings);
        SdkHttpClient sdkHttpClient = new SdkHttpClient(httpClientBuilder.build(), httpClientConnectionManager);
        if (httpClientSettings.useReaper()) {
            IdleConnectionReaper.registerConnectionManager(httpClientConnectionManager, httpClientSettings.getMaxIdleConnectionTime());
        }
        return sdkHttpClient;
    }

    private void addProxyConfig(HttpClientBuilder httpClientBuilder, HttpClientSettings httpClientSettings) {
        if (httpClientSettings.isProxyEnabled()) {
            LOG.info("Configuring Proxy. Proxy Host: " + httpClientSettings.getProxyHost() + " Proxy Port: " + httpClientSettings.getProxyPort());
            httpClientBuilder.setRoutePlanner(new SdkProxyRoutePlanner(httpClientSettings.getProxyHost(), httpClientSettings.getProxyPort(), httpClientSettings.getProxyProtocol(), httpClientSettings.getNonProxyHosts()));
            if (httpClientSettings.isAuthenticatedProxy()) {
                httpClientBuilder.setDefaultCredentialsProvider(ApacheUtils.newProxyCredentialsProvider(httpClientSettings));
            }
        }
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy(HttpClientSettings httpClientSettings) {
        return httpClientSettings.getMaxIdleConnectionTime() > 0L ? new SdkConnectionKeepAliveStrategy(httpClientSettings.getMaxIdleConnectionTime()) : null;
    }
}

