/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.http.AbstractFileTlsKeyManagersProvider;
import java.io.File;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SystemPropertyTlsKeyManagersProvider
extends AbstractFileTlsKeyManagersProvider {
    private static final Log log = LogFactory.getLog(SystemPropertyTlsKeyManagersProvider.class);
    private static final String KEY_STORE_PROPERTY = "javax.net.ssl.keyStore";
    private static final String KEY_STORE_PASSWORD_PROPERTY = "javax.net.ssl.keyStorePassword";
    private static final String KEY_STORE_TYPE_PROPERTY = "javax.net.ssl.keyStoreType";

    @Override
    public KeyManager[] getKeyManagers() {
        String string = SystemPropertyTlsKeyManagersProvider.getKeyStore();
        if (string == null) {
            return null;
        }
        String string2 = SystemPropertyTlsKeyManagersProvider.getKeyStoreType();
        String string3 = SystemPropertyTlsKeyManagersProvider.getKeyStorePassword();
        char[] cArray = null;
        if (string3 != null) {
            cArray = string3.toCharArray();
        }
        try {
            return this.createKeyManagers(new File(string), string2, cArray);
        }
        catch (Exception exception) {
            log.warn("Unable to load KeyManager from system properties", exception);
            return null;
        }
    }

    private static String getKeyStore() {
        return System.getProperty(KEY_STORE_PROPERTY);
    }

    private static String getKeyStoreType() {
        return System.getProperty(KEY_STORE_TYPE_PROPERTY, KeyStore.getDefaultType());
    }

    private static String getKeyStorePassword() {
        return System.getProperty(KEY_STORE_PASSWORD_PROPERTY);
    }
}

