/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.http.ErrorCodeParser;
import com.amazonaws.internal.http.JsonErrorMessageParser;
import com.amazonaws.protocol.json.JsonContent;
import com.amazonaws.transform.EnhancedJsonErrorUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.JsonUnmarshallerContextImpl;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class JsonErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log LOG = LogFactory.getLog(JsonErrorResponseHandler.class);
    private final List<JsonErrorUnmarshaller> unmarshallers;
    private final ErrorCodeParser errorCodeParser;
    private final JsonErrorMessageParser errorMessageParser;
    private final JsonFactory jsonFactory;
    private final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> simpleTypeUnmarshallers;
    private final Map<JsonUnmarshallerContext.UnmarshallerType, Unmarshaller<?, JsonUnmarshallerContext>> customTypeUnmarshallers;

    public JsonErrorResponseHandler(List<JsonErrorUnmarshaller> list, ErrorCodeParser errorCodeParser, JsonErrorMessageParser jsonErrorMessageParser, JsonFactory jsonFactory) {
        this.unmarshallers = list;
        this.simpleTypeUnmarshallers = null;
        this.customTypeUnmarshallers = null;
        this.errorCodeParser = errorCodeParser;
        this.errorMessageParser = jsonErrorMessageParser;
        this.jsonFactory = jsonFactory;
    }

    public JsonErrorResponseHandler(List<JsonErrorUnmarshaller> list, Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> map, Map<JsonUnmarshallerContext.UnmarshallerType, Unmarshaller<?, JsonUnmarshallerContext>> map2, ErrorCodeParser errorCodeParser, JsonErrorMessageParser jsonErrorMessageParser, JsonFactory jsonFactory) {
        this.unmarshallers = list;
        this.simpleTypeUnmarshallers = map;
        this.customTypeUnmarshallers = map2;
        this.errorCodeParser = errorCodeParser;
        this.errorMessageParser = jsonErrorMessageParser;
        this.jsonFactory = jsonFactory;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    @Override
    public AmazonServiceException handle(HttpResponse httpResponse) throws Exception {
        JsonContent jsonContent = JsonContent.createJsonContent(httpResponse, this.jsonFactory);
        byte[] byArray = jsonContent.getRawContent();
        String string = this.errorCodeParser.parseErrorCode(httpResponse, jsonContent);
        AmazonServiceException amazonServiceException = this.createException(string, httpResponse, jsonContent.getJsonNode(), byArray);
        if (amazonServiceException.getErrorMessage() == null) {
            amazonServiceException.setErrorMessage(this.errorMessageParser.parseErrorMessage(httpResponse, jsonContent.getJsonNode()));
        }
        amazonServiceException.setErrorCode(string);
        amazonServiceException.setServiceName(httpResponse.getRequest().getServiceName());
        amazonServiceException.setStatusCode(httpResponse.getStatusCode());
        amazonServiceException.setErrorType(this.getErrorTypeFromStatusCode(httpResponse.getStatusCode()));
        amazonServiceException.setRawResponse(byArray);
        String string2 = this.getRequestIdFromHeaders(httpResponse.getHeaders());
        if (string2 != null) {
            amazonServiceException.setRequestId(string2);
        }
        amazonServiceException.setHttpHeaders(httpResponse.getHeaders());
        return amazonServiceException;
    }

    private AmazonServiceException createException(String string, HttpResponse httpResponse, JsonNode jsonNode, byte[] byArray) {
        AmazonServiceException amazonServiceException = this.unmarshallException(string, httpResponse, jsonNode, byArray);
        if (amazonServiceException == null) {
            amazonServiceException = new AmazonServiceException("Unable to unmarshall exception response with the unmarshallers provided");
        }
        return amazonServiceException;
    }

    private AmazonServiceException unmarshallException(String string, HttpResponse httpResponse, JsonNode jsonNode, byte[] byArray) {
        for (JsonErrorUnmarshaller jsonErrorUnmarshaller : this.unmarshallers) {
            if (!jsonErrorUnmarshaller.matchErrorCode(string)) continue;
            try {
                if (jsonErrorUnmarshaller instanceof EnhancedJsonErrorUnmarshaller) {
                    EnhancedJsonErrorUnmarshaller enhancedJsonErrorUnmarshaller = (EnhancedJsonErrorUnmarshaller)jsonErrorUnmarshaller;
                    return this.doEnhancedUnmarshall(enhancedJsonErrorUnmarshaller, string, httpResponse, byArray);
                }
                return this.doLegacyUnmarshall(jsonErrorUnmarshaller, jsonNode);
            }
            catch (Exception exception) {
                LOG.debug("Unable to unmarshall exception content", exception);
                return null;
            }
        }
        return null;
    }

    private AmazonServiceException doEnhancedUnmarshall(EnhancedJsonErrorUnmarshaller enhancedJsonErrorUnmarshaller, String string, HttpResponse httpResponse, byte[] byArray) throws Exception {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        JsonParser jsonParser = this.jsonFactory.createParser(byArray);
        JsonUnmarshallerContextImpl jsonUnmarshallerContextImpl = new JsonUnmarshallerContextImpl(jsonParser, this.simpleTypeUnmarshallers, this.customTypeUnmarshallers, httpResponse);
        try {
            return enhancedJsonErrorUnmarshaller.unmarshallFromContext(jsonUnmarshallerContextImpl);
        }
        catch (JsonParseException jsonParseException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Received response with error code '%s', but response body did not contain valid JSON. Treating it as an empty object.", string), jsonParseException);
            }
            JsonParser jsonParser2 = this.jsonFactory.createParser("{}");
            jsonUnmarshallerContextImpl = new JsonUnmarshallerContextImpl(jsonParser2, this.simpleTypeUnmarshallers, this.customTypeUnmarshallers, httpResponse);
            return enhancedJsonErrorUnmarshaller.unmarshallFromContext(jsonUnmarshallerContextImpl);
        }
    }

    private AmazonServiceException doLegacyUnmarshall(JsonErrorUnmarshaller jsonErrorUnmarshaller, JsonNode jsonNode) throws Exception {
        return jsonErrorUnmarshaller.unmarshall(jsonNode);
    }

    private AmazonServiceException.ErrorType getErrorTypeFromStatusCode(int n) {
        return n < 500 ? AmazonServiceException.ErrorType.Client : AmazonServiceException.ErrorType.Service;
    }

    private String getRequestIdFromHeaders(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("x-amzn-RequestId")) {
                return entry.getValue();
            }
            if (!entry.getKey().equalsIgnoreCase("x-amz-request-id")) continue;
            return entry.getValue();
        }
        return null;
    }
}

