/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.Request;
import com.amazonaws.util.CRC32ChecksumCalculatingInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.protocol.HttpContext;

public class HttpResponse {
    private final Request<?> request;
    private final HttpRequestBase httpRequest;
    private String statusText;
    private int statusCode;
    private InputStream content;
    private Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, List<String>> allHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private HttpContext context;

    public HttpResponse(Request<?> request, HttpRequestBase httpRequestBase) {
        this(request, httpRequestBase, null);
    }

    public HttpResponse(Request<?> request, HttpRequestBase httpRequestBase, HttpContext httpContext) {
        this.request = request;
        this.httpRequest = httpRequestBase;
        this.context = httpContext;
    }

    public Request<?> getRequest() {
        return this.request;
    }

    public HttpRequestBase getHttpRequest() {
        return this.httpRequest;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, List<String>> getAllHeaders() {
        return this.allHeaders;
    }

    public List<String> getHeaderValues(String string) {
        return this.allHeaders.get(string);
    }

    public String getHeader(String string) {
        return this.headers.get(string);
    }

    public void addHeader(String string, String string2) {
        this.headers.put(string, string2);
        List<String> list = this.allHeaders.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.allHeaders.put(string, list);
        }
        list.add(string2);
    }

    public void setContent(InputStream inputStream2) {
        this.content = inputStream2;
    }

    public InputStream getContent() {
        return this.content;
    }

    public void setStatusText(String string) {
        this.statusText = string;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public long getCRC32Checksum() {
        if (this.context == null) {
            return 0L;
        }
        CRC32ChecksumCalculatingInputStream cRC32ChecksumCalculatingInputStream = (CRC32ChecksumCalculatingInputStream)this.context.getAttribute(CRC32ChecksumCalculatingInputStream.class.getName());
        return cRC32ChecksumCalculatingInputStream == null ? 0L : cRC32ChecksumCalculatingInputStream.getCRC32Checksum();
    }
}

