/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.Signer;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.timers.client.ClientExecutionAbortTrackerTask;
import com.amazonaws.http.timers.client.NoOpClientExecutionAbortTrackerTask;
import com.amazonaws.internal.auth.NoOpSignerProvider;
import com.amazonaws.internal.auth.SignerProvider;
import com.amazonaws.internal.auth.SignerProviderContext;
import com.amazonaws.retry.internal.AuthErrorRetryStrategy;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.AWSRequestMetricsFullSupport;
import java.net.URI;
import java.util.List;

@NotThreadSafe
public class ExecutionContext {
    private final AWSRequestMetrics awsRequestMetrics;
    private final List<RequestHandler2> requestHandler2s;
    private final AmazonWebServiceClient awsClient;
    private final SignerProvider signerProvider;
    private boolean retryCapacityConsumed;
    private AWSCredentialsProvider credentialsProvider;
    private AuthErrorRetryStrategy authErrorRetryStrategy;
    private ClientExecutionAbortTrackerTask clientExecutionTrackerTask = NoOpClientExecutionAbortTrackerTask.INSTANCE;

    public ExecutionContext(boolean bl) {
        this(ExecutionContext.builder().withUseRequestMetrics(bl).withSignerProvider(new NoOpSignerProvider()));
    }

    public ExecutionContext() {
        this(ExecutionContext.builder().withSignerProvider(new NoOpSignerProvider()));
    }

    @Deprecated
    public ExecutionContext(List<RequestHandler2> list, boolean bl, AmazonWebServiceClient amazonWebServiceClient) {
        this.requestHandler2s = list;
        this.awsRequestMetrics = bl ? new AWSRequestMetricsFullSupport() : new AWSRequestMetrics();
        this.awsClient = amazonWebServiceClient;
        this.signerProvider = new SignerProvider(){

            @Override
            public Signer getSigner(SignerProviderContext signerProviderContext) {
                return ExecutionContext.this.getSignerByURI(signerProviderContext.getUri());
            }
        };
    }

    private ExecutionContext(Builder builder) {
        this.requestHandler2s = builder.requestHandler2s;
        this.awsRequestMetrics = builder.useRequestMetrics ? new AWSRequestMetricsFullSupport() : new AWSRequestMetrics();
        this.awsClient = builder.awsClient;
        this.signerProvider = builder.signerProvider;
    }

    public List<RequestHandler2> getRequestHandler2s() {
        return this.requestHandler2s;
    }

    public AWSRequestMetrics getAwsRequestMetrics() {
        return this.awsRequestMetrics;
    }

    protected AmazonWebServiceClient getAwsClient() {
        return this.awsClient;
    }

    @Deprecated
    public void setSigner(Signer signer) {
    }

    public boolean retryCapacityConsumed() {
        return this.retryCapacityConsumed;
    }

    public void markRetryCapacityConsumed() {
        this.retryCapacityConsumed = true;
    }

    public Signer getSigner(SignerProviderContext signerProviderContext) {
        return this.signerProvider.getSigner(signerProviderContext);
    }

    @Deprecated
    public Signer getSignerByURI(URI uRI) {
        return this.awsClient == null ? null : this.awsClient.getSignerByURI(uRI);
    }

    public void setCredentialsProvider(AWSCredentialsProvider aWSCredentialsProvider) {
        this.credentialsProvider = aWSCredentialsProvider;
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public AuthErrorRetryStrategy getAuthErrorRetryStrategy() {
        return this.authErrorRetryStrategy;
    }

    public void setAuthErrorRetryStrategy(AuthErrorRetryStrategy authErrorRetryStrategy) {
        this.authErrorRetryStrategy = authErrorRetryStrategy;
    }

    public ClientExecutionAbortTrackerTask getClientExecutionTrackerTask() {
        return this.clientExecutionTrackerTask;
    }

    public void setClientExecutionTrackerTask(ClientExecutionAbortTrackerTask clientExecutionAbortTrackerTask) {
        this.clientExecutionTrackerTask = clientExecutionAbortTrackerTask;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean useRequestMetrics;
        private List<RequestHandler2> requestHandler2s;
        private AmazonWebServiceClient awsClient;
        private SignerProvider signerProvider = new NoOpSignerProvider();

        private Builder() {
        }

        public boolean useRequestMetrics() {
            return this.useRequestMetrics;
        }

        public void setUseRequestMetrics(boolean bl) {
            this.useRequestMetrics = bl;
        }

        public Builder withUseRequestMetrics(boolean bl) {
            this.setUseRequestMetrics(bl);
            return this;
        }

        public List<RequestHandler2> getRequestHandler2s() {
            return this.requestHandler2s;
        }

        public void setRequestHandler2s(List<RequestHandler2> list) {
            this.requestHandler2s = list;
        }

        public Builder withRequestHandler2s(List<RequestHandler2> list) {
            this.setRequestHandler2s(list);
            return this;
        }

        public AmazonWebServiceClient getAwsClient() {
            return this.awsClient;
        }

        public void setAwsClient(AmazonWebServiceClient amazonWebServiceClient) {
            this.awsClient = amazonWebServiceClient;
        }

        public Builder withAwsClient(AmazonWebServiceClient amazonWebServiceClient) {
            this.setAwsClient(amazonWebServiceClient);
            return this;
        }

        public SignerProvider getSignerProvider() {
            return this.signerProvider;
        }

        public void setSignerProvider(SignerProvider signerProvider) {
            this.signerProvider = signerProvider;
        }

        public Builder withSignerProvider(SignerProvider signerProvider) {
            this.setSignerProvider(signerProvider);
            return this;
        }

        public ExecutionContext build() {
            return new ExecutionContext(this);
        }
    }
}

