/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.endpointdiscovery;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.cache.CacheLoader;
import com.amazonaws.endpointdiscovery.DaemonThreadFactory;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public abstract class EndpointDiscoveryRefreshCache<K> {
    private static final Log log = LogFactory.getLog(EndpointDiscoveryRefreshCache.class);
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(DaemonThreadFactory.INSTANCE);
    private final CacheLoader<String, Map<String, String>> cacheLoader;
    protected final Map<String, URI> cache = new ConcurrentHashMap<String, URI>();

    public EndpointDiscoveryRefreshCache(CacheLoader cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public abstract URI get(K var1, boolean var2, URI var3);

    public abstract URI put(String var1, Map<String, String> var2, URI var3);

    public void evict(String string) {
        this.cache.remove(string);
    }

    public URI discoverEndpoint(String string, boolean bl, URI uRI) {
        if (bl) {
            try {
                return this.put(string, this.cacheLoader.load(string), uRI);
            }
            catch (Exception exception) {
                return uRI;
            }
        }
        this.loadAndScheduleRefresh(string, 1L, uRI);
        return uRI;
    }

    public ScheduledFuture<URI> loadAndScheduleRefresh(final String string, long l, final URI uRI) {
        return this.executorService.schedule(new Callable<URI>(){

            @Override
            public URI call() {
                try {
                    return EndpointDiscoveryRefreshCache.this.put(string, (Map)EndpointDiscoveryRefreshCache.this.cacheLoader.load(string), uRI);
                }
                catch (Exception exception) {
                    log.debug("Failed to refresh cached endpoint. Scheduling another refresh in 5 minutes");
                    EndpointDiscoveryRefreshCache.this.loadAndScheduleRefresh(string, 5L, uRI);
                    return null;
                }
            }
        }, l, TimeUnit.MINUTES);
    }

    public ScheduledFuture<?> loadAndScheduleEvict(final String string, long l, TimeUnit timeUnit) {
        return this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                EndpointDiscoveryRefreshCache.this.evict(string);
            }
        }, l, timeUnit);
    }

    public void shutdown() {
        this.executorService.shutdownNow();
    }
}

