/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.client.builder;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.monitoring.CsmConfigurationProvider;
import com.amazonaws.monitoring.DefaultCsmConfigurationProviderChain;
import com.amazonaws.monitoring.MonitoringListener;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;

@NotThreadSafe
@SdkProtectedApi
public abstract class AwsClientBuilder<Subclass extends AwsClientBuilder, TypeToBuild> {
    private static final AwsRegionProvider DEFAULT_REGION_PROVIDER = new DefaultAwsRegionProviderChain();
    private final ClientConfigurationFactory clientConfigFactory;
    private final AwsRegionProvider regionProvider;
    private final AdvancedConfig.Builder advancedConfig = AdvancedConfig.builder();
    private AWSCredentialsProvider credentials;
    private ClientConfiguration clientConfig;
    private RequestMetricCollector metricsCollector;
    private Region region;
    private List<RequestHandler2> requestHandlers;
    private EndpointConfiguration endpointConfiguration;
    private CsmConfigurationProvider csmConfig;
    private MonitoringListener monitoringListener;

    protected AwsClientBuilder(ClientConfigurationFactory clientConfigurationFactory) {
        this(clientConfigurationFactory, DEFAULT_REGION_PROVIDER);
    }

    @SdkTestInternalApi
    protected AwsClientBuilder(ClientConfigurationFactory clientConfigurationFactory, AwsRegionProvider awsRegionProvider) {
        this.clientConfigFactory = clientConfigurationFactory;
        this.regionProvider = awsRegionProvider;
    }

    public final AWSCredentialsProvider getCredentials() {
        return this.credentials;
    }

    public final void setCredentials(AWSCredentialsProvider aWSCredentialsProvider) {
        this.credentials = aWSCredentialsProvider;
    }

    public final Subclass withCredentials(AWSCredentialsProvider aWSCredentialsProvider) {
        this.setCredentials(aWSCredentialsProvider);
        return this.getSubclass();
    }

    private AWSCredentialsProvider resolveCredentials() {
        return this.credentials == null ? DefaultAWSCredentialsProviderChain.getInstance() : this.credentials;
    }

    public final ClientConfiguration getClientConfiguration() {
        return this.clientConfig;
    }

    public final void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfig = clientConfiguration;
    }

    public final Subclass withClientConfiguration(ClientConfiguration clientConfiguration) {
        this.setClientConfiguration(clientConfiguration);
        return this.getSubclass();
    }

    private ClientConfiguration resolveClientConfiguration() {
        return this.clientConfig == null ? this.clientConfigFactory.getConfig() : new ClientConfiguration(this.clientConfig);
    }

    public final RequestMetricCollector getMetricsCollector() {
        return this.metricsCollector;
    }

    public final void setMetricsCollector(RequestMetricCollector requestMetricCollector) {
        this.metricsCollector = requestMetricCollector;
    }

    public final Subclass withMetricsCollector(RequestMetricCollector requestMetricCollector) {
        this.setMetricsCollector(requestMetricCollector);
        return this.getSubclass();
    }

    public final String getRegion() {
        return this.region == null ? null : this.region.getName();
    }

    public final void setRegion(String string) {
        this.withRegion(string);
    }

    public final Subclass withRegion(Regions regions) {
        return this.withRegion(regions.getName());
    }

    public final Subclass withRegion(String string) {
        return this.withRegion(this.getRegionObject(string));
    }

    private Region getRegionObject(String string) {
        Region region = RegionUtils.getRegion(string);
        if (region == null) {
            throw new SdkClientException(String.format("Could not find region information for '%s' in SDK metadata.", string));
        }
        return region;
    }

    private Subclass withRegion(Region region) {
        this.region = region;
        return this.getSubclass();
    }

    public final EndpointConfiguration getEndpoint() {
        return this.endpointConfiguration;
    }

    public final void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.withEndpointConfiguration(endpointConfiguration);
    }

    public final Subclass withEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
        return this.getSubclass();
    }

    public final List<RequestHandler2> getRequestHandlers() {
        return this.requestHandlers == null ? null : Collections.unmodifiableList(this.requestHandlers);
    }

    public final void setRequestHandlers(RequestHandler2 ... requestHandler2Array) {
        this.requestHandlers = Arrays.asList(requestHandler2Array);
    }

    public final Subclass withRequestHandlers(RequestHandler2 ... requestHandler2Array) {
        this.setRequestHandlers(requestHandler2Array);
        return this.getSubclass();
    }

    public final MonitoringListener getMonitoringListener() {
        return this.monitoringListener;
    }

    public final void setMonitoringListener(MonitoringListener monitoringListener) {
        this.monitoringListener = monitoringListener;
    }

    public final Subclass withMonitoringListener(MonitoringListener monitoringListener) {
        this.setMonitoringListener(monitoringListener);
        return this.getSubclass();
    }

    private List<RequestHandler2> resolveRequestHandlers() {
        return this.requestHandlers == null ? new ArrayList<RequestHandler2>() : new ArrayList<RequestHandler2>(this.requestHandlers);
    }

    public CsmConfigurationProvider getClientSideMonitoringConfigurationProvider() {
        return this.csmConfig;
    }

    public void setClientSideMonitoringConfigurationProvider(CsmConfigurationProvider csmConfigurationProvider) {
        this.csmConfig = csmConfigurationProvider;
    }

    public Subclass withClientSideMonitoringConfigurationProvider(CsmConfigurationProvider csmConfigurationProvider) {
        this.setClientSideMonitoringConfigurationProvider(csmConfigurationProvider);
        return this.getSubclass();
    }

    private CsmConfigurationProvider resolveClientSideMonitoringConfig() {
        return this.csmConfig == null ? DefaultCsmConfigurationProviderChain.getInstance() : this.csmConfig;
    }

    protected final <T> T getAdvancedConfig(AdvancedConfig.Key<T> key) {
        return this.advancedConfig.get(key);
    }

    protected final <T> void putAdvancedConfig(AdvancedConfig.Key<T> key, T t2) {
        this.advancedConfig.put(key, t2);
    }

    @SdkInternalApi
    final TypeToBuild configureMutableProperties(TypeToBuild TypeToBuild) {
        AmazonWebServiceClient amazonWebServiceClient = (AmazonWebServiceClient)TypeToBuild;
        this.setRegion(amazonWebServiceClient);
        amazonWebServiceClient.makeImmutable();
        return TypeToBuild;
    }

    public abstract TypeToBuild build();

    protected final AwsSyncClientParams getSyncClientParams() {
        return new SyncBuilderParams();
    }

    protected final AdvancedConfig getAdvancedConfig() {
        return this.advancedConfig.build();
    }

    private void setRegion(AmazonWebServiceClient amazonWebServiceClient) {
        if (this.region != null && this.endpointConfiguration != null) {
            throw new IllegalStateException("Only one of Region or EndpointConfiguration may be set.");
        }
        if (this.endpointConfiguration != null) {
            amazonWebServiceClient.setEndpoint(this.endpointConfiguration.getServiceEndpoint());
            amazonWebServiceClient.setSignerRegionOverride(this.endpointConfiguration.getSigningRegion());
        } else if (this.region != null) {
            amazonWebServiceClient.setRegion(this.region);
        } else {
            String string = this.determineRegionFromRegionProvider();
            if (string != null) {
                amazonWebServiceClient.setRegion(this.getRegionObject(string));
            } else {
                throw new SdkClientException("Unable to find a region via the region provider chain. Must provide an explicit region in the builder or setup environment to supply a region.");
            }
        }
    }

    private String determineRegionFromRegionProvider() {
        try {
            return this.regionProvider.getRegion();
        }
        catch (SdkClientException sdkClientException) {
            return null;
        }
    }

    protected final Subclass getSubclass() {
        return (Subclass)this;
    }

    public static final class EndpointConfiguration {
        private final String serviceEndpoint;
        private final String signingRegion;

        public EndpointConfiguration(String string, String string2) {
            this.serviceEndpoint = string;
            this.signingRegion = string2;
        }

        public String getServiceEndpoint() {
            return this.serviceEndpoint;
        }

        public String getSigningRegion() {
            return this.signingRegion;
        }
    }

    protected class SyncBuilderParams
    extends AwsAsyncClientParams {
        private final ClientConfiguration _clientConfig;
        private final AWSCredentialsProvider _credentials;
        private final RequestMetricCollector _metricsCollector;
        private final List<RequestHandler2> _requestHandlers;
        private final CsmConfigurationProvider _csmConfig;
        private final MonitoringListener _monitoringListener;
        private final AdvancedConfig _advancedConfig;

        protected SyncBuilderParams() {
            this._clientConfig = AwsClientBuilder.this.resolveClientConfiguration();
            this._credentials = AwsClientBuilder.this.resolveCredentials();
            this._metricsCollector = AwsClientBuilder.this.metricsCollector;
            this._requestHandlers = AwsClientBuilder.this.resolveRequestHandlers();
            this._csmConfig = AwsClientBuilder.this.resolveClientSideMonitoringConfig();
            this._monitoringListener = AwsClientBuilder.this.monitoringListener;
            this._advancedConfig = AwsClientBuilder.this.advancedConfig.build();
        }

        @Override
        public AWSCredentialsProvider getCredentialsProvider() {
            return this._credentials;
        }

        @Override
        public ClientConfiguration getClientConfiguration() {
            return this._clientConfig;
        }

        @Override
        public RequestMetricCollector getRequestMetricCollector() {
            return this._metricsCollector;
        }

        @Override
        public List<RequestHandler2> getRequestHandlers() {
            return this._requestHandlers;
        }

        @Override
        public CsmConfigurationProvider getClientSideMonitoringConfigurationProvider() {
            return this._csmConfig;
        }

        @Override
        public MonitoringListener getMonitoringListener() {
            return this._monitoringListener;
        }

        @Override
        public AdvancedConfig getAdvancedConfig() {
            return this._advancedConfig;
        }

        @Override
        public ExecutorService getExecutor() {
            throw new UnsupportedOperationException("ExecutorService is not used for sync client.");
        }
    }
}

