/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile.internal.securitytoken;

import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.internal.StaticCredentialsProvider;

@SdkProtectedApi
public class RoleInfo
implements Cloneable {
    private String roleArn;
    private String roleSessionName;
    private String externalId;
    private String webIdentityTokenFilePath;
    private AWSCredentialsProvider longLivedCredentialsProvider;

    public void setRoleArn(String string) {
        this.roleArn = string;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public RoleInfo withRoleArn(String string) {
        this.setRoleArn(string);
        return this;
    }

    public void setRoleSessionName(String string) {
        this.roleSessionName = string;
    }

    public String getRoleSessionName() {
        return this.roleSessionName;
    }

    public RoleInfo withRoleSessionName(String string) {
        this.setRoleSessionName(string);
        return this;
    }

    public void setExternalId(String string) {
        this.externalId = string;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public RoleInfo withExternalId(String string) {
        this.setExternalId(string);
        return this;
    }

    public void setWebIdentityTokenFilePath(String string) {
        this.webIdentityTokenFilePath = string;
    }

    public String getWebIdentityTokenFilePath() {
        return this.webIdentityTokenFilePath;
    }

    public RoleInfo withWebIdentityTokenFilePath(String string) {
        this.setWebIdentityTokenFilePath(string);
        return this;
    }

    public void setLongLivedCredentialsProvider(AWSCredentialsProvider aWSCredentialsProvider) {
        this.longLivedCredentialsProvider = aWSCredentialsProvider;
    }

    public AWSCredentialsProvider getLongLivedCredentialsProvider() {
        return this.longLivedCredentialsProvider;
    }

    public RoleInfo withLongLivedCredentialsProvider(AWSCredentialsProvider aWSCredentialsProvider) {
        this.setLongLivedCredentialsProvider(aWSCredentialsProvider);
        return this;
    }

    public RoleInfo withLongLivedCredentials(AWSCredentials aWSCredentials) {
        this.setLongLivedCredentialsProvider(new StaticCredentialsProvider(aWSCredentials));
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getRoleArn() != null) {
            stringBuilder.append("RoleArn: " + this.getRoleArn() + ",");
        }
        if (this.getRoleSessionName() != null) {
            stringBuilder.append("RoleSessionName: " + this.getRoleSessionName() + ",");
        }
        if (this.getExternalId() != null) {
            stringBuilder.append("ExternalId: " + this.getExternalId() + ",");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof RoleInfo)) {
            return false;
        }
        RoleInfo roleInfo = (RoleInfo)object;
        if (roleInfo.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (roleInfo.getRoleArn() != null && !roleInfo.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (roleInfo.getRoleSessionName() == null ^ this.getRoleSessionName() == null) {
            return false;
        }
        if (roleInfo.getRoleSessionName() != null && !roleInfo.getRoleSessionName().equals(this.getRoleSessionName())) {
            return false;
        }
        if (roleInfo.getExternalId() == null ^ this.getExternalId() == null) {
            return false;
        }
        if (roleInfo.getExternalId() != null && !roleInfo.getExternalId().equals(this.getExternalId())) {
            return false;
        }
        return roleInfo.getLongLivedCredentialsProvider() == this.getLongLivedCredentialsProvider();
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        n2 = 31 * n2 + (this.getRoleSessionName() == null ? 0 : this.getRoleSessionName().hashCode());
        n2 = 31 * n2 + (this.getExternalId() == null ? 0 : this.getExternalId().hashCode());
        n2 = 31 * n2 + (this.getLongLivedCredentialsProvider() == null ? 0 : this.getLongLivedCredentialsProvider().hashCode());
        return n2;
    }

    public RoleInfo clone() {
        try {
            return (RoleInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

