/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile.internal;

import com.amazonaws.annotation.Immutable;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.profile.internal.securitytoken.RoleInfo;
import com.amazonaws.internal.StaticCredentialsProvider;
import java.util.LinkedHashMap;
import java.util.Map;

@Deprecated
@Immutable
public class Profile {
    private final String profileName;
    private final Map<String, String> properties;
    private final AWSCredentialsProvider awsCredentials;

    public Profile(String string, AWSCredentials aWSCredentials) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("aws_access_key_id", aWSCredentials.getAWSAccessKeyId());
        linkedHashMap.put("aws_secret_access_key", aWSCredentials.getAWSSecretKey());
        if (aWSCredentials instanceof AWSSessionCredentials) {
            AWSSessionCredentials aWSSessionCredentials = (AWSSessionCredentials)aWSCredentials;
            linkedHashMap.put("aws_session_token", aWSSessionCredentials.getSessionToken());
        }
        this.profileName = string;
        this.properties = linkedHashMap;
        this.awsCredentials = new StaticCredentialsProvider(aWSCredentials);
    }

    public Profile(String string, String string2, AWSCredentialsProvider aWSCredentialsProvider, RoleInfo roleInfo) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("source_profile", string2);
        linkedHashMap.put("role_arn", roleInfo.getRoleArn());
        if (roleInfo.getRoleSessionName() != null) {
            linkedHashMap.put("role_session_name", roleInfo.getRoleSessionName());
        }
        if (roleInfo.getExternalId() != null) {
            linkedHashMap.put("external_id", roleInfo.getExternalId());
        }
        this.profileName = string;
        this.properties = linkedHashMap;
        this.awsCredentials = aWSCredentialsProvider;
    }

    public Profile(String string, Map<String, String> map, AWSCredentialsProvider aWSCredentialsProvider) {
        this.profileName = string;
        this.properties = map;
        this.awsCredentials = aWSCredentialsProvider;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public AWSCredentials getCredentials() {
        return this.awsCredentials.getCredentials();
    }

    public Map<String, String> getProperties() {
        return new LinkedHashMap<String, String>(this.properties);
    }

    public String getPropertyValue(String string) {
        return this.getProperties().get(string);
    }
}

