/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.profile.internal.AllProfiles;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.auth.profile.internal.BasicProfileConfigLoader;
import com.amazonaws.auth.profile.internal.Profile;
import com.amazonaws.auth.profile.internal.ProfileAssumeRoleCredentialsProvider;
import com.amazonaws.auth.profile.internal.ProfileProcessCredentialsProvider;
import com.amazonaws.auth.profile.internal.ProfileStaticCredentialsProvider;
import com.amazonaws.auth.profile.internal.securitytoken.ProfileCredentialsService;
import com.amazonaws.auth.profile.internal.securitytoken.STSProfileCredentialsServiceLoader;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.profile.path.AwsProfileFileLocationProvider;
import com.amazonaws.util.ValidationUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProfilesConfigFile {
    @Deprecated
    public static final String AWS_PROFILE_ENVIRONMENT_VARIABLE = "AWS_PROFILE";
    @Deprecated
    public static final String AWS_PROFILE_SYSTEM_PROPERTY = "aws.profile";
    @Deprecated
    public static final String DEFAULT_PROFILE_NAME = "default";
    private final File profileFile;
    private final ProfileCredentialsService profileCredentialsService;
    private final ConcurrentHashMap<String, AWSCredentialsProvider> credentialProviderCache = new ConcurrentHashMap();
    private volatile AllProfiles allProfiles;
    private volatile long profileFileLastModified;

    public ProfilesConfigFile() throws SdkClientException {
        this(ProfilesConfigFile.getCredentialProfilesFile());
    }

    public ProfilesConfigFile(String string) {
        this(new File(ProfilesConfigFile.validateFilePath(string)));
    }

    public ProfilesConfigFile(String string, ProfileCredentialsService profileCredentialsService) throws SdkClientException {
        this(new File(ProfilesConfigFile.validateFilePath(string)), profileCredentialsService);
    }

    private static String validateFilePath(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Unable to load AWS profiles: specified file path is null.");
        }
        return string;
    }

    public ProfilesConfigFile(File file) throws SdkClientException {
        this(file, (ProfileCredentialsService)STSProfileCredentialsServiceLoader.getInstance());
    }

    public ProfilesConfigFile(File file, ProfileCredentialsService profileCredentialsService) throws SdkClientException {
        this.profileFile = ValidationUtils.assertNotNull(file, "profile file");
        this.profileCredentialsService = profileCredentialsService;
        this.profileFileLastModified = file.lastModified();
        this.allProfiles = ProfilesConfigFile.loadProfiles(this.profileFile);
    }

    public AWSCredentials getCredentials(String string) {
        AWSCredentialsProvider aWSCredentialsProvider = this.credentialProviderCache.get(string);
        if (aWSCredentialsProvider != null) {
            return aWSCredentialsProvider.getCredentials();
        }
        BasicProfile basicProfile = this.allProfiles.getProfile(string);
        if (basicProfile == null) {
            throw new IllegalArgumentException("No AWS profile named '" + string + "'");
        }
        AWSCredentialsProvider aWSCredentialsProvider2 = this.fromProfile(basicProfile);
        this.credentialProviderCache.put(string, aWSCredentialsProvider2);
        return aWSCredentialsProvider2.getCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.profileFile.lastModified() > this.profileFileLastModified) {
            ProfilesConfigFile profilesConfigFile = this;
            synchronized (profilesConfigFile) {
                if (this.profileFile.lastModified() > this.profileFileLastModified) {
                    this.allProfiles = ProfilesConfigFile.loadProfiles(this.profileFile);
                    this.profileFileLastModified = this.profileFile.lastModified();
                }
            }
        }
        this.credentialProviderCache.clear();
    }

    public BasicProfile getBasicProfile(String string) {
        return this.allProfiles.getProfile(string);
    }

    public Map<String, BasicProfile> getAllBasicProfiles() {
        return this.allProfiles.getProfiles();
    }

    @Deprecated
    public Map<String, Profile> getAllProfiles() {
        HashMap<String, Profile> hashMap = new HashMap<String, Profile>();
        for (Map.Entry<String, BasicProfile> entry : this.getAllBasicProfiles().entrySet()) {
            String string = entry.getKey();
            hashMap.put(string, new Profile(string, entry.getValue().getProperties(), new StaticCredentialsProvider(this.getCredentials(string))));
        }
        return hashMap;
    }

    private static File getCredentialProfilesFile() {
        return AwsProfileFileLocationProvider.DEFAULT_CREDENTIALS_LOCATION_PROVIDER.getLocation();
    }

    private static AllProfiles loadProfiles(File file) {
        return BasicProfileConfigLoader.INSTANCE.loadProfiles(file);
    }

    private AWSCredentialsProvider fromProfile(BasicProfile basicProfile) {
        if (basicProfile.isRoleBasedProfile()) {
            return new ProfileAssumeRoleCredentialsProvider(this.profileCredentialsService, this.allProfiles, basicProfile);
        }
        if (basicProfile.isProcessBasedProfile()) {
            return new ProfileProcessCredentialsProvider(basicProfile);
        }
        return new ProfileStaticCredentialsProvider(basicProfile);
    }
}

