/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.policy;

import com.amazonaws.auth.policy.PolicyReaderOptions;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.auth.policy.internal.JsonPolicyReader;
import com.amazonaws.auth.policy.internal.JsonPolicyWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class Policy {
    private static final String DEFAULT_POLICY_VERSION = "2012-10-17";
    private String id;
    private String version = "2012-10-17";
    private List<Statement> statements = new ArrayList<Statement>();

    public Policy() {
    }

    public Policy(String string) {
        this.id = string;
    }

    public Policy(String string, Collection<Statement> collection) {
        this(string);
        this.setStatements(collection);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public Policy withId(String string) {
        this.setId(string);
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Collection<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(Collection<Statement> collection) {
        this.statements = new ArrayList<Statement>(collection);
        this.assignUniqueStatementIds();
    }

    public Policy withStatements(Statement ... statementArray) {
        this.setStatements(Arrays.asList(statementArray));
        return this;
    }

    public String toJson() {
        return new JsonPolicyWriter().writePolicyToString(this);
    }

    public static Policy fromJson(String string) {
        return Policy.fromJson(string, new PolicyReaderOptions());
    }

    public static Policy fromJson(String string, PolicyReaderOptions policyReaderOptions) {
        return new JsonPolicyReader(policyReaderOptions).createPolicyFromJsonString(string);
    }

    private void assignUniqueStatementIds() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Statement object : this.statements) {
            if (object.getId() == null) continue;
            hashSet.add(object.getId());
        }
        int n = 0;
        for (Statement statement : this.statements) {
            if (statement.getId() != null) continue;
            while (hashSet.contains(Integer.toString(++n))) {
            }
            statement.setId(Integer.toString(n));
        }
    }
}

