/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.profile.internal.securitytoken.RoleInfo;
import com.amazonaws.auth.profile.internal.securitytoken.STSProfileCredentialsServiceLoader;

public class WebIdentityTokenCredentialsProvider
implements AWSCredentialsProvider {
    private final AWSCredentialsProvider credentialsProvider;
    private final RuntimeException loadException;

    public WebIdentityTokenCredentialsProvider() {
        this(new BuilderImpl());
    }

    private WebIdentityTokenCredentialsProvider(BuilderImpl builderImpl) {
        AWSCredentialsProvider aWSCredentialsProvider = null;
        RuntimeException runtimeException = null;
        try {
            String string;
            String string2 = builderImpl.webIdentityTokenFile != null ? builderImpl.webIdentityTokenFile : System.getenv("AWS_WEB_IDENTITY_TOKEN_FILE");
            String string3 = builderImpl.roleArn != null ? builderImpl.roleArn : System.getenv("AWS_ROLE_ARN");
            String string4 = string = builderImpl.roleSessionName != null ? builderImpl.roleSessionName : System.getenv("AWS_ROLE_SESSION_NAME");
            if (string == null) {
                string = "aws-sdk-java-" + System.currentTimeMillis();
            }
            RoleInfo roleInfo = new RoleInfo().withRoleArn(string3).withRoleSessionName(string).withWebIdentityTokenFilePath(string2);
            aWSCredentialsProvider = STSProfileCredentialsServiceLoader.getInstance().getAssumeRoleCredentialsProvider(roleInfo);
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
        }
        this.loadException = runtimeException;
        this.credentialsProvider = aWSCredentialsProvider;
    }

    @Override
    public AWSCredentials getCredentials() {
        if (this.loadException != null) {
            throw this.loadException;
        }
        return this.credentialsProvider.getCredentials();
    }

    @Override
    public void refresh() {
    }

    public static WebIdentityTokenCredentialsProvider create() {
        return WebIdentityTokenCredentialsProvider.builder().build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String roleSessionName;
        private String webIdentityTokenFile;

        BuilderImpl() {
        }

        @Override
        public Builder roleArn(String string) {
            this.roleArn = string;
            return this;
        }

        public void setRoleArn(String string) {
            this.roleArn(string);
        }

        @Override
        public Builder roleSessionName(String string) {
            this.roleSessionName = string;
            return this;
        }

        public void setRoleSessionName(String string) {
            this.roleSessionName(string);
        }

        @Override
        public Builder webIdentityTokenFile(String string) {
            this.webIdentityTokenFile = string;
            return this;
        }

        public void setWebIdentityTokenFile(String string) {
            this.webIdentityTokenFile(string);
        }

        @Override
        public WebIdentityTokenCredentialsProvider build() {
            return new WebIdentityTokenCredentialsProvider(this);
        }
    }

    public static interface Builder {
        public Builder roleArn(String var1);

        public Builder roleSessionName(String var1);

        public Builder webIdentityTokenFile(String var1);

        public WebIdentityTokenCredentialsProvider build();
    }
}

