/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.InstanceMetadataServiceCredentialsFetcher;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstanceProfileCredentialsProvider
implements AWSCredentialsProvider,
Closeable {
    private static final Log LOG = LogFactory.getLog(InstanceProfileCredentialsProvider.class);
    private static final int ASYNC_REFRESH_INTERVAL_TIME_MINUTES = 1;
    private static final InstanceProfileCredentialsProvider INSTANCE = new InstanceProfileCredentialsProvider();
    private final InstanceMetadataServiceCredentialsFetcher credentialsFetcher = new InstanceMetadataServiceCredentialsFetcher();
    private volatile ScheduledExecutorService executor;
    private volatile boolean shouldRefresh = false;

    @Deprecated
    public InstanceProfileCredentialsProvider() {
        this(false);
    }

    public InstanceProfileCredentialsProvider(boolean bl) {
        this(bl, true);
    }

    public static InstanceProfileCredentialsProvider createAsyncRefreshingProvider(boolean bl) {
        return new InstanceProfileCredentialsProvider(true, bl);
    }

    private InstanceProfileCredentialsProvider(boolean bl, boolean bl2) {
        if (!SDKGlobalConfiguration.isEc2MetadataDisabled() && bl) {
            this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable2) {
                    Thread thread2 = Executors.defaultThreadFactory().newThread(runnable2);
                    thread2.setName("instance-profile-credentials-refresh");
                    thread2.setDaemon(true);
                    return thread2;
                }
            });
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (InstanceProfileCredentialsProvider.this.shouldRefresh) {
                            InstanceProfileCredentialsProvider.this.credentialsFetcher.getCredentials();
                        }
                    }
                    catch (AmazonClientException amazonClientException) {
                        this.handleAsyncRefreshError(amazonClientException);
                    }
                    catch (RuntimeException runtimeException) {
                        this.handleAsyncRefreshError(runtimeException);
                    }
                }

                private void handleAsyncRefreshError(Exception exception) {
                    LOG.warn("Failed when refreshing credentials asynchronously.", exception);
                }
            }, 0L, 1L, TimeUnit.MINUTES);
        }
    }

    public static InstanceProfileCredentialsProvider getInstance() {
        return INSTANCE;
    }

    protected void finalize() throws Throwable {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Override
    public AWSCredentials getCredentials() {
        if (SDKGlobalConfiguration.isEc2MetadataDisabled()) {
            throw new AmazonClientException("AWS_EC2_METADATA_DISABLED is set to true, not loading credentials from EC2 Instance Metadata service");
        }
        AWSCredentials aWSCredentials = this.credentialsFetcher.getCredentials();
        this.shouldRefresh = true;
        return aWSCredentials;
    }

    @Override
    public void refresh() {
        if (this.credentialsFetcher != null) {
            this.credentialsFetcher.refresh();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }
}

