/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.retry.internal.CredentialsEndpointRetryParameters;
import com.amazonaws.retry.internal.CredentialsEndpointRetryPolicy;
import java.io.IOException;

@SdkInternalApi
class ContainerCredentialsRetryPolicy
implements CredentialsEndpointRetryPolicy {
    private static final int MAX_RETRIES = 5;
    private static ContainerCredentialsRetryPolicy instance;

    private ContainerCredentialsRetryPolicy() {
    }

    public static ContainerCredentialsRetryPolicy getInstance() {
        if (instance == null) {
            instance = new ContainerCredentialsRetryPolicy();
        }
        return instance;
    }

    @Override
    public boolean shouldRetry(int n, CredentialsEndpointRetryParameters credentialsEndpointRetryParameters) {
        if (n >= 5) {
            return false;
        }
        Integer n2 = credentialsEndpointRetryParameters.getStatusCode();
        if (n2 != null && n2 >= 500 && n2 < 600) {
            return true;
        }
        return credentialsEndpointRetryParameters.getException() != null && credentialsEndpointRetryParameters.getException() instanceof IOException;
    }
}

