/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.PropertiesCredentials;
import java.io.IOException;
import java.io.InputStream;

public class ClasspathPropertiesFileCredentialsProvider
implements AWSCredentialsProvider {
    private static String DEFAULT_PROPERTIES_FILE = "AwsCredentials.properties";
    private final String credentialsFilePath;

    public ClasspathPropertiesFileCredentialsProvider() {
        this(DEFAULT_PROPERTIES_FILE);
    }

    public ClasspathPropertiesFileCredentialsProvider(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Credentials file path cannot be null");
        }
        this.credentialsFilePath = !string.startsWith("/") ? "/" + string : string;
    }

    @Override
    public AWSCredentials getCredentials() {
        InputStream inputStream2 = this.getClass().getResourceAsStream(this.credentialsFilePath);
        if (inputStream2 == null) {
            throw new SdkClientException("Unable to load AWS credentials from the " + this.credentialsFilePath + " file on the classpath");
        }
        try {
            return new PropertiesCredentials(inputStream2);
        }
        catch (IOException iOException) {
            throw new SdkClientException("Unable to load AWS credentials from the " + this.credentialsFilePath + " file on the classpath", iOException);
        }
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.credentialsFilePath + ")";
    }
}

