/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.ApacheHttpClientConfig;
import com.amazonaws.DnsResolver;
import com.amazonaws.Protocol;
import com.amazonaws.ProxyAuthenticationMethod;
import com.amazonaws.SystemDefaultDnsResolver;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.http.TlsKeyManagersProvider;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryMode;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.ValidationUtils;
import com.amazonaws.util.VersionInfoUtils;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@NotThreadSafe
public class ClientConfiguration {
    private static final Log log = LogFactory.getLog(ClientConfiguration.class);
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 50000;
    public static final int DEFAULT_REQUEST_TIMEOUT = 0;
    public static final int DEFAULT_CLIENT_EXECUTION_TIMEOUT = 0;
    public static final boolean DEFAULT_DISABLE_SOCKET_PROXY = false;
    public static final int DEFAULT_MAX_CONNECTIONS = 50;
    public static final boolean DEFAULT_USE_EXPECT_CONTINUE = true;
    public static final String DEFAULT_USER_AGENT = VersionInfoUtils.getUserAgent();
    public static final RetryPolicy DEFAULT_RETRY_POLICY = PredefinedRetryPolicies.DEFAULT;
    public static final boolean DEFAULT_USE_REAPER = true;
    public static final boolean DEFAULT_USE_GZIP = false;
    public static final long DEFAULT_CONNECTION_TTL = -1L;
    public static final long DEFAULT_CONNECTION_MAX_IDLE_MILLIS = 60000L;
    public static final int DEFAULT_VALIDATE_AFTER_INACTIVITY_MILLIS = 5000;
    public static final boolean DEFAULT_TCP_KEEP_ALIVE = false;
    public static final boolean DEFAULT_THROTTLE_RETRIES = true;
    public static final boolean DEFAULT_CACHE_RESPONSE_METADATA = true;
    public static final int DEFAULT_RESPONSE_METADATA_CACHE_SIZE = 50;
    public static final int DEFAULT_MAX_CONSECUTIVE_RETRIES_BEFORE_THROTTLING = 100;
    private String userAgentPrefix = DEFAULT_USER_AGENT;
    private String userAgentSuffix;
    private int maxErrorRetry = -1;
    private RetryPolicy retryPolicy = DEFAULT_RETRY_POLICY;
    private InetAddress localAddress;
    private Protocol protocol = Protocol.HTTPS;
    private Protocol proxyProtocol = Protocol.HTTP;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String proxyDomain = null;
    private String proxyWorkstation = null;
    private String nonProxyHosts = null;
    private List<ProxyAuthenticationMethod> proxyAuthenticationMethods = null;
    private boolean disableSocketProxy = false;
    private boolean preemptiveBasicProxyAuth;
    private int maxConnections = 50;
    private int socketTimeout = 50000;
    private int connectionTimeout = 10000;
    private int requestTimeout = 0;
    private int clientExecutionTimeout = 0;
    private boolean throttleRetries = true;
    private int socketSendBufferSizeHint = 0;
    private int socketReceiveBufferSizeHint = 0;
    private boolean useReaper = true;
    private boolean useGzip = false;
    private String signerOverride;
    private long connectionTTL = -1L;
    private long connectionMaxIdleMillis = 60000L;
    private int validateAfterInactivityMillis = 5000;
    private boolean tcpKeepAlive = false;
    private boolean cacheResponseMetadata = true;
    private int responseMetadataCacheSize = 50;
    private DnsResolver dnsResolver = new SystemDefaultDnsResolver();
    private SecureRandom secureRandom;
    private Map<String, String> headers = new HashMap<String, String>();
    private boolean useExpectContinue = true;
    private int maxConsecutiveRetriesBeforeThrottling = 100;
    private final ApacheHttpClientConfig apacheHttpClientConfig;
    private boolean disableHostPrefixInjection;
    private final AtomicReference<URLHolder> httpProxyHolder = new AtomicReference();
    private final AtomicReference<URLHolder> httpsProxyHolder = new AtomicReference();
    private TlsKeyManagersProvider tlsKeyManagersProvider;
    private RetryMode retryMode;

    public ClientConfiguration() {
        this.apacheHttpClientConfig = new ApacheHttpClientConfig();
    }

    public ClientConfiguration(ClientConfiguration clientConfiguration) {
        this.connectionTimeout = clientConfiguration.getConnectionTimeout();
        this.maxConnections = clientConfiguration.getMaxConnections();
        this.maxErrorRetry = clientConfiguration.getMaxErrorRetry();
        this.retryPolicy = clientConfiguration.getRetryPolicy();
        this.throttleRetries = clientConfiguration.useThrottledRetries();
        this.localAddress = clientConfiguration.getLocalAddress();
        this.protocol = clientConfiguration.getProtocol();
        this.proxyProtocol = clientConfiguration.getProxyProtocol();
        this.proxyDomain = clientConfiguration.getProxyDomain();
        this.proxyHost = clientConfiguration.getProxyHost();
        this.proxyPassword = clientConfiguration.getProxyPassword();
        this.proxyPort = clientConfiguration.getProxyPort();
        this.proxyUsername = clientConfiguration.getProxyUsername();
        this.proxyWorkstation = clientConfiguration.getProxyWorkstation();
        this.nonProxyHosts = clientConfiguration.getNonProxyHosts();
        this.disableSocketProxy = clientConfiguration.disableSocketProxy();
        this.proxyAuthenticationMethods = clientConfiguration.getProxyAuthenticationMethods();
        this.preemptiveBasicProxyAuth = clientConfiguration.isPreemptiveBasicProxyAuth();
        this.socketTimeout = clientConfiguration.getSocketTimeout();
        this.requestTimeout = clientConfiguration.getRequestTimeout();
        this.clientExecutionTimeout = clientConfiguration.getClientExecutionTimeout();
        this.userAgentPrefix = clientConfiguration.getUserAgentPrefix();
        this.userAgentSuffix = clientConfiguration.getUserAgentSuffix();
        this.useReaper = clientConfiguration.useReaper();
        this.useGzip = clientConfiguration.useGzip();
        this.socketSendBufferSizeHint = clientConfiguration.getSocketBufferSizeHints()[0];
        this.socketReceiveBufferSizeHint = clientConfiguration.getSocketBufferSizeHints()[1];
        this.signerOverride = clientConfiguration.getSignerOverride();
        this.responseMetadataCacheSize = clientConfiguration.getResponseMetadataCacheSize();
        this.dnsResolver = clientConfiguration.getDnsResolver();
        this.useExpectContinue = clientConfiguration.isUseExpectContinue();
        this.apacheHttpClientConfig = new ApacheHttpClientConfig(clientConfiguration.getApacheHttpClientConfig());
        this.cacheResponseMetadata = clientConfiguration.getCacheResponseMetadata();
        this.connectionTTL = clientConfiguration.getConnectionTTL();
        this.connectionMaxIdleMillis = clientConfiguration.getConnectionMaxIdleMillis();
        this.validateAfterInactivityMillis = clientConfiguration.getValidateAfterInactivityMillis();
        this.tcpKeepAlive = clientConfiguration.useTcpKeepAlive();
        this.secureRandom = clientConfiguration.getSecureRandom();
        this.headers.clear();
        this.headers.putAll(clientConfiguration.getHeaders());
        this.maxConsecutiveRetriesBeforeThrottling = clientConfiguration.getMaxConsecutiveRetriesBeforeThrottling();
        this.disableHostPrefixInjection = clientConfiguration.disableHostPrefixInjection;
        this.httpProxyHolder.set(clientConfiguration.httpProxyHolder.get());
        this.httpsProxyHolder.set(clientConfiguration.httpsProxyHolder.get());
        this.tlsKeyManagersProvider = clientConfiguration.tlsKeyManagersProvider;
        this.retryMode = clientConfiguration.retryMode;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public ClientConfiguration withProtocol(Protocol protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
    }

    public ClientConfiguration withMaxConnections(int n) {
        this.setMaxConnections(n);
        return this;
    }

    @Deprecated
    public String getUserAgent() {
        return this.getUserAgentPrefix();
    }

    @Deprecated
    public void setUserAgent(String string) {
        this.setUserAgentPrefix(string);
    }

    @Deprecated
    public ClientConfiguration withUserAgent(String string) {
        return this.withUserAgentPrefix(string);
    }

    public String getUserAgentPrefix() {
        return this.userAgentPrefix;
    }

    public void setUserAgentPrefix(String string) {
        this.userAgentPrefix = string;
    }

    public ClientConfiguration withUserAgentPrefix(String string) {
        this.setUserAgentPrefix(string);
        return this;
    }

    public String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    public void setUserAgentSuffix(String string) {
        this.userAgentSuffix = string;
    }

    public ClientConfiguration withUserAgentSuffix(String string) {
        this.setUserAgentSuffix(string);
        return this;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress;
    }

    public ClientConfiguration withLocalAddress(InetAddress inetAddress) {
        this.setLocalAddress(inetAddress);
        return this;
    }

    private String getSystemProperty(String string) {
        return System.getProperty(string);
    }

    private String getEnvironmentVariable(String string) {
        String string2 = StringUtils.trim(System.getenv(string));
        return StringUtils.hasValue(string2) ? string2 : null;
    }

    private String getEnvironmentVariableCaseInsensitive(String string) {
        String string2 = this.getEnvironmentVariable(string);
        return string2 != null ? string2 : this.getEnvironmentVariable(string.toLowerCase());
    }

    public Protocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public ClientConfiguration withProxyProtocol(Protocol protocol) {
        this.proxyProtocol = protocol == null ? Protocol.HTTP : protocol;
        return this;
    }

    public void setProxyProtocol(Protocol protocol) {
        this.withProxyProtocol(protocol);
    }

    private String getProxyHostProperty() {
        return this.getProtocol() == Protocol.HTTPS ? this.getSystemProperty("https.proxyHost") : this.getSystemProperty("http.proxyHost");
    }

    private String getProxyHostEnvironment() {
        URL uRL = this.getHttpProxyEnvironmentVariable();
        if (uRL != null) {
            return uRL.getHost();
        }
        return null;
    }

    public String getProxyHost() {
        if (this.proxyHost != null) {
            return this.proxyHost;
        }
        if (this.getProxyHostProperty() != null) {
            return this.getProxyHostProperty();
        }
        return this.getProxyHostEnvironment();
    }

    public void setProxyHost(String string) {
        this.proxyHost = string;
    }

    public ClientConfiguration withProxyHost(String string) {
        this.setProxyHost(string);
        return this;
    }

    private int getProxyPortProperty() {
        try {
            return this.getProtocol() == Protocol.HTTPS ? Integer.parseInt(this.getSystemProperty("https.proxyPort")) : Integer.parseInt(this.getSystemProperty("http.proxyPort"));
        }
        catch (NumberFormatException numberFormatException) {
            return this.proxyPort;
        }
    }

    private int getProxyPortEnvironment() {
        URL uRL = this.getHttpProxyEnvironmentVariable();
        if (uRL != null) {
            return uRL.getPort();
        }
        return this.proxyPort;
    }

    public int getProxyPort() {
        if (this.proxyPort >= 0) {
            return this.proxyPort;
        }
        if (this.getProxyPortProperty() >= 0) {
            return this.getProxyPortProperty();
        }
        return this.getProxyPortEnvironment();
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
    }

    public ClientConfiguration withProxyPort(int n) {
        this.setProxyPort(n);
        return this;
    }

    public ClientConfiguration withDisableSocketProxy(boolean bl) {
        this.disableSocketProxy = bl;
        return this;
    }

    public void setDisableSocketProxy(boolean bl) {
        this.withDisableSocketProxy(bl);
    }

    public boolean disableSocketProxy() {
        return this.disableSocketProxy;
    }

    private String getProxyUsernameProperty() {
        return this.getProtocol() == Protocol.HTTPS ? this.getSystemProperty("https.proxyUser") : this.getSystemProperty("http.proxyUser");
    }

    private String getProxyUsernameEnvironment() {
        URL uRL = this.getHttpProxyEnvironmentVariable();
        if (uRL != null) {
            try {
                return uRL.getUserInfo().split(":", 2)[0];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getProxyUsername() {
        if (this.proxyUsername != null) {
            return this.proxyUsername;
        }
        if (this.getProxyUsernameProperty() != null) {
            return this.getProxyUsernameProperty();
        }
        return this.getProxyUsernameEnvironment();
    }

    public void setProxyUsername(String string) {
        this.proxyUsername = string;
    }

    public ClientConfiguration withProxyUsername(String string) {
        this.setProxyUsername(string);
        return this;
    }

    private String getProxyPasswordProperty() {
        return this.getProtocol() == Protocol.HTTPS ? this.getSystemProperty("https.proxyPassword") : this.getSystemProperty("http.proxyPassword");
    }

    private String getProxyPasswordEnvironment() {
        URL uRL = this.getHttpProxyEnvironmentVariable();
        if (uRL != null) {
            try {
                return uRL.getUserInfo().split(":", 2)[1];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getProxyPassword() {
        if (this.proxyPassword != null) {
            return this.proxyPassword;
        }
        if (this.getProxyPasswordProperty() != null) {
            return this.getProxyPasswordProperty();
        }
        return this.getProxyPasswordEnvironment();
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string;
    }

    public ClientConfiguration withProxyPassword(String string) {
        this.setProxyPassword(string);
        return this;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String string) {
        this.proxyDomain = string;
    }

    public ClientConfiguration withProxyDomain(String string) {
        this.setProxyDomain(string);
        return this;
    }

    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public void setProxyWorkstation(String string) {
        this.proxyWorkstation = string;
    }

    public ClientConfiguration withProxyWorkstation(String string) {
        this.setProxyWorkstation(string);
        return this;
    }

    private String getNonProxyHostsProperty() {
        return this.getSystemProperty("http.nonProxyHosts");
    }

    private String getNonProxyHostsEnvironment() {
        String string = this.getEnvironmentVariableCaseInsensitive("NO_PROXY");
        if (string != null) {
            string = string.replace(",", "|");
        }
        return string;
    }

    public String getNonProxyHosts() {
        if (this.nonProxyHosts != null) {
            return this.nonProxyHosts;
        }
        if (this.getNonProxyHostsProperty() != null) {
            return this.getNonProxyHostsProperty();
        }
        return this.getNonProxyHostsEnvironment();
    }

    public void setNonProxyHosts(String string) {
        this.nonProxyHosts = string;
    }

    public ClientConfiguration withNonProxyHosts(String string) {
        this.setNonProxyHosts(string);
        return this;
    }

    public List<ProxyAuthenticationMethod> getProxyAuthenticationMethods() {
        return this.proxyAuthenticationMethods;
    }

    public void setProxyAuthenticationMethods(List<ProxyAuthenticationMethod> list) {
        if (list == null) {
            this.proxyAuthenticationMethods = null;
        } else {
            ValidationUtils.assertNotEmpty(list, "proxyAuthenticationMethods");
            this.proxyAuthenticationMethods = Collections.unmodifiableList(new ArrayList<ProxyAuthenticationMethod>(list));
        }
    }

    public ClientConfiguration withProxyAuthenticationMethods(List<ProxyAuthenticationMethod> list) {
        this.setProxyAuthenticationMethods(list);
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public ClientConfiguration withRetryPolicy(RetryPolicy retryPolicy) {
        this.setRetryPolicy(retryPolicy);
        return this;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public void setMaxErrorRetry(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maxErrorRetry should be non-negative");
        }
        this.maxErrorRetry = n;
    }

    public ClientConfiguration withMaxErrorRetry(int n) {
        this.setMaxErrorRetry(n);
        return this;
    }

    public ClientConfiguration withRetryMode(RetryMode retryMode) {
        this.setRetryMode(retryMode);
        return this;
    }

    public void setRetryMode(RetryMode retryMode) {
        this.retryMode = retryMode;
    }

    public RetryMode getRetryMode() {
        return this.retryMode;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int n) {
        this.socketTimeout = n;
    }

    public ClientConfiguration withSocketTimeout(int n) {
        this.setSocketTimeout(n);
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    public ClientConfiguration withConnectionTimeout(int n) {
        this.setConnectionTimeout(n);
        return this;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int n) {
        this.requestTimeout = n;
    }

    public ClientConfiguration withRequestTimeout(int n) {
        this.setRequestTimeout(n);
        return this;
    }

    public int getClientExecutionTimeout() {
        return this.clientExecutionTimeout;
    }

    public void setClientExecutionTimeout(int n) {
        this.clientExecutionTimeout = n;
    }

    public ClientConfiguration withClientExecutionTimeout(int n) {
        this.setClientExecutionTimeout(n);
        return this;
    }

    public boolean useReaper() {
        return this.useReaper;
    }

    public void setUseReaper(boolean bl) {
        this.useReaper = bl;
    }

    public ClientConfiguration withReaper(boolean bl) {
        this.setUseReaper(bl);
        return this;
    }

    public boolean useThrottledRetries() {
        return this.throttleRetries || this.getSystemProperty("com.amazonaws.sdk.enableThrottledRetry") != null;
    }

    public void setUseThrottleRetries(boolean bl) {
        this.throttleRetries = bl;
    }

    public ClientConfiguration withThrottledRetries(boolean bl) {
        this.setUseThrottleRetries(bl);
        return this;
    }

    public void setMaxConsecutiveRetriesBeforeThrottling(int n) {
        this.maxConsecutiveRetriesBeforeThrottling = ValidationUtils.assertIsPositive(n, "maxConsecutiveRetriesBeforeThrottling");
    }

    public ClientConfiguration withMaxConsecutiveRetriesBeforeThrottling(int n) {
        this.setMaxConsecutiveRetriesBeforeThrottling(n);
        return this;
    }

    public int getMaxConsecutiveRetriesBeforeThrottling() {
        return this.maxConsecutiveRetriesBeforeThrottling;
    }

    public boolean useGzip() {
        return this.useGzip;
    }

    public void setUseGzip(boolean bl) {
        this.useGzip = bl;
    }

    public ClientConfiguration withGzip(boolean bl) {
        this.setUseGzip(bl);
        return this;
    }

    public int[] getSocketBufferSizeHints() {
        return new int[]{this.socketSendBufferSizeHint, this.socketReceiveBufferSizeHint};
    }

    public void setSocketBufferSizeHints(int n, int n2) {
        this.socketSendBufferSizeHint = n;
        this.socketReceiveBufferSizeHint = n2;
    }

    public ClientConfiguration withSocketBufferSizeHints(int n, int n2) {
        this.setSocketBufferSizeHints(n, n2);
        return this;
    }

    public String getSignerOverride() {
        return this.signerOverride;
    }

    public void setSignerOverride(String string) {
        this.signerOverride = string;
    }

    public ClientConfiguration withSignerOverride(String string) {
        this.setSignerOverride(string);
        return this;
    }

    public boolean isPreemptiveBasicProxyAuth() {
        return this.preemptiveBasicProxyAuth;
    }

    public void setPreemptiveBasicProxyAuth(Boolean bl) {
        this.preemptiveBasicProxyAuth = bl;
    }

    public ClientConfiguration withPreemptiveBasicProxyAuth(boolean bl) {
        this.setPreemptiveBasicProxyAuth(bl);
        return this;
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    public void setConnectionTTL(long l) {
        this.connectionTTL = l;
    }

    public ClientConfiguration withConnectionTTL(long l) {
        this.setConnectionTTL(l);
        return this;
    }

    public long getConnectionMaxIdleMillis() {
        return this.connectionMaxIdleMillis;
    }

    public void setConnectionMaxIdleMillis(long l) {
        this.connectionMaxIdleMillis = l;
    }

    public ClientConfiguration withConnectionMaxIdleMillis(long l) {
        this.setConnectionMaxIdleMillis(l);
        return this;
    }

    public int getValidateAfterInactivityMillis() {
        return this.validateAfterInactivityMillis;
    }

    public void setValidateAfterInactivityMillis(int n) {
        this.validateAfterInactivityMillis = n;
    }

    public ClientConfiguration withValidateAfterInactivityMillis(int n) {
        this.setValidateAfterInactivityMillis(n);
        return this;
    }

    public boolean useTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public void setUseTcpKeepAlive(boolean bl) {
        this.tcpKeepAlive = bl;
    }

    public ClientConfiguration withTcpKeepAlive(boolean bl) {
        this.setUseTcpKeepAlive(bl);
        return this;
    }

    public DnsResolver getDnsResolver() {
        return this.dnsResolver;
    }

    public void setDnsResolver(DnsResolver dnsResolver) {
        if (dnsResolver == null) {
            throw new IllegalArgumentException("resolver cannot be null");
        }
        this.dnsResolver = dnsResolver;
    }

    public ClientConfiguration withDnsResolver(DnsResolver dnsResolver) {
        this.setDnsResolver(dnsResolver);
        return this;
    }

    public boolean getCacheResponseMetadata() {
        return this.cacheResponseMetadata;
    }

    public void setCacheResponseMetadata(boolean bl) {
        this.cacheResponseMetadata = bl;
    }

    public ClientConfiguration withCacheResponseMetadata(boolean bl) {
        this.setCacheResponseMetadata(bl);
        return this;
    }

    public int getResponseMetadataCacheSize() {
        return this.responseMetadataCacheSize;
    }

    public void setResponseMetadataCacheSize(int n) {
        this.responseMetadataCacheSize = n;
    }

    public ClientConfiguration withResponseMetadataCacheSize(int n) {
        this.setResponseMetadataCacheSize(n);
        return this;
    }

    public ApacheHttpClientConfig getApacheHttpClientConfig() {
        return this.apacheHttpClientConfig;
    }

    public SecureRandom getSecureRandom() {
        if (this.secureRandom == null) {
            this.secureRandom = new SecureRandom();
        }
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public ClientConfiguration withSecureRandom(SecureRandom secureRandom) {
        this.setSecureRandom(secureRandom);
        return this;
    }

    public boolean isUseExpectContinue() {
        return this.useExpectContinue;
    }

    public void setUseExpectContinue(boolean bl) {
        this.useExpectContinue = bl;
    }

    public ClientConfiguration withUseExpectContinue(boolean bl) {
        this.setUseExpectContinue(bl);
        return this;
    }

    public ClientConfiguration withHeader(String string, String string2) {
        this.addHeader(string, string2);
        return this;
    }

    public void addHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public boolean isDisableHostPrefixInjection() {
        return this.disableHostPrefixInjection;
    }

    public void setDisableHostPrefixInjection(boolean bl) {
        this.disableHostPrefixInjection = bl;
    }

    public ClientConfiguration withDisableHostPrefixInjection(boolean bl) {
        this.setDisableHostPrefixInjection(bl);
        return this;
    }

    public TlsKeyManagersProvider getTlsKeyManagersProvider() {
        return this.tlsKeyManagersProvider;
    }

    public ClientConfiguration withTlsKeyManagersProvider(TlsKeyManagersProvider tlsKeyManagersProvider) {
        this.tlsKeyManagersProvider = tlsKeyManagersProvider;
        return this;
    }

    public void setTlsKeyManagersProvider(TlsKeyManagersProvider tlsKeyManagersProvider) {
        this.withTlsKeyManagersProvider(tlsKeyManagersProvider);
    }

    private URL getHttpProxyEnvironmentVariable() {
        if (this.getProtocol() == Protocol.HTTP) {
            return this.getUrlEnvVar(this.httpProxyHolder, "HTTP_PROXY");
        }
        return this.getUrlEnvVar(this.httpsProxyHolder, "HTTPS_PROXY");
    }

    private URL getUrlEnvVar(AtomicReference<URLHolder> atomicReference, String string) {
        if (atomicReference.get() == null) {
            URLHolder uRLHolder;
            block4: {
                uRLHolder = new URLHolder();
                String string2 = this.getEnvironmentVariableCaseInsensitive(string);
                if (string2 != null) {
                    try {
                        uRLHolder.url = new URL(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (!log.isWarnEnabled()) break block4;
                        log.warn(String.format("Unable to parse %s environment variable value '%s' as URL. It is malformed.", string, string2), malformedURLException);
                    }
                }
            }
            atomicReference.compareAndSet(null, uRLHolder);
        }
        return atomicReference.get().url;
    }

    static class URLHolder {
        private URL url;

        URLHolder() {
        }
    }
}

