/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.HandlerContextAware;
import com.amazonaws.ReadLimitInfo;
import com.amazonaws.RequestClientOptions;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@NotThreadSafe
public abstract class AmazonWebServiceRequest
implements HandlerContextAware,
ReadLimitInfo,
Cloneable {
    public static final AmazonWebServiceRequest NOOP = new AmazonWebServiceRequest(){};
    private ProgressListener progressListener = ProgressListener.NOOP;
    private final RequestClientOptions requestClientOptions = new RequestClientOptions();
    private RequestMetricCollector requestMetricCollector;
    private AWSCredentialsProvider credentialsProvider;
    private Map<String, String> customRequestHeaders;
    private Map<String, List<String>> customQueryParameters;
    private transient Map<HandlerContextKey<?>, Object> handlerContext = new HashMap();
    private AmazonWebServiceRequest cloneSource;
    private Integer sdkRequestTimeout = null;
    private Integer sdkClientExecutionTimeout = null;

    @Deprecated
    public void setRequestCredentials(AWSCredentials aWSCredentials) {
        this.credentialsProvider = aWSCredentials == null ? null : new StaticCredentialsProvider(aWSCredentials);
    }

    @Deprecated
    public AWSCredentials getRequestCredentials() {
        return this.credentialsProvider == null ? null : this.credentialsProvider.getCredentials();
    }

    public void setRequestCredentialsProvider(AWSCredentialsProvider aWSCredentialsProvider) {
        this.credentialsProvider = aWSCredentialsProvider;
    }

    public AWSCredentialsProvider getRequestCredentialsProvider() {
        return this.credentialsProvider;
    }

    public <T extends AmazonWebServiceRequest> T withRequestCredentialsProvider(AWSCredentialsProvider aWSCredentialsProvider) {
        this.setRequestCredentialsProvider(aWSCredentialsProvider);
        AmazonWebServiceRequest amazonWebServiceRequest = this;
        return (T)amazonWebServiceRequest;
    }

    public RequestClientOptions getRequestClientOptions() {
        return this.requestClientOptions;
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public void setRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.requestMetricCollector = requestMetricCollector;
    }

    public <T extends AmazonWebServiceRequest> T withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.setRequestMetricCollector(requestMetricCollector);
        AmazonWebServiceRequest amazonWebServiceRequest = this;
        return (T)amazonWebServiceRequest;
    }

    public void setGeneralProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener == null ? ProgressListener.NOOP : progressListener;
    }

    public ProgressListener getGeneralProgressListener() {
        return this.progressListener;
    }

    public <T extends AmazonWebServiceRequest> T withGeneralProgressListener(ProgressListener progressListener) {
        this.setGeneralProgressListener(progressListener);
        AmazonWebServiceRequest amazonWebServiceRequest = this;
        return (T)amazonWebServiceRequest;
    }

    public Map<String, String> getCustomRequestHeaders() {
        if (this.customRequestHeaders == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.customRequestHeaders);
    }

    public String putCustomRequestHeader(String string, String string2) {
        if (this.customRequestHeaders == null) {
            this.customRequestHeaders = new HashMap<String, String>();
        }
        return this.customRequestHeaders.put(string, string2);
    }

    public Map<String, List<String>> getCustomQueryParameters() {
        if (this.customQueryParameters == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.customQueryParameters);
    }

    public void putCustomQueryParameter(String string, String string2) {
        List<String> list;
        if (this.customQueryParameters == null) {
            this.customQueryParameters = new HashMap<String, List<String>>();
        }
        if ((list = this.customQueryParameters.get(string)) == null) {
            list = new LinkedList<String>();
            this.customQueryParameters.put(string, list);
        }
        list.add(string2);
    }

    @Override
    public final int getReadLimit() {
        return this.requestClientOptions.getReadLimit();
    }

    protected final <T extends AmazonWebServiceRequest> T copyBaseTo(T t2) {
        if (this.customRequestHeaders != null) {
            for (Map.Entry<String, Object> entry : this.customRequestHeaders.entrySet()) {
                t2.putCustomRequestHeader(entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.customQueryParameters != null) {
            for (Map.Entry<String, Object> entry : this.customQueryParameters.entrySet()) {
                if (entry.getValue() == null) continue;
                for (String string : (List)entry.getValue()) {
                    t2.putCustomQueryParameter(entry.getKey(), string);
                }
            }
        }
        t2.setRequestCredentialsProvider(this.credentialsProvider);
        t2.setGeneralProgressListener(this.progressListener);
        t2.setRequestMetricCollector(this.requestMetricCollector);
        this.requestClientOptions.copyTo(t2.getRequestClientOptions());
        return t2;
    }

    public AmazonWebServiceRequest getCloneSource() {
        return this.cloneSource;
    }

    public AmazonWebServiceRequest getCloneRoot() {
        AmazonWebServiceRequest amazonWebServiceRequest = this.cloneSource;
        if (amazonWebServiceRequest != null) {
            while (amazonWebServiceRequest.getCloneSource() != null) {
                amazonWebServiceRequest = amazonWebServiceRequest.getCloneSource();
            }
        }
        return amazonWebServiceRequest;
    }

    private void setCloneSource(AmazonWebServiceRequest amazonWebServiceRequest) {
        this.cloneSource = amazonWebServiceRequest;
    }

    public Integer getSdkRequestTimeout() {
        return this.sdkRequestTimeout;
    }

    public void setSdkRequestTimeout(int n) {
        this.sdkRequestTimeout = n;
    }

    public <T extends AmazonWebServiceRequest> T withSdkRequestTimeout(int n) {
        this.setSdkRequestTimeout(n);
        AmazonWebServiceRequest amazonWebServiceRequest = this;
        return (T)amazonWebServiceRequest;
    }

    public Integer getSdkClientExecutionTimeout() {
        return this.sdkClientExecutionTimeout;
    }

    public void setSdkClientExecutionTimeout(int n) {
        this.sdkClientExecutionTimeout = n;
    }

    public <T extends AmazonWebServiceRequest> T withSdkClientExecutionTimeout(int n) {
        this.setSdkClientExecutionTimeout(n);
        AmazonWebServiceRequest amazonWebServiceRequest = this;
        return (T)amazonWebServiceRequest;
    }

    @Override
    public <X> void addHandlerContext(HandlerContextKey<X> handlerContextKey, X x) {
        this.handlerContext.put(handlerContextKey, x);
    }

    @Override
    public <X> X getHandlerContext(HandlerContextKey<X> handlerContextKey) {
        return (X)this.handlerContext.get(handlerContextKey);
    }

    @SdkInternalApi
    Map<HandlerContextKey<?>, Object> getHandlerContext() {
        return Collections.unmodifiableMap(this.handlerContext);
    }

    public AmazonWebServiceRequest clone() {
        try {
            AmazonWebServiceRequest amazonWebServiceRequest = (AmazonWebServiceRequest)super.clone();
            amazonWebServiceRequest.setCloneSource(this);
            amazonWebServiceRequest.handlerContext = new HashMap(amazonWebServiceRequest.handlerContext);
            return amazonWebServiceRequest;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

