/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.core.crash;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import com.uqm.crashsight.core.api.CrashSightPlatform;
import com.uqm.crashsight.core.api.crash.UQMCrash;
import com.uqm.crashsight.core.crash.CrashInterface;
import com.uqm.crashsight.core.tools.NDKHelper;
import com.uqm.crashsight.core.tools.UQMLog;
import com.uqm.crashsight.crashreport.CrashReport;
import com.uqm.crashsight.crashreport.CrashSightLog;
import com.uqm.crashsight.proguard.ag;
import java.util.HashMap;
import java.util.Map;

public class CrashSight
implements CrashInterface {
    private static final long CS_REPORT_DELAY = 0L;
    private static final int LogLevelSilent = 0;
    private static final int LogLevelError = 1;
    private static final int LogLevelWarn = 2;
    private static final int LogLevelInfo = 3;
    private static final int LogLevelDebug = 4;
    private static final int LogLevelVerbose = 5;
    private static final String LOG_TAG = "[CrashSightPlugin]";
    private static String mAppChannel = null;
    private static String mAppVersion = null;
    private static String mUserId = null;
    private static long mDelay = 0L;
    private static String mCrashUploadServerUrl = null;
    private static boolean mDebugMode = false;
    private static int mCallbackType = 63;
    private static int mCrashHandleTimeout = 60;
    private static String mDeviceId = null;
    private static String mAppDeviceId = null;
    private static String mAppMatchId = null;
    private static String mDeviceModel = null;
    private static String mLogPath = null;
    private static boolean mInitialized = false;
    private static int mGameType = 0;
    private static int mUploadThreadNum = 3;
    private static int mLogLevel = 3;

    /*
     * WARNING - void declaration
     */
    private void setUserValueForSearch(String key, String value) {
        if (value != null) {
            void var2_2;
            void var1_1;
            UQMLog.d("setUserValueForSearch %s:%s", key, value);
            this.setUserValue((String)var1_1, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void configCallbackTypeBeforeInit(int callbackType) {
        void var1_1;
        UQMLog.d("configDefaultBeforeInit invoked: " + callbackType, new Object[0]);
        mCallbackType = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void configCrashHandleTimeout(int timeout) {
        void var1_1;
        UQMLog.d("configCrashHandleTimeout invoked: " + timeout, new Object[0]);
        mCrashHandleTimeout = var1_1;
    }

    @Override
    public void setAppVersion(String appVersion) {
        mAppVersion = appVersion;
    }

    @Override
    public void setDeviceId(String deviceId) {
        mDeviceId = deviceId;
    }

    @Override
    public String getBackendDeviceId() {
        return CrashReport.getBackendDeviceId();
    }

    @Override
    public void setAppDeviceId(String deviceId) {
        mAppDeviceId = deviceId;
        if (mInitialized) {
            this.setUserValueForSearch("K#AppDeviceId", mAppDeviceId);
        }
    }

    @Override
    public String getSDKSessionID() {
        return CrashReport.getSessionId();
    }

    @Override
    public void setCustomizedMatchID(String matchId) {
        mAppMatchId = matchId;
        if (mInitialized) {
            this.setUserValueForSearch("K#AppMatchId", mAppMatchId);
        }
    }

    @Override
    public void setDeviceModel(String deviceModel) {
        mDeviceModel = deviceModel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLogPath(String logPath) {
        mLogPath = logPath;
        if (mInitialized) {
            void var1_1;
            CrashReport.setLogPath((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(String appId, boolean unexpectedTerminatingDetectionEnable, boolean isDebug, String serverUrl) {
        void var1_1;
        mDebugMode = isDebug;
        mCrashUploadServerUrl = serverUrl;
        this.initWithAppId((String)var1_1, true);
        UQMLog.d("init invoked", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logInfo(int level, String tag, String log) {
        void var1_1;
        UQMLog.d("logInfo invoked, level : %d, tag : %s, log : %s", level, tag, log);
        switch (var1_1) {
            case 0: {
                return;
            }
            case 5: {
                CrashSightLog.v(tag, log);
                return;
            }
            case 4: {
                CrashSightLog.d(tag, log);
                return;
            }
            case 3: {
                CrashSightLog.i(tag, log);
                return;
            }
            case 2: {
                CrashSightLog.w(tag, log);
                return;
            }
            case 1: {
                void var3_3;
                void var2_2;
                CrashSightLog.e((String)var2_2, (String)var3_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setUserValue(String key, String value) {
        void var2_2;
        void var1_1;
        UQMLog.d("setUserValue invoked, key : %s, value : %s", key, value);
        CrashReport.putUserData(CrashSightPlatform.getActivity().getApplicationContext(), (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setUserId(String userId) {
        void var1_1;
        if (userId == null) {
            userId = "";
        }
        CrashReport.setUserId(userId);
        UQMLog.d("set user id as %s", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAppId(String appId) {
        void var1_1;
        if (appId == null) {
            appId = "";
        }
        CrashReport.setAppID(appId);
        UQMLog.d("set app id as %s", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setUserSceneTag(String userSceneTag, boolean upload) {
        void var1_1;
        void var2_2;
        if (userSceneTag == null) {
            userSceneTag = "";
        }
        CrashReport.setUserSceneTagStr(userSceneTag, (boolean)var2_2);
        UQMLog.d("set user scene tag as %s", var1_1);
    }

    private String getOpenId() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportException(int type, String exceptionName, String exceptionMsg, String exceptionStack, String extInfoJsonStr, boolean quit, int dumpNativeType, String errorAttachmentPath) {
        void var3_3;
        void var2_2;
        void var1_1;
        UQMLog.d("CS Crash reportException type : %d, exceptionName : %s, exceptionMsg : %s, exceptionStack : %s, extInfo : %s, quit : %s, dumpNativeType : %d", type, exceptionName, exceptionMsg, exceptionStack, extInfoJsonStr, "" + quit, dumpNativeType);
        CrashReport.postException2((int)var1_1, (String)var2_2, (String)var3_3, exceptionStack, extInfoJsonStr, dumpNativeType, errorAttachmentPath);
        if (quit) {
            new Thread(new Runnable(this){
                private /* synthetic */ CrashSight a;
                {
                    this.a = crashSight;
                }

                @Override
                public final void run() {
                    try {
                        UQMLog.w("Exit application by kill process after 3000ms", new Object[0]);
                        Thread.sleep(3000L);
                        int n2 = Process.myPid();
                        UQMLog.w("Exit application by kill process: %d", n2);
                        Process.killProcess((int)n2);
                        return;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        UQMLog.w(throwable.getMessage(), new Object[0]);
                        return;
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setIsAppForeground(boolean isAppForeground) {
        void var1_1;
        CrashReport.setIsAppForeground(isAppForeground);
        UQMLog.d("set is app foreground as " + (boolean)var1_1, new Object[0]);
    }

    public int enableAsyncReportException() {
        return CrashReport.enableAsyncReportException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initWithAppId(String appId, boolean forceOnUiThread) {
        void var2_2;
        Context context;
        UQMLog.debugEnable = mDebugMode;
        UQMLog.d("initWithAppId invoked, appId: %s", appId);
        if (mCrashUploadServerUrl != null) {
            CrashReport.setServerUrl(mCrashUploadServerUrl);
        }
        if ((context = CrashSightPlatform.getActivity()) != null) {
            if (!NDKHelper.loadSO()) {
                UQMLog.e("CrashSight.so is loaded failed", new Object[0]);
                return;
            }
        } else {
            UQMLog.e("crashsight platform get activity failed.", new Object[0]);
            return;
        }
        UQMLog.d("CrashSight.so is loaded successfully", new Object[0]);
        CrashReport.UserStrategy userStrategy = new CrashReport.UserStrategy(context);
        userStrategy.setAppReportDelay(mDelay);
        userStrategy.setCallBackType(mCallbackType);
        UQMLog.d("strategy.setCallBackType: %d", mCallbackType);
        if (mAppChannel != null) {
            userStrategy.setAppChannel(mAppChannel);
            UQMLog.d("strategy.setAppChannel: %s", mAppChannel);
        }
        if (mAppVersion != null) {
            userStrategy.setAppVersion(mAppVersion);
            UQMLog.d("strategy.setAppVersion: %s", mAppVersion);
        }
        if (mDeviceId != null) {
            userStrategy.setDeviceID(mDeviceId);
            UQMLog.d("strategy.setDeviceID: %s", mDeviceId);
        }
        if (mDeviceModel != null) {
            userStrategy.setDeviceModel(mDeviceModel);
            UQMLog.d("strategy.setDeviceModel: %s", mDeviceModel);
        }
        if (mLogPath != null) {
            userStrategy.setLogPath(mLogPath);
            UQMLog.d("strategy.setLogPath: %s", mLogPath);
        }
        if (mUploadThreadNum > 0) {
            userStrategy.setUploadThreadNum(mUploadThreadNum);
            UQMLog.d("strategy.setUploadThreadNum: %d", mUploadThreadNum);
        }
        userStrategy.setCrashHandleTimeout(mCrashHandleTimeout);
        userStrategy.setCrashHandleCallback(new CrashReport.CrashHandleCallback(this){
            private /* synthetic */ CrashSight a;
            {
                this.a = crashSight;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final synchronized Map<String, String> onCrashHandleStart(int crashType, String errorType, String errorMessage, String errorStack) {
                void var3_5;
                Map<String, String> map;
                String string;
                switch (crashType) {
                    case 0: {
                        string = "JAVA_CRASH";
                        break;
                    }
                    case 1: {
                        string = "JAVA_CATCH";
                        break;
                    }
                    case 2: {
                        string = "JAVA_NATIVE";
                        break;
                    }
                    case 3: {
                        string = "JAVA_U3D";
                        break;
                    }
                    case 8: {
                        string = "JAVA_CUSTOM";
                        break;
                    }
                    default: {
                        string = "unknown";
                    }
                }
                UQMLog.d("Crash happen type : %d, typeName : %s, errorType : %s, errorMessage : %s, errorStack: %s", crashType, string, errorType, errorMessage, errorStack);
                map = super.onCrashHandleStart(crashType, (String)((Object)map), (String)var3_5, errorStack);
                if (map == null) {
                    map = new HashMap<String, String>();
                }
                try {
                    void var1_1;
                    String string2 = UQMCrash.attachmentMessageForException((int)var1_1);
                    if (string2.length() > 0) {
                        UQMLog.d("CrashSight extra message report ok, message : %s", string2);
                        map.put("extmsg", string2);
                    } else {
                        UQMLog.d("CrashSight extra message is empty", new Object[0]);
                    }
                }
                catch (Exception exception) {
                    UQMLog.e("onCrashHandleStart extra message report error, message : %s", exception.getMessage());
                }
                return map;
            }

            @Override
            public final synchronized byte[] onCrashHandleStart2GetExtraDatas(int crashType, String errorType, String errorMessage, String errorStack) {
                try {
                    byte[] byArray = UQMCrash.attachmentForException(crashType);
                    if (byArray != null && byArray.length > 0) {
                        UQMLog.d("CrashSight extraBinaryMessage data report ok", new Object[0]);
                        return byArray;
                    }
                    UQMLog.d("CrashSight extraBinaryMessage data is empty", new Object[0]);
                    return null;
                }
                catch (Exception exception) {
                    UQMLog.e("onCrashHandleStart2GetExtraData exception, message : %s", exception.getMessage());
                    return null;
                }
            }

            @Override
            public final synchronized String onCrashHandleStart2GetLogPath(int crashType, String errorType, String errorMessage, String errorStack) {
                try {
                    String string = UQMCrash.attachmentLogPathForException(crashType);
                    if (string != null && string.length() > 0) {
                        UQMLog.d("[attach] CrashSight get log path report ok", new Object[0]);
                        return string;
                    }
                    UQMLog.d("[attach]CrashSight get log path is empty", new Object[0]);
                    return null;
                }
                catch (Exception exception) {
                    UQMLog.e("[attach]onCrashHandleStart2GetLogPath exception, message : %s", exception.getMessage());
                    return null;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final synchronized void onCrashHandleStart2NotifyLogUploadResult(int crashType, int result, String errorType, String errorMessage, String errorStack) {
                try {
                    void var2_3;
                    UQMCrash.attachmentLogUploadResultForException(crashType, (int)var2_3);
                    UQMLog.d("[attach] CrashSight upload log result report ok", new Object[0]);
                    return;
                }
                catch (Exception exception) {
                    UQMLog.e("[attach]onCrashHandleStart2NotifyLogUploadResult exception, message : %s", exception.getMessage());
                    return;
                }
            }
        });
        UQMLog.d("mGameType: %d", mGameType);
        ag.a(mGameType);
        if (!CrashReport.initCrashReportWithAutoContext(appId, mDebugMode, userStrategy, (boolean)var2_2)) {
            void var1_1;
            CrashReport.initCrashReport(context, (String)var1_1, mDebugMode, userStrategy);
        }
        UQMLog.d("mUserId: %s", mUserId);
        UQMLog.d("mDelay: %s", mDelay);
        if (mUserId != null) {
            CrashReport.setUserId(mUserId);
        }
        mInitialized = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setGameType(int gameType) {
        void var1_1;
        UQMLog.d("setGameType invoked, gameType: %d", gameType);
        mGameType = var1_1;
        ag.a(mGameType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setUploadThreadNum(int num) {
        void var1_1;
        UQMLog.d("setUploadThreadNum invoked, num: %d", num);
        mUploadThreadNum = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void configDefaultBeforeInit(String appChannel, String version, String user, long delay) {
        void var3_3;
        void var2_2;
        void var1_1;
        UQMLog.d("configDefaultBeforeInit invoked", new Object[0]);
        mAppChannel = var1_1;
        mAppVersion = var2_2;
        mUserId = var3_3;
        mDelay = delay;
        UQMLog.d("mAppChannel: %s", mAppChannel);
        UQMLog.d("mAppVersion: %s", mAppVersion);
        UQMLog.d("mUserId: %s", mUserId);
        UQMLog.d("mDelay: %d", mDelay);
    }

    @Override
    public void configCrashServerUrlBeforeInit(String serverUrl) {
        mCrashUploadServerUrl = serverUrl;
        if (mCrashUploadServerUrl != null) {
            CrashReport.setServerUrl(mCrashUploadServerUrl);
        }
    }

    @Override
    public void configCrashReporterLogLevelBeforeInit(int logLevel) {
        mLogLevel = logLevel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void configDebugModeBeforeInit(boolean enable) {
        void var1_1;
        UQMLog.debugEnable = enable;
        mDebugMode = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printLog(int level, String msg) {
        void var1_1;
        UQMLog.d("printLog level: %d msg: %s", level, msg);
        if (level > mLogLevel) {
            return;
        }
        switch (var1_1) {
            case 0: {
                return;
            }
            case 5: {
                CrashSightLog.v(LOG_TAG, msg);
                return;
            }
            case 4: {
                CrashSightLog.d(LOG_TAG, msg);
                return;
            }
            case 3: {
                CrashSightLog.i(LOG_TAG, msg);
                return;
            }
            case 2: {
                CrashSightLog.w(LOG_TAG, msg);
                return;
            }
            case 1: {
                void var2_2;
                CrashSightLog.e(LOG_TAG, (String)var2_2);
            }
        }
    }

    @Override
    public void closeCrashReport() {
        CrashReport.closeCrashReport();
    }

    @Override
    public void startCrashReport() {
        CrashReport.startCrashReport();
    }

    @Override
    public void setCatchMultiSignal(boolean enable) {
        CrashReport.setCatchMultiSignal(enable);
    }

    @Override
    public void setUnwindExtraStack(boolean enable) {
        CrashReport.setUnwindExtraStack(enable);
    }

    @Override
    public long getCrashThreadId() {
        return CrashReport.getCrashThreadId();
    }

    @Override
    public String getCrashUUID() {
        return CrashReport.getCrashUUID();
    }

    @Override
    public boolean isLastSessionCrash() {
        return CrashReport.isLastSessionCrash();
    }

    @Override
    public String getLastSessionUserId() {
        return CrashReport.getLastSessionUserId();
    }

    @Override
    public void setLogcatBufferSize(int size) {
        CrashReport.setLogcatBufferSize(size);
    }

    @Override
    public void setEnableGetPackageInfo(boolean enable) {
        CrashReport.setEnableGetPackageInfo(enable);
    }

    @Override
    public void testJavaCrash() {
        new Thread(new Runnable(this){
            private /* synthetic */ CrashSight a;
            {
                this.a = crashSight;
            }

            @Override
            public final void run() {
                throw new RuntimeException("This Crash create for Test! You can go to CrashSight see more detail!");
            }
        }).start();
    }

    @Override
    public void testOomCrash() {
        CrashReport.testOomCrash();
    }

    @Override
    public void testANR() {
        CrashReport.testANRCrash();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startDumpRoutine(int dumpMode, int startTimeMode, long startTime, long dumpInterval, int dumpTimes, boolean saveLocal, String savePath) {
        Context context = CrashSightPlatform.getActivity();
        if (context != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            CrashReport.startDumpRoutine(context, (int)var1_1, (int)var2_2, (long)var3_3, dumpInterval, dumpTimes, saveLocal, savePath);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startMonitorFdCount(int interval, int limit, int dumpType) {
        void var3_3;
        void var2_2;
        CrashReport.startMonitorFdCount(interval, (int)var2_2, (int)var3_3);
    }

    @Override
    public int getExceptionType(String name) {
        return CrashReport.getExceptionType(name);
    }

    @Override
    public void testUseAfterFree() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(this){
            private /* synthetic */ CrashSight a;
            {
                this.a = crashSight;
            }

            @Override
            public final void run() {
                UQMCrash.testUseAfterFree();
            }
        });
    }

    @Override
    public void setServerEnv(String serverEnv) {
        CrashReport.setServerEnv(serverEnv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setEngineInfo(String version, String buildConfig, String language, String locale) {
        void var3_3;
        void var2_2;
        CrashReport.setEngineInfo(version, (String)var2_2, (String)var3_3, locale);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setGpuInfo(String version, String vendor, String renderer) {
        void var3_3;
        void var2_2;
        CrashReport.setGpuInfo(version, (String)var2_2, (String)var3_3);
    }

    @Override
    public void setIsOpengles(boolean isOpengles) {
        CrashReport.setIsOpengles(isOpengles);
    }

    @Override
    public void setEnableFragmentCallbacks(boolean enable) {
        CrashReport.setEnableFragmentCallbacks(enable);
    }

    @Override
    public void useSavedUserId(boolean enable) {
        CrashReport.useSavedUserId(enable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean checkFdCount(int limit, int dumpType, boolean upload) {
        void var3_3;
        void var2_2;
        return CrashReport.checkFdCount(limit, (int)var2_2, (boolean)var3_3);
    }

    @Override
    public void setOomLogPath(String logPath) {
        CrashReport.setOomLogPath(logPath);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportJank(int type, String exceptionName, String exceptionMsg, String exceptionStack, String extInfoJsonStr, int reportInfoOption, String jankAttachmentPath) {
        void var3_3;
        void var2_2;
        void var1_1;
        UQMLog.d("CS Crash reportException type : %d, exceptionName : %s, exceptionMsg : %s, exceptionStack : %s, extInfo : %s, reportInfoOption : %d, jankAttachmentPath : %s", type, exceptionName, exceptionMsg, exceptionStack, extInfoJsonStr, reportInfoOption, jankAttachmentPath);
        CrashReport.postJank((int)var1_1, (String)var2_2, (String)var3_3, exceptionStack, extInfoJsonStr, reportInfoOption, jankAttachmentPath);
    }

    @Override
    public void processEngineAnr(int type) {
        CrashReport.processEngineAnr(type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setEngineMainThread(int tid, String name) {
        void var2_2;
        CrashReport.setEngineMainThread(tid, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportStuck(int threadId, int maxChecks, int checkInterval, String name, String message, String extraInfo, int dumpNativeType, String attachPath) {
        void var3_3;
        void var2_2;
        CrashReport.postStuck(threadId, (int)var2_2, (long)var3_3, name, message, extraInfo, dumpNativeType, attachPath);
    }
}

