/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.symtabfile;

import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.SubroutineVariable;
import com.uqm.crashsight.symtabtool.common.VariableEntry;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.dwarf.EhFrameParser;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.symtab.Symbol;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFileHeader;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFileInfoBean;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class SymtabFile {
    public static final String FILE_KEY = "File";
    public static final String FORMAT_KEY = "Format";
    public static final String APP_ID_KEY = "AppID";
    public static final String APP_VERSION_KEY = "AppVer";
    public static final String ARCH_KEY = "Arch";
    public static final String SYMBOLS_KEY = "Symbols";
    public static final String TOOL_VERSION_KEY = "Tool Version";
    public static final String FILE_VERSION_KEY = "File Version";
    public static final String BUILT_TIME_KEY = "Built Time";
    public static final String UUID_KEY = "UUID";
    public static final String SHA1_KEY = "SHA-1";
    public static final String SO_VERSION_KEY = "SO Version";
    public static final String P_VADDR = "Program Virtual Address";
    public static final String P_OFFSET = "Program Offset";
    public static final String SYMTAB_LABEL = "Symbol table";
    public static final String SYMTAB_FILE_VERSION = "3.0";
    public static final String ZIP_FILE_SEPERATOR = "_";
    public static final String SYMTAB_FILE_PREFIX = "crashsightSymbol";
    public static final String BREAKPAD_SYMTAB_FILE_PREFIX = "crashsightBreakpadSymbol";
    public static final String SYMTAB_FILE_SUFFIX = ".symbol";
    public static final String BREAKPAD_SYMTAB_FILE_SUFFIX = ".sym";
    public static final String STACK_VARIABLE_SYMTAB_FILE_SUFFIX = ".stack";
    public static final String FILE_TYPE_ELF = "ELF";
    public static final String FILE_TYPE_MACH = "Mach-O";
    public static final String FILE_TYPE_PDB = "PDB";
    public static final String FILE_TYPE_LINUX_ELF = "LINUX_ELF";
    public static final int BYTE_BUFFER_SIZE = 0x6400000;
    public static final int MAX_LEB128_LENGTH = 16;
    public static final long FILE_FORMAT_INVALID = 0L;
    public static final long FILE_FORMAT_32 = 32L;
    public static final long FILE_FORMAT_64 = 64L;
    private static final String SYMTAB_FILE_SEPERATOR = "&";
    private static final String BREAKPAD_FILE_SUFFIX = "sym";
    private static final String STACK_VARIABLE_FILE_SUFFIX = "stack";
    private static final String BREAKPAD_INDEX_FILE_SUFFIX = "file";
    private static final String BREAKPAD_INDEX_FUNC_SUFFIX = "func";
    private static final String BREAKPAD_INDEX_CFI_SUFFIX = "cfi";
    private static File breakpadSym = null;
    private static RandomAccessFile breakpadRandomAccess = null;
    private static File breakpadFile;
    private static RandomAccessFile breakpadFileRandomAccess;
    private static File breakpadFuncFile;
    private static RandomAccessFile breakpadFuncRandomAccess;
    private static File breakpadCfiFile;
    private static RandomAccessFile breakpadCfiRandomAccess;
    private static File stackVariableFile;
    private static RandomAccessFile stackVariableRandomAccess;
    private String fileName = null;
    private String pathName = null;
    private String symtabFileName = null;
    private String breakpadSymtabFileName = null;
    private String stackVariableSymtabFileName = null;
    private String appName = null;
    private String arch = null;
    private String uuid = null;
    private String sha1 = null;
    private String soVersion = null;
    private String fileType = null;
    private String fileFormat = null;
    private String symtabToolVersion = null;
    private SymtabFileHeader header = null;
    private String programVaddr = null;
    private String programOffset = null;

    private SymtabFile() {
    }

    private static FileChannel createFileChannel(String fileName, String outputDirName, String suffix) {
        if (null == fileName) {
            return null;
        }
        String newFileName = FileHelper.changeFileSuffix(new File(fileName).getName(), suffix);
        newFileName = FileHelper.changeFilePath(newFileName, outputDirName);
        switch (suffix) {
            case "sym": {
                breakpadSym = new File(newFileName);
                if (breakpadSym.exists() && !breakpadSym.delete()) {
                    Log.error("[Breakpad] Fail to delete " + newFileName, new Object[0]);
                }
                if (null == (breakpadRandomAccess = FileHelper.openRandomAccessFile(breakpadSym))) {
                    Log.error("[Breakpad] Fail to open sym channel", new Object[0]);
                    return null;
                }
                return breakpadRandomAccess.getChannel();
            }
            case "file": {
                breakpadFile = new File(newFileName);
                if (breakpadFile.exists() && !breakpadFile.delete()) {
                    Log.error("[Breakpad] Fail to delete " + newFileName, new Object[0]);
                }
                if (null == (breakpadFileRandomAccess = FileHelper.openRandomAccessFile(breakpadFile))) {
                    Log.error("[Breakpad] Fail to open file index channel", new Object[0]);
                    return null;
                }
                return breakpadFileRandomAccess.getChannel();
            }
            case "func": {
                breakpadFuncFile = new File(newFileName);
                if (breakpadFuncFile.exists() && !breakpadFuncFile.delete()) {
                    Log.error("[Breakpad] Fail to delete " + newFileName, new Object[0]);
                }
                if (null == (breakpadFuncRandomAccess = FileHelper.openRandomAccessFile(breakpadFuncFile))) {
                    Log.error("[Breakpad] Fail to open func index channel", new Object[0]);
                    return null;
                }
                return breakpadFuncRandomAccess.getChannel();
            }
            case "cfi": {
                breakpadCfiFile = new File(newFileName);
                if (breakpadCfiFile.exists() && !breakpadCfiFile.delete()) {
                    Log.error("[Breakpad] Fail to delete " + newFileName, new Object[0]);
                }
                if (null == (breakpadCfiRandomAccess = FileHelper.openRandomAccessFile(breakpadCfiFile))) {
                    Log.error("[Breakpad] Fail to open cfi index channel", new Object[0]);
                    return null;
                }
                return breakpadCfiRandomAccess.getChannel();
            }
            case "stack": {
                stackVariableFile = new File(newFileName);
                if (stackVariableFile.exists() && !stackVariableFile.delete()) {
                    Log.error("[StackVariable] Fail to delete " + newFileName, new Object[0]);
                }
                if (null == (stackVariableRandomAccess = FileHelper.openRandomAccessFile(stackVariableFile))) {
                    Log.error("[StackVariable] Fail to open stack variable index channel", new Object[0]);
                    return null;
                }
                return stackVariableRandomAccess.getChannel();
            }
        }
        return null;
    }

    public static void writeStrToBuffer(FileChannel fc, ByteBuffer buffer, String str) {
        try {
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            if (buffer.remaining() < bytes.length + 1024) {
                buffer.flip();
                fc.write(buffer);
                buffer.clear();
            }
            buffer.put(bytes);
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    private static boolean writeBufferToFile(FileChannel stifFc, FileChannel fc, ByteBuffer buffer) {
        buffer.clear();
        try {
            fc.position(0L);
            while (fc.read(buffer) > 0) {
                buffer.flip();
                stifFc.write(buffer);
                buffer.clear();
            }
            return true;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }

    public static SymtabFile create(SymtabFileInfoBean symtabFileInfoBean) {
        SymtabFile symtabFile = new SymtabFile();
        symtabFile.setSymtabFileInfo(symtabFileInfoBean);
        if (!symtabFile.createSymtabFile(symtabFileInfoBean.getSymbolTable(), symtabFileInfoBean.getVmAddr())) {
            return null;
        }
        return symtabFile;
    }

    public String getSymtabFileName() {
        return this.symtabFileName;
    }

    public String getBreakpadSymtabFileName() {
        return this.breakpadSymtabFileName;
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
        this.pathName = new File(fileName).getParent() + File.separator;
    }

    private void setFileType(String fileType) {
        this.fileType = fileType;
    }

    private void setFileFormat(long fileFormat) {
        if (32L == fileFormat) {
            this.fileFormat = Long.toString(64L);
        } else if (64L == fileFormat) {
            this.fileFormat = Long.toString(fileFormat);
        } else {
            Log.error("SymtabFile: The file-format is not acceptable!", new Object[0]);
        }
        this.fileFormat = this.fileFormat + "-Bit";
    }

    private void setAppName(String appName) {
        this.appName = appName;
    }

    private void setArch(String arch) {
        this.arch = arch;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public void setSoVersion(String soVersion) {
        this.soVersion = soVersion;
    }

    private void setSymtabToolVersion(String symtabToolVersion) {
        this.symtabToolVersion = symtabToolVersion;
    }

    private void setProgramVaddr(String programVaddr) {
        this.programVaddr = programVaddr;
    }

    private void setProgramOffset(String programOffset) {
        this.programOffset = programOffset;
    }

    public boolean delete() {
        if (null == this.symtabFileName) {
            return true;
        }
        File file = new File(this.symtabFileName);
        if (file.exists()) {
            file.deleteOnExit();
        }
        return true;
    }

    private String elfSymtabFileNameFormatter() {
        if (null == this.pathName) {
            return null;
        }
        if (null == this.arch || null == this.appName) {
            return null;
        }
        String elfSymtabFileName = this.pathName;
        elfSymtabFileName = elfSymtabFileName + SYMTAB_FILE_PREFIX;
        elfSymtabFileName = elfSymtabFileName + SYMTAB_FILE_SEPERATOR;
        elfSymtabFileName = elfSymtabFileName + this.arch;
        elfSymtabFileName = elfSymtabFileName + SYMTAB_FILE_SEPERATOR;
        elfSymtabFileName = elfSymtabFileName + Utils.urlEncodeString(this.appName);
        elfSymtabFileName = elfSymtabFileName + SYMTAB_FILE_SEPERATOR;
        elfSymtabFileName = elfSymtabFileName + this.sha1;
        elfSymtabFileName = elfSymtabFileName + SYMTAB_FILE_SUFFIX;
        return elfSymtabFileName;
    }

    private String machSymtabFileNameFormatter() {
        if (null == this.pathName) {
            return null;
        }
        if (null == this.arch || null == this.appName || null == this.uuid) {
            return null;
        }
        String machSymtabFileName = this.pathName;
        machSymtabFileName = machSymtabFileName + SYMTAB_FILE_PREFIX;
        machSymtabFileName = machSymtabFileName + SYMTAB_FILE_SEPERATOR;
        machSymtabFileName = machSymtabFileName + Utils.urlEncodeString(this.appName);
        machSymtabFileName = machSymtabFileName + SYMTAB_FILE_SEPERATOR;
        machSymtabFileName = machSymtabFileName + this.arch;
        machSymtabFileName = machSymtabFileName + SYMTAB_FILE_SEPERATOR;
        machSymtabFileName = machSymtabFileName + this.uuid;
        machSymtabFileName = machSymtabFileName + SYMTAB_FILE_SUFFIX;
        return machSymtabFileName;
    }

    private String pdbSymtabFileNameFormatter() {
        if (null == this.pathName) {
            return null;
        }
        if (null == this.arch || null == this.appName) {
            return null;
        }
        String pdbSymtabFileName = this.pathName;
        pdbSymtabFileName = pdbSymtabFileName + SYMTAB_FILE_PREFIX;
        pdbSymtabFileName = pdbSymtabFileName + SYMTAB_FILE_SEPERATOR;
        pdbSymtabFileName = pdbSymtabFileName + this.arch;
        pdbSymtabFileName = pdbSymtabFileName + SYMTAB_FILE_SEPERATOR;
        pdbSymtabFileName = pdbSymtabFileName + Utils.urlEncodeString(this.appName);
        pdbSymtabFileName = pdbSymtabFileName + SYMTAB_FILE_SEPERATOR;
        pdbSymtabFileName = pdbSymtabFileName + this.uuid;
        pdbSymtabFileName = pdbSymtabFileName + SYMTAB_FILE_SUFFIX;
        return pdbSymtabFileName;
    }

    private String breakpadSymtabFileNameFormatter(boolean onlyCfi) {
        if (null == this.pathName) {
            return null;
        }
        if (null == this.arch || null == this.appName) {
            return null;
        }
        String breakpadSymtabFileName = this.pathName;
        breakpadSymtabFileName = breakpadSymtabFileName + SYMTAB_FILE_PREFIX;
        breakpadSymtabFileName = breakpadSymtabFileName + SYMTAB_FILE_SEPERATOR;
        breakpadSymtabFileName = breakpadSymtabFileName + this.arch;
        breakpadSymtabFileName = breakpadSymtabFileName + SYMTAB_FILE_SEPERATOR;
        breakpadSymtabFileName = breakpadSymtabFileName + Utils.urlEncodeString(this.appName);
        breakpadSymtabFileName = breakpadSymtabFileName + SYMTAB_FILE_SEPERATOR;
        breakpadSymtabFileName = breakpadSymtabFileName + this.uuid;
        breakpadSymtabFileName = breakpadSymtabFileName + BREAKPAD_SYMTAB_FILE_SUFFIX;
        return breakpadSymtabFileName;
    }

    private String stackVariableSymtabFileNameFormatter() {
        if (null == this.pathName) {
            return null;
        }
        if (null == this.arch || null == this.appName) {
            return null;
        }
        String symtabFileName = this.pathName;
        symtabFileName = symtabFileName + SYMTAB_FILE_PREFIX;
        symtabFileName = symtabFileName + SYMTAB_FILE_SEPERATOR;
        symtabFileName = symtabFileName + this.arch;
        symtabFileName = symtabFileName + SYMTAB_FILE_SEPERATOR;
        symtabFileName = symtabFileName + Utils.urlEncodeString(this.appName);
        symtabFileName = symtabFileName + SYMTAB_FILE_SEPERATOR;
        Log.info("uuid is %s", this.uuid);
        symtabFileName = symtabFileName + this.uuid;
        symtabFileName = symtabFileName + STACK_VARIABLE_SYMTAB_FILE_SUFFIX;
        return symtabFileName;
    }

    private void fixSymbolAddr(Symbol symbol, long vmaddr) {
        if (this.fileType.equals(FILE_TYPE_ELF)) {
            symbol.setAddress(symbol.getAddress() + vmaddr);
            symbol.setEndAddress(symbol.getEndAddress() + vmaddr);
        } else {
            symbol.setAddress(symbol.getAddress() - vmaddr);
            symbol.setEndAddress(symbol.getEndAddress() - vmaddr);
        }
    }

    private void fixSymbolSrcFile(Symbol symbol) {
        int index;
        String srcFile;
        if (FILE_TYPE_MACH.equals(this.fileType) && null != (srcFile = symbol.getSourceFile()) && (index = srcFile.lastIndexOf("/")) > 0) {
            srcFile = srcFile.substring(index + 1);
            symbol.setSourceFile(srcFile);
        }
    }

    private String constructSymtabFileHeader(SymbolTable symbolTable) {
        this.header = new SymtabFileHeader();
        this.header.put(FILE_KEY, this.fileName);
        String format = this.fileType + "/" + this.fileFormat;
        this.header.put(FORMAT_KEY, format);
        this.header.put(ARCH_KEY, this.arch);
        this.header.put(SYMBOLS_KEY, Long.toString(symbolTable.size()));
        this.header.put(TOOL_VERSION_KEY, this.symtabToolVersion);
        this.header.put(FILE_VERSION_KEY, SYMTAB_FILE_VERSION);
        if (FILE_TYPE_ELF.equals(this.fileType)) {
            if (this.soVersion != null) {
                this.header.put(SO_VERSION_KEY, this.soVersion);
            }
            this.header.put(SHA1_KEY, this.sha1);
        } else if (FILE_TYPE_MACH.equals(this.fileType)) {
            this.header.put(UUID_KEY, this.uuid);
        }
        this.header.put(BUILT_TIME_KEY, Utils.getDateTime());
        this.header.put(P_VADDR, this.programVaddr);
        this.header.put(P_OFFSET, this.programOffset);
        this.header.put(SYMTAB_LABEL, null);
        return this.header.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createBreakpadSymtab(ElfParser elfParser, boolean onlyCfi) {
        elfParser.parseBreakpadDebugId();
        elfParser.parseBreakpadCodeId();
        SymbolTable symbolTable = elfParser.getSymbolTable();
        ByteBuffer byteBuffer = ByteBuffer.allocate(0x6400000);
        this.breakpadSymtabFileName = this.breakpadSymtabFileNameFormatter(onlyCfi);
        FileChannel fc = SymtabFile.createFileChannel(this.breakpadSymtabFileName, this.pathName, BREAKPAD_FILE_SUFFIX);
        if (fc == null) {
            return false;
        }
        FileChannel fileIndexFc = SymtabFile.createFileChannel(this.fileName, this.pathName, BREAKPAD_INDEX_FILE_SUFFIX);
        ByteBuffer fileIndexBuffer = ByteBuffer.allocate(0x6400000);
        FileChannel funcIndexFc = SymtabFile.createFileChannel(this.fileName, this.pathName, BREAKPAD_INDEX_FUNC_SUFFIX);
        ByteBuffer funcIndexBuffer = ByteBuffer.allocate(0x6400000);
        FileChannel cfiIndexFc = SymtabFile.createFileChannel(this.fileName, this.pathName, BREAKPAD_INDEX_CFI_SUFFIX);
        ByteBuffer cfiIndexBuffer = ByteBuffer.allocate(0x6400000);
        try {
            if (!onlyCfi) {
                HashMap<String, Integer> idMap = new HashMap<String, Integer>();
                int id = 1;
                Symbol symbol = symbolTable.next();
                while (symbol != null) {
                    this.fixSymbolSrcFile(symbol);
                    String filePath = symbol.getSourceFile();
                    int fileId = 0;
                    if (filePath != null) {
                        if (!idMap.containsKey(filePath)) {
                            idMap.put(filePath, id);
                            fileId = id;
                            String fileStr = String.format("FILE %d %s\n", id, filePath);
                            SymtabFile.writeStrToBuffer(fileIndexFc, fileIndexBuffer, fileStr);
                            ++id;
                        } else {
                            fileId = (Integer)idMap.get(filePath);
                        }
                    }
                    if (symbol.getAddress() < symbol.getEndAddress()) {
                        String funcName = symbol.getFunction();
                        ArrayList<Symbol> funcSymbols = new ArrayList<Symbol>();
                        funcSymbols.add(symbol);
                        Symbol lastSymbol = symbol;
                        while (null != (symbol = symbolTable.next()) && StringUtils.equalsIgnoreCase(lastSymbol.getFunction(), symbol.getFunction())) {
                            funcSymbols.add(symbol);
                        }
                        long startAddress = ((Symbol)funcSymbols.get(0)).getAddress();
                        long endAddress = ((Symbol)funcSymbols.get(funcSymbols.size() - 1)).getEndAddress();
                        long size = endAddress - startAddress;
                        String funcStr = String.format("FUNC %s %s 0 %s\n", Long.toHexString(startAddress), Long.toHexString(size), funcName);
                        SymtabFile.writeStrToBuffer(funcIndexFc, funcIndexBuffer, funcStr);
                        for (Symbol funcSymbol : funcSymbols) {
                            String lineStr = String.format("%s %s %d %d\n", Long.toHexString(funcSymbol.getAddress()), Long.toHexString(funcSymbol.getEndAddress() - funcSymbol.getAddress()), funcSymbol.getSourceLine() < 0L ? 0L : funcSymbol.getSourceLine(), fileId);
                            SymtabFile.writeStrToBuffer(funcIndexFc, funcIndexBuffer, lineStr);
                        }
                        continue;
                    }
                    symbol = symbolTable.next();
                }
            }
            EhFrameParser ehFrameParser = new EhFrameParser();
            ehFrameParser.parseDwarf(elfParser.getHeaderParser(), elfParser, cfiIndexFc, cfiIndexBuffer);
            String fileName = Paths.get(elfParser.getFileName(), new String[0]).getFileName().toString();
            elfParser.breakpadArch = ehFrameParser.getArchName();
            SymtabFile.writeStrToBuffer(fc, byteBuffer, String.format("MODULE Linux %s %s %s\n", ehFrameParser.getArchName(), elfParser.getBreakpadDebugId(), fileName));
            SymtabFile.writeStrToBuffer(fc, byteBuffer, String.format("INFO CODE_ID %s\n", elfParser.getBreakpadCodeId()));
            fileIndexBuffer.flip();
            fileIndexFc.write(fileIndexBuffer);
            funcIndexBuffer.flip();
            funcIndexFc.write(funcIndexBuffer);
            cfiIndexBuffer.flip();
            cfiIndexFc.write(cfiIndexBuffer);
            byteBuffer.flip();
            fc.write(byteBuffer);
            if (!onlyCfi) {
                if (!SymtabFile.writeBufferToFile(fc, fileIndexFc, byteBuffer)) {
                    Log.error("[Breakpad] write file index error", new Object[0]);
                }
                if (!SymtabFile.writeBufferToFile(fc, funcIndexFc, byteBuffer)) {
                    Log.error("[Breakpad] write func index error", new Object[0]);
                }
            }
            if (!SymtabFile.writeBufferToFile(fc, cfiIndexFc, byteBuffer)) {
                Log.error("[Breakpad] write cfi index error", new Object[0]);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            FileHelper.closeFile(breakpadFileRandomAccess);
            if (!breakpadFile.delete()) {
                breakpadFile.deleteOnExit();
            }
            FileHelper.closeFile(breakpadFuncRandomAccess);
            if (!breakpadFuncFile.delete()) {
                breakpadFuncFile.deleteOnExit();
            }
            FileHelper.closeFile(breakpadCfiRandomAccess);
            if (!breakpadCfiFile.delete()) {
                breakpadCfiFile.deleteOnExit();
            }
            FileHelper.closeFile(breakpadRandomAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createStackVariableSymtab(ElfParser elfParser) {
        SymbolTable symbolTable = elfParser.getSymbolTable();
        this.stackVariableSymtabFileName = this.stackVariableSymtabFileNameFormatter();
        FileChannel fc = SymtabFile.createFileChannel(this.stackVariableSymtabFileName, this.pathName, STACK_VARIABLE_FILE_SUFFIX);
        if (fc == null) {
            return false;
        }
        ByteBuffer buffer = ByteBuffer.allocate(0x6400000);
        try {
            String fileName = Paths.get(elfParser.getFileName(), new String[0]).getFileName().toString();
            SymtabFile.writeStrToBuffer(fc, buffer, String.format("MODULE Linux %s %s %s\n", elfParser.breakpadArch, elfParser.getBreakpadDebugId(), fileName));
            SymtabFile.writeStrToBuffer(fc, buffer, String.format("INFO CODE_ID %s\n", elfParser.getBreakpadCodeId()));
            for (SubroutineVariable subroutineVariable : symbolTable.subroutineVariables) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < subroutineVariable.getVariableEntries().size(); ++i) {
                    VariableEntry variableEntry = subroutineVariable.getVariableEntries().get(i);
                    sb.append(variableEntry.getName()).append(" ").append(variableEntry.getSize()).append(" ").append(variableEntry.getReadable()).append("\n");
                }
                String variables = sb.toString();
                for (Subroutine subroutine : subroutineVariable.getSubroutines()) {
                    long startAddress = subroutine.getLowPc();
                    long endAddress = subroutine.getHighPc();
                    long size = endAddress - startAddress;
                    String funcStr = String.format("FUNC %s %s\n%s", Long.toHexString(startAddress), Long.toHexString(size), variables);
                    SymtabFile.writeStrToBuffer(fc, buffer, funcStr);
                }
            }
            buffer.flip();
            fc.write(buffer);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            FileHelper.closeFile(stackVariableRandomAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createSymtabFile(SymbolTable symbolTable, long vmAddr) {
        if (FILE_TYPE_ELF.equals(this.fileType) || FILE_TYPE_LINUX_ELF.equals(this.fileType)) {
            this.symtabFileName = this.elfSymtabFileNameFormatter();
        } else if (FILE_TYPE_MACH.equals(this.fileType)) {
            this.symtabFileName = this.machSymtabFileNameFormatter();
        } else if (FILE_TYPE_PDB.equals(this.fileType)) {
            this.symtabFileName = this.pdbSymtabFileNameFormatter();
        } else {
            Log.error("SymtabFile: Type of the file is unknown!", new Object[0]);
            return false;
        }
        if (null == this.symtabFileName) {
            Log.error("SymtabFile: The info to construct name of the symtab file is not enough!", new Object[0]);
            return false;
        }
        Log.info("Begin to create symtab file: %s", this.symtabFileName);
        BufferedWriter bufferedWriter = FileHelper.openFileWriter(new File(this.symtabFileName));
        if (null == bufferedWriter) {
            Log.error("SymtabFile: Failed to open symtab file!", new Object[0]);
            return false;
        }
        try {
            String header = this.constructSymtabFileHeader(symbolTable);
            if (null == header) {
                Log.error("SymtabFile: Failed to construct header of symtab file!", new Object[0]);
                boolean bl = false;
                return bl;
            }
            bufferedWriter.write(header);
        }
        catch (IOException e) {
            Log.error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            FileHelper.closeFile(bufferedWriter);
        }
        Log.info("Successfully created symtab file!", new Object[0]);
        return true;
    }

    private void setSymtabFileInfo(SymtabFileInfoBean symtabFileInfoBean) {
        this.setFileType(symtabFileInfoBean.getFileType());
        this.setFileFormat(symtabFileInfoBean.getFileFormat());
        this.setArch(symtabFileInfoBean.getArch());
        this.setFileName(symtabFileInfoBean.getFileName());
        this.setAppName(symtabFileInfoBean.getAppName());
        this.setSha1(symtabFileInfoBean.getSha1());
        this.setSoVersion(symtabFileInfoBean.getSoVersion());
        this.setUuid(symtabFileInfoBean.getUuid());
        this.setSymtabToolVersion(symtabFileInfoBean.getSymtabToolVersion());
        this.setProgramVaddr(String.valueOf(symtabFileInfoBean.getPvaddr()));
        if (this.fileType.equals(FILE_TYPE_LINUX_ELF)) {
            this.setProgramOffset(String.valueOf(symtabFileInfoBean.getPvaddr()));
        } else {
            this.setProgramOffset(String.valueOf(symtabFileInfoBean.getPOffset()));
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getStackVariableSymtabFileName() {
        return this.stackVariableSymtabFileName;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getArch() {
        return this.arch;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getSoVersion() {
        return this.soVersion;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getSymtabToolVersion() {
        return this.symtabToolVersion;
    }

    public SymtabFileHeader getHeader() {
        return this.header;
    }

    public String getProgramVaddr() {
        return this.programVaddr;
    }

    public String getProgramOffset() {
        return this.programOffset;
    }

    public void setPathName(String pathName) {
        this.pathName = pathName;
    }

    public void setSymtabFileName(String symtabFileName) {
        this.symtabFileName = symtabFileName;
    }

    public void setBreakpadSymtabFileName(String breakpadSymtabFileName) {
        this.breakpadSymtabFileName = breakpadSymtabFileName;
    }

    public void setStackVariableSymtabFileName(String stackVariableSymtabFileName) {
        this.stackVariableSymtabFileName = stackVariableSymtabFileName;
    }

    public void setHeader(SymtabFileHeader header) {
        this.header = header;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SymtabFile)) {
            return false;
        }
        SymtabFile other = (SymtabFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$pathName = this.getPathName();
        String other$pathName = other.getPathName();
        if (this$pathName == null ? other$pathName != null : !this$pathName.equals(other$pathName)) {
            return false;
        }
        String this$symtabFileName = this.getSymtabFileName();
        String other$symtabFileName = other.getSymtabFileName();
        if (this$symtabFileName == null ? other$symtabFileName != null : !this$symtabFileName.equals(other$symtabFileName)) {
            return false;
        }
        String this$breakpadSymtabFileName = this.getBreakpadSymtabFileName();
        String other$breakpadSymtabFileName = other.getBreakpadSymtabFileName();
        if (this$breakpadSymtabFileName == null ? other$breakpadSymtabFileName != null : !this$breakpadSymtabFileName.equals(other$breakpadSymtabFileName)) {
            return false;
        }
        String this$stackVariableSymtabFileName = this.getStackVariableSymtabFileName();
        String other$stackVariableSymtabFileName = other.getStackVariableSymtabFileName();
        if (this$stackVariableSymtabFileName == null ? other$stackVariableSymtabFileName != null : !this$stackVariableSymtabFileName.equals(other$stackVariableSymtabFileName)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$arch = this.getArch();
        String other$arch = other.getArch();
        if (this$arch == null ? other$arch != null : !this$arch.equals(other$arch)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$sha1 = this.getSha1();
        String other$sha1 = other.getSha1();
        if (this$sha1 == null ? other$sha1 != null : !this$sha1.equals(other$sha1)) {
            return false;
        }
        String this$soVersion = this.getSoVersion();
        String other$soVersion = other.getSoVersion();
        if (this$soVersion == null ? other$soVersion != null : !this$soVersion.equals(other$soVersion)) {
            return false;
        }
        String this$fileType = this.getFileType();
        String other$fileType = other.getFileType();
        if (this$fileType == null ? other$fileType != null : !this$fileType.equals(other$fileType)) {
            return false;
        }
        String this$fileFormat = this.getFileFormat();
        String other$fileFormat = other.getFileFormat();
        if (this$fileFormat == null ? other$fileFormat != null : !this$fileFormat.equals(other$fileFormat)) {
            return false;
        }
        String this$symtabToolVersion = this.getSymtabToolVersion();
        String other$symtabToolVersion = other.getSymtabToolVersion();
        if (this$symtabToolVersion == null ? other$symtabToolVersion != null : !this$symtabToolVersion.equals(other$symtabToolVersion)) {
            return false;
        }
        SymtabFileHeader this$header = this.getHeader();
        SymtabFileHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        String this$programVaddr = this.getProgramVaddr();
        String other$programVaddr = other.getProgramVaddr();
        if (this$programVaddr == null ? other$programVaddr != null : !this$programVaddr.equals(other$programVaddr)) {
            return false;
        }
        String this$programOffset = this.getProgramOffset();
        String other$programOffset = other.getProgramOffset();
        return !(this$programOffset == null ? other$programOffset != null : !this$programOffset.equals(other$programOffset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SymtabFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $pathName = this.getPathName();
        result = result * 59 + ($pathName == null ? 43 : $pathName.hashCode());
        String $symtabFileName = this.getSymtabFileName();
        result = result * 59 + ($symtabFileName == null ? 43 : $symtabFileName.hashCode());
        String $breakpadSymtabFileName = this.getBreakpadSymtabFileName();
        result = result * 59 + ($breakpadSymtabFileName == null ? 43 : $breakpadSymtabFileName.hashCode());
        String $stackVariableSymtabFileName = this.getStackVariableSymtabFileName();
        result = result * 59 + ($stackVariableSymtabFileName == null ? 43 : $stackVariableSymtabFileName.hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $arch = this.getArch();
        result = result * 59 + ($arch == null ? 43 : $arch.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $sha1 = this.getSha1();
        result = result * 59 + ($sha1 == null ? 43 : $sha1.hashCode());
        String $soVersion = this.getSoVersion();
        result = result * 59 + ($soVersion == null ? 43 : $soVersion.hashCode());
        String $fileType = this.getFileType();
        result = result * 59 + ($fileType == null ? 43 : $fileType.hashCode());
        String $fileFormat = this.getFileFormat();
        result = result * 59 + ($fileFormat == null ? 43 : $fileFormat.hashCode());
        String $symtabToolVersion = this.getSymtabToolVersion();
        result = result * 59 + ($symtabToolVersion == null ? 43 : $symtabToolVersion.hashCode());
        SymtabFileHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        String $programVaddr = this.getProgramVaddr();
        result = result * 59 + ($programVaddr == null ? 43 : $programVaddr.hashCode());
        String $programOffset = this.getProgramOffset();
        result = result * 59 + ($programOffset == null ? 43 : $programOffset.hashCode());
        return result;
    }

    public String toString() {
        return "SymtabFile(fileName=" + this.getFileName() + ", pathName=" + this.getPathName() + ", symtabFileName=" + this.getSymtabFileName() + ", breakpadSymtabFileName=" + this.getBreakpadSymtabFileName() + ", stackVariableSymtabFileName=" + this.getStackVariableSymtabFileName() + ", appName=" + this.getAppName() + ", arch=" + this.getArch() + ", uuid=" + this.getUuid() + ", sha1=" + this.getSha1() + ", soVersion=" + this.getSoVersion() + ", fileType=" + this.getFileType() + ", fileFormat=" + this.getFileFormat() + ", symtabToolVersion=" + this.getSymtabToolVersion() + ", header=" + this.getHeader() + ", programVaddr=" + this.getProgramVaddr() + ", programOffset=" + this.getProgramOffset() + ")";
    }

    static {
        breakpadFileRandomAccess = null;
        breakpadFuncRandomAccess = null;
        breakpadCfiRandomAccess = null;
        stackVariableRandomAccess = null;
    }
}

