/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.symtab;

import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.symtab.Symbol;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import java.util.Vector;

public class SymtabMerger {
    private static void setSymbolValue(Symbol symbol, Subroutine subroutine) {
        symbol.setAddress(subroutine.getLowPc());
        symbol.setEndAddress(subroutine.getHighPc());
        symbol.setFunction(subroutine.getName());
    }

    public static SymbolTable getSymtabTable(Vector<Subroutine> subroutineTable) {
        SymbolTable symbolTable = new SymbolTable();
        for (Subroutine subroutine : subroutineTable) {
            Symbol symbol = new Symbol();
            SymtabMerger.setSymbolValue(symbol, subroutine);
            symbolTable.add(symbol);
        }
        return symbolTable;
    }

    public static SymbolTable merge(Vector<Subroutine> subroutineTable, SymbolTable symbolTable, String fileType) {
        Symbol symbol;
        Subroutine subroutine;
        int index;
        if (null == subroutineTable || null == symbolTable) {
            return null;
        }
        if (subroutineTable.isEmpty()) {
            return symbolTable;
        }
        SymbolTable newSymbolTable = new SymbolTable();
        if (symbolTable.isEmpty()) {
            for (Subroutine subroutine2 : subroutineTable) {
                Symbol symbol2 = new Symbol();
                SymtabMerger.setSymbolValue(symbol2, subroutine2);
                newSymbolTable.add(symbol2);
            }
            return newSymbolTable;
        }
        Symbol entry = symbolTable.next();
        for (index = 0; index < subroutineTable.size() && (subroutine = subroutineTable.get(index)).below(entry.getAddress()); ++index) {
            Symbol symbol3 = new Symbol();
            SymtabMerger.setSymbolValue(symbol3, subroutine);
            newSymbolTable.add(symbol3);
        }
        Symbol lastEntry = null;
        Subroutine subroutine3 = subroutineTable.get(index);
        Symbol preEntry = null;
        Symbol nextEntry = null;
        while (null != entry) {
            lastEntry = entry;
            if (subroutine3.below(entry.getAddress())) {
                if (++index >= subroutineTable.size()) break;
                subroutine3 = subroutineTable.get(index);
                if (subroutine3.getName().equalsIgnoreCase("unw_getcontext")) {
                    Log.info("", new Object[0]);
                }
                if (!subroutine3.below(entry.getAddress())) continue;
                symbol = new Symbol();
                SymtabMerger.setSymbolValue(symbol, subroutine3);
                newSymbolTable.add(symbol);
                continue;
            }
            if (subroutine3.contain(entry.getAddress())) {
                if (null != preEntry && preEntry.getEndAddress() < entry.getAddress()) {
                    symbol = new Symbol();
                    symbol.setAddress(subroutine3.getLowPc());
                    symbol.setFunction(subroutine3.getName());
                    symbol.setEndAddress(entry.getAddress());
                    if (preEntry.getEndAddress() < subroutine3.getLowPc()) {
                        symbol.setAddress(subroutine3.getLowPc());
                    } else {
                        symbol.setAddress(preEntry.getEndAddress());
                    }
                    if (symbol.getAddress() != symbol.getEndAddress()) {
                        newSymbolTable.add(symbol);
                    }
                }
                nextEntry = symbolTable.next();
                if (!entry.hasFunctionName()) {
                    entry.setFunction(subroutine3.getName());
                    entry.setEndAddress(subroutine3.getHighPc());
                    if (null != nextEntry && nextEntry.getAddress() < subroutine3.getHighPc()) {
                        entry.setEndAddress(nextEntry.getAddress());
                    }
                }
            } else if (subroutine3.beyond(entry.getAddress())) {
                nextEntry = symbolTable.next();
                if (!entry.hasFunctionName()) {
                    entry.setFunction(subroutine3.getName());
                    entry.setEndAddress(subroutine3.getHighPc());
                    if (nextEntry != null && nextEntry.getAddress() < subroutine3.getHighPc()) {
                        entry.setEndAddress(nextEntry.getAddress());
                    }
                    entry.setAddress(subroutine3.getLowPc());
                    if (entry.getAddress() > entry.getEndAddress() && preEntry != null) {
                        entry.setAddress(preEntry.getEndAddress());
                    }
                }
            }
            if (entry.getAddress() < entry.getEndAddress()) {
                newSymbolTable.add(entry);
            }
            preEntry = entry;
            entry = nextEntry;
        }
        while (null != entry) {
            newSymbolTable.add(entry);
            lastEntry = entry;
            entry = symbolTable.next();
        }
        while (index < subroutineTable.size()) {
            subroutine3 = subroutineTable.get(index);
            if (subroutine3.getLowPc() >= lastEntry.getEndAddress()) {
                symbol = new Symbol();
                SymtabMerger.setSymbolValue(symbol, subroutine3);
                newSymbolTable.add(symbol);
            }
            ++index;
        }
        newSymbolTable.sort();
        newSymbolTable.subroutineVariables.addAll(symbolTable.subroutineVariables);
        symbolTable.close();
        for (Symbol symbol4 : newSymbolTable.symbolTable) {
            if (symbol4.getAddress() != 13136244L) continue;
            Log.error("", new Object[0]);
        }
        return newSymbolTable;
    }
}

