/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.symtab;

import com.uqm.crashsight.symtabtool.common.SubroutineVariable;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.symtab.Symbol;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class SymbolTable {
    private static final String FILE_PREFIX = "symtab";
    private static final long TMP_TABLE_MAX_COUNT = 100000L;
    private static final long FLOOR_BORDER = 256L;
    private static boolean cacheToFile = true;
    public final Vector<Symbol> symbolTable = new Vector();
    public final List<SubroutineVariable> subroutineVariables = new ArrayList<SubroutineVariable>();
    private final Vector<File> fileTable;
    private final Comparator<Symbol> comparator = (a, b) -> (int)(a.getAddress() - b.getAddress());
    private File symtabFile = null;
    private BufferedReader symtabFileReader = null;
    private long symbolNumber = 0L;
    private int indexOfSymbolTable = 0;

    public SymbolTable() {
        this.fileTable = new Vector();
    }

    public SymbolTable(boolean cacheToFile) {
        this.fileTable = new Vector();
    }

    public static void setCacheToFile(boolean cacheToFile) {
        SymbolTable.cacheToFile = cacheToFile;
    }

    private void sortTable(Vector<Symbol> symbolTable) {
        symbolTable.sort(this.comparator);
    }

    public File getSymtabFile() {
        return this.symtabFile;
    }

    public long size() {
        return this.symbolNumber;
    }

    public boolean isEmpty() {
        return 0L == this.symbolNumber;
    }

    public Symbol next() {
        int index;
        if (cacheToFile) {
            if (null == this.symtabFileReader && !this.rewind()) {
                return null;
            }
            Symbol symbol = this.readFromFile(this.symtabFileReader);
            if (null == symbol) {
                FileHelper.closeFile(this.symtabFileReader);
                this.symtabFileReader = null;
            }
            return symbol;
        }
        if ((index = this.indexOfSymbolTable++) >= this.symbolTable.size()) {
            return null;
        }
        return this.symbolTable.elementAt(index);
    }

    public Symbol lastNext() {
        int index;
        if (cacheToFile) {
            if (null == this.symtabFileReader && !this.rewind()) {
                return null;
            }
            Symbol symbol = this.lastReadFromFile(this.symtabFileReader);
            if (null == symbol) {
                FileHelper.closeFile(this.symtabFileReader);
                this.symtabFileReader = null;
            }
            return symbol;
        }
        if ((index = this.indexOfSymbolTable++) >= this.symbolTable.size()) {
            return null;
        }
        Symbol symbol = this.symbolTable.elementAt(index);
        return symbol.transformSymbol();
    }

    public boolean rewind() {
        if (cacheToFile) {
            if (null == this.symtabFile) {
                if (!this.symbolTable.isEmpty() || !this.fileTable.isEmpty()) {
                    if (!this.sort()) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            this.symtabFileReader = FileHelper.openFileReader(this.symtabFile);
            if (null == this.symtabFileReader) {
                Log.error("SymbolTable: Failed to open symtab file\uff01", new Object[0]);
                return false;
            }
            return true;
        }
        this.indexOfSymbolTable = 0;
        return true;
    }

    private void createSymtabFile() {
        if (null != this.symtabFile) {
            this.fileTable.add(this.symtabFile);
        }
        this.symbolNumber = 0L;
        String suffix = ".symtab";
        this.symtabFile = FileHelper.createTempFile(FILE_PREFIX, suffix);
        if (null != this.symtabFileReader) {
            FileHelper.closeFile(this.symtabFileReader);
            this.symtabFileReader = null;
        }
    }

    public boolean sort() {
        if (cacheToFile) {
            if (!this.writeToFile(this.symbolTable)) {
                return false;
            }
            this.createSymtabFile();
            return this.mergeFiles();
        }
        this.sortTable(this.symbolTable);
        return true;
    }

    private boolean fillMergeMap(TreeMap<Symbol, BufferedReader> mergMap, Vector<BufferedReader> brTable) {
        block0: for (BufferedReader bufferedReader : brTable) {
            Symbol symbol = this.readFromFile(bufferedReader);
            while (null != symbol) {
                if (mergMap.containsKey(symbol)) {
                    symbol = this.readFromFile(bufferedReader);
                    continue;
                }
                mergMap.put(symbol, bufferedReader);
                continue block0;
            }
        }
        return true;
    }

    private boolean mergeFiles() {
        Vector<BufferedReader> brTable = FileHelper.openFiles(this.fileTable);
        if (null == brTable) {
            Log.error("SymbolTable: Failed to open temp file\uff01", new Object[0]);
            return false;
        }
        BufferedWriter bufferedWriter = FileHelper.openFileWriter(this.symtabFile);
        if (null == bufferedWriter) {
            Log.error("SymbolTable: Failed to open symtab file\uff01", new Object[0]);
            return false;
        }
        TreeMap<Symbol, BufferedReader> mergMap = new TreeMap<Symbol, BufferedReader>(this.comparator);
        if (!this.fillMergeMap(mergMap, brTable)) {
            Log.error("SymbolTable: Failed to initiate merge tree\uff01", new Object[0]);
            return false;
        }
        Symbol preSymbol = new Symbol();
        block0: while (!mergMap.isEmpty()) {
            Map.Entry<Symbol, BufferedReader> entry = mergMap.firstEntry();
            Symbol symbol = entry.getKey();
            if (symbol.getAddress() == 6824704L) {
                boolean bl = true;
            }
            if (symbol.getAddress() >= 256L) {
                this.writeToFile(bufferedWriter, symbol);
                preSymbol = symbol;
                ++this.symbolNumber;
            }
            BufferedReader bufferedReader = entry.getValue();
            mergMap.remove(symbol);
            Symbol next = this.readFromFile(bufferedReader);
            while (null != next) {
                if (mergMap.containsKey(next)) {
                    next = this.readFromFile(bufferedReader);
                    continue;
                }
                mergMap.put(next, bufferedReader);
                continue block0;
            }
        }
        FileHelper.closeFiles(brTable);
        this.deleteTmpFiles();
        if (!FileHelper.closeFile(bufferedWriter)) {
            Log.error("SymbolTable: Failed to close symtab file\uff01", new Object[0]);
        }
        return true;
    }

    private void deleteTmpFiles() {
        for (File file : this.fileTable) {
            file.delete();
        }
        this.fileTable.clear();
    }

    public void close() {
        if (null != this.symtabFileReader) {
            FileHelper.closeFile(this.symtabFileReader);
            this.symtabFileReader = null;
        }
        if (null != this.symtabFile) {
            this.symtabFile.delete();
            this.symtabFile = null;
        }
    }

    private Symbol readFromFile(BufferedReader bufferedReader) {
        try {
            String line = bufferedReader.readLine();
            if (null == line) {
                return null;
            }
            return new Symbol().parseString(line);
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
    }

    private Symbol lastReadFromFile(BufferedReader bufferedReader) {
        try {
            String line = bufferedReader.readLine();
            if (null == line) {
                return null;
            }
            return new Symbol().parseStringLast(line);
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
    }

    private boolean writeToFile(BufferedWriter bufferedWriter, Symbol entry) {
        String line = entry.toString();
        if (null == line) {
            Log.error("SymbolTable: Failed to write symbol to file\uff01", new Object[0]);
            return false;
        }
        try {
            bufferedWriter.write(entry.toString());
            return true;
        }
        catch (IOException e) {
            Log.error(e);
            return false;
        }
    }

    private boolean writeToFile(Vector<Symbol> symbolTable) {
        if (symbolTable.isEmpty()) {
            return true;
        }
        this.sortTable(symbolTable);
        for (Symbol symbol : symbolTable) {
            if (symbol.getAddress() != 13136244L) continue;
            Log.error("", new Object[0]);
        }
        File file = FileHelper.createTempFile(FILE_PREFIX, null);
        if (null == file) {
            return false;
        }
        this.fileTable.add(file);
        BufferedWriter bufferedWriter = FileHelper.openFileWriter(file);
        if (null == bufferedWriter) {
            Log.error("SymbolTable: Failed to open file\uff01", new Object[0]);
            return false;
        }
        for (Symbol entry : symbolTable) {
            if (this.writeToFile(bufferedWriter, entry)) continue;
            Log.error("SymbolTable: Failed to write symbol to file\uff01", new Object[0]);
            return false;
        }
        if (!FileHelper.closeFile(bufferedWriter)) {
            Log.warn("SymbolTable: Failed to close file\uff01", new Object[0]);
        }
        return true;
    }

    public boolean add(Symbol symbol) {
        if (null == symbol) {
            return false;
        }
        if (symbol.getAddress() < 256L) {
            return true;
        }
        if (symbol.getAddress() == 13136244L) {
            Log.error("", new Object[0]);
        }
        if (cacheToFile && (long)this.symbolTable.size() >= 100000L) {
            if (!this.writeToFile(this.symbolTable)) {
                return false;
            }
            this.symbolTable.clear();
        }
        ++this.symbolNumber;
        return this.symbolTable.add(symbol);
    }

    public boolean add(Vector<Symbol> symbolTable) {
        if (null == symbolTable) {
            return false;
        }
        for (Symbol symbol : symbolTable) {
            if (this.add(symbol)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(SymbolTable symbolTable) {
        if (null == symbolTable) {
            return false;
        }
        if (symbolTable.isEmpty()) {
            return true;
        }
        this.symbolTable.addAll(symbolTable.symbolTable);
        if (cacheToFile) {
            File symtabFile = symbolTable.getSymtabFile();
            if (null == symtabFile) {
                return false;
            }
            File file = FileHelper.createTempFile(FILE_PREFIX, null);
            if (null == file) {
                return false;
            }
            this.fileTable.add(file);
            BufferedReader bufferedReader = FileHelper.openFileReader(symtabFile);
            if (null == bufferedReader) {
                Log.error("SymbolTable: Failed to open symtab file\uff01", new Object[0]);
                return false;
            }
            BufferedWriter bufferedWriter = FileHelper.openFileWriter(file);
            if (null == bufferedWriter) {
                Log.error("SymbolTable: Failed to open symtab file\uff01", new Object[0]);
                return false;
            }
            Symbol symbol = this.readFromFile(bufferedReader);
            while (null != symbol) {
                if (!this.writeToFile(bufferedWriter, symbol)) {
                    return false;
                }
                symbol = this.readFromFile(bufferedReader);
            }
            FileHelper.closeFile(bufferedReader);
            FileHelper.closeFile(bufferedWriter);
        }
        this.symbolNumber += symbolTable.size();
        return true;
    }
}

